/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.hue.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.hue.converter.Hue2WorkflowConverter;
import com.aliyun.migration.workflow.migration.hue.domain.HuePackage;
import com.aliyun.migration.workflow.migration.hue.service.HuePackageLoader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueReader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(HueReader.class);

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        Map properties = scheduleDataSource.getProperties();
        String sourFilePath = (String)properties.get("source-file-path");
        if (StringUtils.isBlank((CharSequence)sourFilePath)) {
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"sourceFilePath is null");
        }
        HuePackageLoader.validateHuePackageDir(sourFilePath);
        return Response.buildSuccess();
    }

    public WorkflowProjectPackage read() throws Exception {
        HuePackage huePackage = HuePackageLoader.load(this.taskContext.getSourceFilePackage());
        return Hue2WorkflowConverter.convert(huePackage);
    }
}

