/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.wedata.tools;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.workflow.migration.common.utils.PageUtil;
import com.aliyun.migration.workflow.migration.wedata.tools.ExtendWedataClient;
import com.aliyun.migration.workflow.migration.wedata.tools.TencentBase64;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.DescribeProjectParamDsPageRequest;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.DescribeTaskDetailDsRequest;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.DescribeTaskParamDsRequest;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.DescribeWorkflowCanvasInfoDsRequest;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.DescribeWorkflowParamDsRequest;
import com.aliyun.migration.workflow.migration.wedata.tools.custom.GenCronAndSchedulerDescRequest;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.wedata.v20210820.models.DescribeBatchOperateTaskRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeBatchOperateTaskResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDataSourceListRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDataSourceListResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDependTaskListsRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDependTaskListsResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDsFolderTreeRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDsFolderTreeResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDsParentFolderTreeRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeDsParentFolderTreeResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeIntegrationTaskRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeIntegrationTaskResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeIntegrationTasksRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeIntegrationTasksResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeProjectRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeProjectResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeTaskScriptRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeTaskScriptResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowCanvasInfoRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowCanvasInfoResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowInfoByIdRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowInfoByIdResponse;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowListByProjectIdRequest;
import com.tencentcloudapi.wedata.v20210820.models.DescribeWorkflowListByProjectIdResponse;
import com.tencentcloudapi.wedata.v20210820.models.FindAllFolderRequest;
import com.tencentcloudapi.wedata.v20210820.models.FindAllFolderResponse;
import com.tencentcloudapi.wedata.v20210820.models.GetFileInfoRequest;
import com.tencentcloudapi.wedata.v20210820.models.GetFileInfoResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WedataOpenapiClient {
    private static final Logger log = LoggerFactory.getLogger(WedataOpenapiClient.class);
    ExtendWedataClient client;

    public WedataOpenapiClient(String secretId, String secretKey, String region) {
        try {
            Credential cred = new Credential(secretId, secretKey);
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("wedata.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            this.client = new ExtendWedataClient(cred, region, clientProfile);
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient init error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public JSONObject DescribeProject(String projectId) {
        DescribeProjectRequest request = new DescribeProjectRequest();
        request.setProjectId(projectId);
        try {
            Thread.sleep(50L);
            DescribeProjectResponse resp = this.client.DescribeProject(request);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("Data")) {
                return response.getJSONObject("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeProject error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONArray DescribeWorkflowListByProjectId(String projectId) {
        DescribeWorkflowListByProjectIdRequest request = new DescribeWorkflowListByProjectIdRequest();
        request.setProjectId(projectId);
        try {
            Thread.sleep(50L);
            DescribeWorkflowListByProjectIdResponse resp = this.client.DescribeWorkflowListByProjectId(request);
            JSONObject responseJson = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (responseJson.containsKey("Data")) {
                return responseJson.getJSONArray("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeWorkflowListByProjectId error: " + e.getMessage());
            e.printStackTrace();
        }
        return new JSONArray();
    }

    public JSONObject DescribeWorkflowInfoById(String projectId, String workflowId) {
        DescribeWorkflowInfoByIdRequest request = new DescribeWorkflowInfoByIdRequest();
        request.setProjectId(projectId);
        request.setWorkflowId(workflowId);
        try {
            Thread.sleep(50L);
            DescribeWorkflowInfoByIdResponse resp = this.client.DescribeWorkflowInfoById(request);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("Data")) {
                return response.getJSONObject("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeWorkflowInfoById error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject DescribeWorkflowCanvasInfo(String projectId, String workflowId) {
        DescribeWorkflowCanvasInfoRequest request = new DescribeWorkflowCanvasInfoRequest();
        request.setProjectId(projectId);
        request.setWorkflowId(workflowId);
        try {
            Thread.sleep(50L);
            DescribeWorkflowCanvasInfoResponse resp = this.client.DescribeWorkflowCanvasInfo(request);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("Data")) {
                return response.getJSONObject("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeWorkflowCanvasInfo error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONArray DescribeDependTaskLists(String projectId, List<String> nodeIds) {
        DescribeDependTaskListsRequest request = new DescribeDependTaskListsRequest();
        request.setProjectId(projectId);
        request.setTaskIds(nodeIds.toArray(new String[0]));
        try {
            Thread.sleep(50L);
            DescribeDependTaskListsResponse resp = this.client.DescribeDependTaskLists(request);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("Data")) {
                return response.getJSONArray("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeDependTaskLists error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject DescribeTaskScript(String projectId, String nodeId) {
        DescribeTaskScriptRequest request = new DescribeTaskScriptRequest();
        request.setProjectId(projectId);
        request.setTaskId(nodeId);
        try {
            Thread.sleep(50L);
            DescribeTaskScriptResponse resp = this.client.DescribeTaskScript(request);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("Data")) {
                return response.getJSONObject("Data");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeTaskScript error: " + e.getMessage());
        }
        return null;
    }

    public JSONArray DescribeDataSourceList(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(10);
        paginator.setPageNum(1);
        JSONArray result = new JSONArray();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    DescribeDataSourceListRequest request = new DescribeDataSourceListRequest();
                    request.setPageNumber(Long.valueOf(Integer.toUnsignedLong(p.getPageNum())));
                    request.setPageSize(Long.valueOf(Integer.toUnsignedLong(p.getPageSize())));
                    Thread.sleep(50L);
                    DescribeDataSourceListResponse resp = this.client.DescribeDataSourceList(request);
                    JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
                    JSONArray items = response.getJSONObject("Data").getJSONArray("Rows");
                    if (items == null) {
                        items = new JSONArray();
                    }
                    items.forEach(item -> result.add((Object)((JSONObject)item)));
                    Integer count = items.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(items.toJavaList(JSONObject.class, new JSONReader.Feature[0]));
                    paginateResult.setTotalCount(count.intValue());
                    return paginateResult;
                }
                catch (Exception e) {
                    log.info("WedataOpenapiClient DescribeDataSourceList error: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeDataSourceList error: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public JSONObject DescribeDsFolderTree(String projectId) {
        DescribeDsFolderTreeRequest req = new DescribeDsFolderTreeRequest();
        req.setProjectId(projectId);
        req.setIncludeWorkflow(Boolean.valueOf(true));
        req.setIncludeTask(Boolean.valueOf(true));
        req.setIncludeVirtualTask(Boolean.valueOf(true));
        req.setIncludeTaskFolder(Boolean.valueOf(true));
        req.setIncludeCodeTemplate(Boolean.valueOf(true));
        try {
            Thread.sleep(50L);
            DescribeDsFolderTreeResponse resp = this.client.DescribeDsFolderTree(req);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            this.DecodeAllParamsInDataJson(response);
            return response;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeDsFolderTree error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void DecodeAllParamsInDataJson(JSONObject dataJson) {
        if (dataJson.containsKey("Params")) {
            JSONObject params = JSONObject.parseObject((String)TencentBase64.decode(dataJson.getString("Params")));
            dataJson.put((Object)"Params", (Object)params);
        }
        if (dataJson.containsKey("Children") && !dataJson.getJSONArray("Children").isEmpty()) {
            for (int i = 0; i < dataJson.getJSONArray("Children").size(); ++i) {
                this.DecodeAllParamsInDataJson(dataJson.getJSONArray("Children").getJSONObject(i));
            }
        }
        if (dataJson.containsKey("Data") && !dataJson.getJSONArray("Data").isEmpty()) {
            for (int i = 0; i < dataJson.getJSONArray("Data").size(); ++i) {
                this.DecodeAllParamsInDataJson(dataJson.getJSONArray("Data").getJSONObject(i));
            }
        }
    }

    public String GetFileInfo(String projectId, String filePath) {
        GetFileInfoRequest req = new GetFileInfoRequest();
        req.setProjectId(projectId);
        req.setFilePath(filePath);
        try {
            Thread.sleep(50L);
            GetFileInfoResponse resp = this.client.GetFileInfo(req);
            return AbstractModel.toJsonString((AbstractModel)resp);
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient GetFileInfo error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONArray DescribeBatchOperateTask(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(10);
        paginator.setPageNum(1);
        JSONArray result = new JSONArray();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    DescribeBatchOperateTaskRequest request = new DescribeBatchOperateTaskRequest();
                    request.setProjectId(projectId);
                    request.setPage(String.valueOf(p.getPageNum()));
                    request.setSize(String.valueOf(p.getPageSize()));
                    Thread.sleep(50L);
                    DescribeBatchOperateTaskResponse resp = this.client.DescribeBatchOperateTask(request);
                    JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
                    JSONArray items = response.getJSONObject("Data").getJSONArray("Items");
                    if (items == null) {
                        items = new JSONArray();
                    }
                    items.forEach(item -> result.add((Object)((JSONObject)item)));
                    Integer count = items.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(items.toJavaList(JSONObject.class, new JSONReader.Feature[0]));
                    paginateResult.setTotalCount(count.intValue());
                    return paginateResult;
                }
                catch (Exception e) {
                    log.info("WedataOpenapiClient DescribeBatchOperateTask error: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeBatchOperateTask error: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public JSONArray DescribeIntegrationTasks(String projectId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(10);
        paginator.setPageNum(1);
        JSONArray result = new JSONArray();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    DescribeIntegrationTasksRequest request = new DescribeIntegrationTasksRequest();
                    request.setProjectId(projectId);
                    request.setPageNumber(Long.valueOf(Integer.toUnsignedLong(p.getPageNum())));
                    request.setPageSize(Long.valueOf(Integer.toUnsignedLong(p.getPageSize())));
                    Thread.sleep(50L);
                    DescribeIntegrationTasksResponse resp = this.client.DescribeIntegrationTasks(request);
                    JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
                    JSONArray items = response.getJSONArray("TaskInfoSet");
                    if (items == null) {
                        items = new JSONArray();
                    }
                    items.forEach(item -> result.add((Object)((JSONObject)item)));
                    Integer count = items.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(items.toJavaList(JSONObject.class, new JSONReader.Feature[0]));
                    paginateResult.setTotalCount(count.intValue());
                    return paginateResult;
                }
                catch (Exception e) {
                    log.info("WedataOpenapiClient DescribeBatchOperateTask error: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeBatchOperateTask error: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public JSONArray DescribeIntegrationTasksDetails(String projectId) {
        JSONArray totalList = this.DescribeIntegrationTasks(projectId);
        JSONArray resultList = new JSONArray();
        if (totalList.size() > 0) {
            totalList.forEach(item -> {
                JSONObject task = (JSONObject)item;
                JSONObject taskDetail = this.DescribeIntegrationTask(projectId, task.getString("TaskId"));
                if (taskDetail != null) {
                    resultList.add((Object)taskDetail);
                }
            });
        }
        return resultList;
    }

    public JSONObject DescribeIntegrationTask(String projectId, String taskId) {
        DescribeIntegrationTaskRequest req = new DescribeIntegrationTaskRequest();
        req.setProjectId(projectId);
        req.setTaskId(taskId);
        try {
            Thread.sleep(50L);
            DescribeIntegrationTaskResponse resp = this.client.DescribeIntegrationTask(req);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response != null && response.containsKey("TaskInfo")) {
                return response.getJSONObject("TaskInfo");
            }
            return null;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeIntegrationTask error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject DescribeDsParentFolderTree(String projectId, String taskId) {
        DescribeDsParentFolderTreeRequest req = new DescribeDsParentFolderTreeRequest();
        req.setProjectId(projectId);
        req.setTaskId(taskId);
        try {
            Thread.sleep(50L);
            DescribeDsParentFolderTreeResponse resp = this.client.DescribeDsParentFolderTree(req);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            this.DecodeAllParamsInDataJson(response);
            return response;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeDsParentFolderTree error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject DescribeTaskDetailDs(String projectId, String taskId) {
        DescribeTaskDetailDsRequest req = new DescribeTaskDetailDsRequest();
        req.setProjectId(projectId);
        req.setTaskId(taskId);
        try {
            Thread.sleep(50L);
            JSONObject resp = this.client.DescribeTaskDetailDs(req);
            return resp;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeTaskDetailDs error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject DescribeTaskParamDs(String projectId, String taskId) {
        DescribeTaskParamDsRequest req = new DescribeTaskParamDsRequest();
        req.setProjectId(projectId);
        req.setTaskId(taskId);
        try {
            Thread.sleep(50L);
            JSONObject resp = this.client.DescribeTaskParamDs(req);
            return resp;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeTaskParamDs error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject GenCronAndSchedulerDesc(String projectId, Integer cycleStep, String cycleType, Integer delayTime, String taskAction, String startTime, String executionStartTime, String executionEndTime) {
        GenCronAndSchedulerDescRequest req = new GenCronAndSchedulerDescRequest();
        req.setCycleStep(cycleStep);
        req.setCycleType(cycleType);
        req.setDelayTime(delayTime);
        req.setTaskAction(taskAction);
        req.setStartTime(startTime);
        req.setProjectId(projectId);
        req.setExecutionStartTime(executionStartTime);
        req.setExecutionEndTime(executionEndTime);
        try {
            Thread.sleep(50L);
            JSONObject resp = this.client.GenCronAndSchedulerDesc(req);
            return resp;
        }
        catch (TencentCloudSDKException e) {
            log.info("WedataOpenapiClient GenCronAndSchedulerDesc error: " + e.getMessage() + " Request Id: " + e.getRequestId());
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient GenCronAndSchedulerDesc error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject DescribeWorkflowParamDs(String projectId, String workflowId) {
        DescribeWorkflowParamDsRequest req = new DescribeWorkflowParamDsRequest();
        req.setProjectId(projectId);
        req.setWorkflowId(workflowId);
        try {
            Thread.sleep(50L);
            JSONObject resp = this.client.DescribeWorkflowParamDs(req);
            return resp;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeWorkflowParamDs error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject DescribeWorkflowCanvasInfoDs(String projectId, String workflowId) {
        DescribeWorkflowCanvasInfoDsRequest req = new DescribeWorkflowCanvasInfoDsRequest();
        req.setProjectId(projectId);
        req.setWorkflowId(workflowId);
        try {
            Thread.sleep(50L);
            JSONObject resp = this.client.DescribeWorkflowCanvasInfoDs(req);
            return resp;
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeWorkflowCanvasInfoDs error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public JSONArray FindAllFolder(String projectId) {
        FindAllFolderRequest req = new FindAllFolderRequest();
        req.setProjectId(projectId);
        try {
            Thread.sleep(50L);
            FindAllFolderResponse resp = this.client.FindAllFolder(req);
            JSONObject response = JSONObject.parseObject((String)AbstractModel.toJsonString((AbstractModel)resp));
            if (response.containsKey("FolderList")) {
                return response.getJSONArray("FolderList");
            }
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient FindAllFolder error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public JSONArray DescribeProjectParamDsPage(String projectId, String keyWords) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(10);
        paginator.setPageNum(1);
        JSONArray result = new JSONArray();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    DescribeProjectParamDsPageRequest request = new DescribeProjectParamDsPageRequest();
                    request.setProjectId(projectId);
                    request.setPageNumber(p.getPageNum());
                    request.setPageSize(p.getPageSize());
                    request.setKeyWords(keyWords);
                    Thread.sleep(50L);
                    JSONObject response = this.client.DescribeProjectParamDsPage(request);
                    JSONArray items = response.getJSONObject("Data").getJSONArray("Items");
                    if (items == null) {
                        items = new JSONArray();
                    }
                    for (int i = 0; i < items.size(); ++i) {
                        JSONObject item = items.getJSONObject(i);
                        result.add((Object)item);
                    }
                    Integer count = items.size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(items.toJavaList(JSONObject.class, new JSONReader.Feature[0]));
                    paginateResult.setTotalCount(count.intValue());
                    return paginateResult;
                }
                catch (Exception e) {
                    log.info("WedataOpenapiClient DescribeDataSourceList error: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.info("WedataOpenapiClient DescribeDataSourceList error: " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }
}

