/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DynamicNodeConvert.class);

    public DynamicNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    private Boolean isNewIde() {
        Boolean isNewIde;
        try {
            isNewIde = ((JSONObject)BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()).get("self")).getBoolean("if.use.dataworks.newidea");
        }
        catch (Exception e) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65b0\u7248IDE\u8f6c\u6362\u3002");
            return true;
        }
        if (isNewIde == null) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65e7\u7248IDE\u8f6c\u6362\u3002");
            return true;
        }
        return isNewIde;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (this.isNewIde().booleanValue()) {
            return this.newIdeConvert(workflowNodes);
        }
        DefaultNodeConvert defaultNodeConvert = new DefaultNodeConvert(this.taskContext, this.workflow);
        return defaultNodeConvert.convert(workflowNodes);
    }

    public List<WorkflowNode> newIdeConvert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (BwmJsonUtil.isJsonString((String)workflowNode.getScript()).booleanValue()) {
            JSONObject content = JSONObject.parseObject((String)workflowNode.getScript());
            if (content.containsKey("processDefinitionCode")) {
                long processDefinitionCode = content.getLong("processDefinitionCode");
                HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
                List<Object> paramCombinations = new ArrayList();
                if (content.containsKey("listParameters") && CollectionUtils.isNotEmpty((Collection)content.getJSONArray("listParameters"))) {
                    content.getJSONArray("listParameters").forEach(item -> {
                        String paramName = ((JSONObject)item).getString("name");
                        String paramValue = ((JSONObject)item).getString("value");
                        String paramSeparator = ((JSONObject)item).getString("separator");
                        if (StringUtils.isNotBlank((CharSequence)paramSeparator)) {
                            List<String> paramValues = Arrays.asList(paramValue.split(paramSeparator));
                            params.put(paramName, paramValues);
                        } else {
                            params.put(paramName, Arrays.asList(paramValue));
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(params.keySet())) {
                    paramCombinations = DynamicNodeConvert.generateCombinations(params);
                }
                if (CollectionUtils.isNotEmpty(paramCombinations)) {
                    Integer idCount = 0;
                    for (Map map : paramCombinations) {
                        WorkflowNode newTgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
                        newTgtworkflowNode.setNodeId(workflowNode.getNodeId() + "_" + idCount);
                        newTgtworkflowNode.setNodeName(workflowNode.getNodeName() + "_" + idCount);
                        newTgtworkflowNode.setScript(String.valueOf(processDefinitionCode));
                        newTgtworkflowNode.setNodeType(CodeProgramType.SUB_PROCESS.name());
                        newTgtworkflowNode.setParamMap(map);
                        Integer n = idCount;
                        idCount = idCount + 1;
                        tgtNodes.add(newTgtworkflowNode);
                    }
                } else {
                    WorkflowNode newTgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
                    newTgtworkflowNode.setScript(String.valueOf(processDefinitionCode));
                    newTgtworkflowNode.setNodeType(CodeProgramType.SUB_PROCESS.name());
                    tgtNodes.add(newTgtworkflowNode);
                }
            } else {
                tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.name());
                tgtNodes.add(tgtworkflowNode);
            }
        }
        Map ownerMap = this.getOwnerMapping(this.bwmConfiguration);
        tgtNodes.forEach(node -> {
            if (ownerMap.containsKey(node.getOwner())) {
                node.setOwner((String)ownerMap.get(node.getOwner()));
            }
        });
        return tgtNodes;
    }

    public static List<Map<String, Object>> generateCombinations(Map<String, List<Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (params == null || params.isEmpty()) {
            return result;
        }
        ArrayList<String> paramNames = new ArrayList<String>(params.keySet());
        HashMap<String, Object> currentCombination = new HashMap<String, Object>();
        DynamicNodeConvert.generateCombinationsRecursive(params, paramNames, 0, currentCombination, result);
        return result;
    }

    private static void generateCombinationsRecursive(Map<String, List<Object>> params, List<String> paramNames, int index, Map<String, Object> currentCombination, List<Map<String, Object>> result) {
        if (index == paramNames.size()) {
            result.add(new HashMap<String, Object>(currentCombination));
            return;
        }
        String paramName = paramNames.get(index);
        List<Object> paramValues = params.get(paramName);
        if (paramValues == null || paramValues.isEmpty()) {
            DynamicNodeConvert.generateCombinationsRecursive(params, paramNames, index + 1, currentCombination, result);
            return;
        }
        for (Object paramValue : paramValues) {
            currentCombination.put(paramName, paramValue);
            DynamicNodeConvert.generateCombinationsRecursive(params, paramNames, index + 1, currentCombination, result);
        }
    }

    public static void main(String[] args) {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put("a", Arrays.asList("1", "2"));
        params.put("b", Arrays.asList("3", "4"));
        List<Map<String, Object>> combinations = DynamicNodeConvert.generateCombinations(params);
        System.out.println(combinations);
    }
}

