/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.enums.EngineType;
import com.aliyun.migration.spec.domain.dataworks.node.ResourceFileType;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmRegexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Dolphin3FileConvert
extends AbstractConvert<WorkflowFileResource> {
    private static final Logger log = LoggerFactory.getLogger(Dolphin3FileConvert.class);
    protected Map<String, Object> selfConfMap = new HashMap<String, Object>();
    protected Map<String, Map<String, Object>> confMap = new HashMap<String, Map<String, Object>>();

    public Dolphin3FileConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public WorkflowFileResource convert(WorkflowFileResource workflowFileResource) {
        WorkflowFileResource fileResource = (WorkflowFileResource)BwmJsonUtil.deepCopy((Object)workflowFileResource, WorkflowFileResource.class);
        BwmConfiguration bwmConfiguration = BwmConfiguration.from((String)this.taskContext.getBwmConfiguration());
        this.selfConfMap = bwmConfiguration.getMap("self", new HashMap());
        Object orDefault = this.selfConfMap.getOrDefault("conf", "[]");
        this.confMap = this.getConfMap(orDefault);
        Map<String, Object> fileConfMap = this.getFileConfMap(workflowFileResource);
        if (fileConfMap.containsKey("workflow.converter.target.engine.type")) {
            String targetEngine = fileConfMap.get("workflow.converter.target.engine.type").toString();
            if (StringUtils.equals((CharSequence)targetEngine, (CharSequence)EngineType.EMR.getEngineName())) {
                if (workflowFileResource.getName().endsWith(".jar")) {
                    fileResource.setFileType(ResourceFileType.EMR_JAR.getName());
                } else {
                    fileResource.setFileType(ResourceFileType.EMR_FILE.getName());
                }
            } else if (StringUtils.equals((CharSequence)targetEngine, (CharSequence)EngineType.CDH.getEngineName())) {
                if (workflowFileResource.getName().endsWith(".jar")) {
                    fileResource.setFileType(ResourceFileType.CDH_JAR.getName());
                } else {
                    fileResource.setFileType(ResourceFileType.CDH_FILE.getName());
                }
            } else if (workflowFileResource.getName().endsWith(".py")) {
                fileResource.setFileType(ResourceFileType.ODPS_PYTHON.getName());
            } else if (workflowFileResource.getName().endsWith(".jar")) {
                fileResource.setFileType(ResourceFileType.ODPS_JAR.getName());
            } else if (workflowFileResource.getName().endsWith(".zip") || workflowFileResource.getName().endsWith(".tgz") || workflowFileResource.getName().endsWith(".tar.gz") || workflowFileResource.getName().endsWith(".tar")) {
                fileResource.setFileType(ResourceFileType.ODPS_ARCHIVE.getName());
            } else {
                fileResource.setFileType(ResourceFileType.ODPS_FILE.getName());
            }
        } else if (workflowFileResource.getName().endsWith(".py")) {
            fileResource.setFileType(ResourceFileType.ODPS_PYTHON.getName());
        } else if (workflowFileResource.getName().endsWith(".jar")) {
            fileResource.setFileType(ResourceFileType.ODPS_JAR.getName());
        } else if (workflowFileResource.getName().endsWith(".zip") || workflowFileResource.getName().endsWith(".tgz") || workflowFileResource.getName().endsWith(".tar.gz") || workflowFileResource.getName().endsWith(".tar")) {
            fileResource.setFileType(ResourceFileType.ODPS_ARCHIVE.getName());
        } else {
            fileResource.setFileType(ResourceFileType.ODPS_FILE.getName());
        }
        return fileResource;
    }

    private Map<String, Map<String, Object>> getConfMap(Object orDefault) {
        HashMap<String, Map<String, Object>> resConfMap = new HashMap<String, Map<String, Object>>();
        if (orDefault instanceof JSONArray) {
            JSONArray array = (JSONArray)orDefault;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String nodes = jsonObject.getString("nodes");
                JSONObject ruleJsonObject = jsonObject.getJSONObject("rule");
                BwmConfiguration from = BwmConfiguration.from((String)ruleJsonObject.toString());
                Map settingsMap = from.getMap("settings");
                resConfMap.put(nodes, settingsMap);
            }
        }
        return resConfMap;
    }

    protected Map<String, Object> getFileConfMap(WorkflowFileResource fileResource) {
        Map<String, Object> value;
        ArrayList keyList;
        String key;
        if (CollectionUtils.isEmpty(this.confMap) || Objects.isNull(fileResource)) {
            log.warn("not fond confmap or ndoe is null");
            return new HashMap<String, Object>();
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (!keyList.contains("all")) continue;
            return value;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileResource.getName()}) && keyList.contains(fileResource.getName())) {
                return value;
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileResource.getFileId()}) || !keyList.contains(fileResource.getFileId())) continue;
            return value;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            String keys = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(keys.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            for (String key2 : keyList) {
                if (!BwmRegexUtil.match((String)key2, (String)fileResource.getName())) continue;
                return value;
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (!keyList.contains("normal")) continue;
            return value;
        }
        return new HashMap<String, Object>();
    }
}

