/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils.stack;

import com.aliyun.rapt.commons.utils.Assert;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProvider;
import sun.misc.SharedSecrets;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StackTraceElementProviderJdk
implements StackTraceElementProvider {
    private Throwable throwable;
    private int depth;

    public StackTraceElementProviderJdk(boolean lazy) {
        if (!lazy) {
            this.fillInStackTrace();
        }
    }

    public StackTraceElementProviderJdk() {
        this.fillInStackTrace();
    }

    @Override
    public StackTraceElement[] getStackTraceElements(int from, int to) {
        int theDepth;
        if (this.throwable == null) {
            this.fillInStackTrace();
        }
        Assert.isTrue((theDepth = Math.min(to, this.depth)) > from, "stack depth not fulfilled required from");
        int range = theDepth - from;
        StackTraceElement[] stackTraceElements = new StackTraceElement[range];
        for (int i = 0; i < range; ++i) {
            stackTraceElements[i] = SharedSecrets.getJavaLangAccess().getStackTraceElement(this.throwable, from + i);
        }
        return stackTraceElements;
    }

    @Override
    public StackTraceElement getStackTraceElement(int depth) {
        Assert.isTrue(depth >= 0, "the depth should not less than 0");
        if (this.throwable == null) {
            this.fillInStackTrace();
        }
        return SharedSecrets.getJavaLangAccess().getStackTraceElement(this.throwable, depth);
    }

    @Override
    public int getStackTraceDepth() {
        if (this.throwable == null) {
            this.fillInStackTrace();
        }
        return this.depth;
    }

    @Override
    public void fillInStackTrace() {
        this.throwable = new Exception();
        this.depth = SharedSecrets.getJavaLangAccess().getStackTraceDepth(this.throwable);
    }
}

