/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils.cloud;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.workflow.migration.common.utils.cloud.CallbackProperties;
import com.aliyun.migration.workflow.migration.common.utils.cloud.ExecCallbackMessage;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Base64TopicMessage;
import com.aliyun.mns.model.TopicMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnsClient {
    private static final Logger log = LoggerFactory.getLogger(MnsClient.class);
    private MNSClient client;
    private String topicName;

    public MnsClient(CallbackProperties properties) {
        properties.decrypt();
        this.client = this.init(properties);
        this.topicName = properties.getTopicName();
    }

    private MNSClient init(CallbackProperties prop) {
        if (prop == null) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.MNS_ERROR);
        }
        if (StringUtils.isBlank((CharSequence)prop.getAccessKeyId()) || StringUtils.isBlank((CharSequence)prop.getAccessKeySecret())) {
            String env_ak = System.getenv("LHM_DW_AK");
            String env_sk = System.getenv("LHM_DW_SK");
            prop.setAccessKeyId(env_ak);
            prop.setAccessKeySecret(env_sk);
        }
        if (prop.getLoginType() == null) {
            prop.setLoginType(CloudAccessType.AK);
        }
        switch (prop.getLoginType()) {
            case AK: {
                CloudAccount account = new CloudAccount(prop.getAccessKeyId(), prop.getAccessKeySecret(), prop.getEndpoint());
                return account.getMNSClient();
            }
            case STS: {
                CloudAccount account = new CloudAccount(prop.getAccessKeyId(), prop.getAccessKeySecret(), prop.getSecurityToken(), prop.getEndpoint());
                return account.getMNSClient();
            }
        }
        throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.MNS_ERROR);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public void sendMessage(ExecCallbackMessage callbackMessage) {
        CloudTopic topic = this.client.getTopicRef(this.topicName);
        Base64TopicMessage msg = new Base64TopicMessage();
        try {
            msg.setMessageBody(JSONObject.toJSONString((Object)callbackMessage, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            TopicMessage publishResultMsg = topic.publishMessage((TopicMessage)msg);
            log.info("[MNS] publish message to {}, id:{}", (Object)this.topicName, (Object)publishResultMsg.getMessageId());
        }
        catch (Exception e) {
            log.error("[MNS] publish message to {} error", (Object)this.topicName, (Object)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.MNS_ERROR);
        }
    }
}

