/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipFileUtil.class);
    private static final String SUFFIX_TAR_GZ = ".tar.gz";
    private static final String SUFFIX_GZIP = ".gzip";
    private static final String SUFFIX_TGZ = ".tgz";
    private static final String SUFFIX_ZIP = ".zip";
    private static final String SUFFIX_TAR = ".tar";
    private static final String SUFFIX_GZ = ".gz";
    private static final String TYPE_TGZ = "tgz";
    private static final String TYPE_TAR = "tar";
    private static final String TYPE_ZIP = "zip";
    private static final String TYPE_GZIP = "gzip";
    private static final String DEFAULT = ".package";

    public static File zipDir(File zipPath, File zipFile) throws IOException {
        if (!zipFile.getParentFile().exists() && !zipFile.getParentFile().mkdirs()) {
            log.error(String.format("Zip File [%s] Failed", zipPath));
            throw new RuntimeException("Zip File Error");
        }
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]));){
            zipArchiveOutputStream.setFallbackToUTF8(true);
            ZipFileUtil.zipDirectory(zipPath, zipArchiveOutputStream, "");
        }
        catch (Exception e) {
            log.error("zip directory error: {}, exception: ", (Object)zipPath, (Object)e);
            throw new RuntimeException("zip file error", e);
        }
        if (!zipFile.exists()) {
            throw new RuntimeException("zip file failed, zip not found: " + zipFile.getAbsolutePath());
        }
        return zipFile;
    }

    private static void zipDirectory(File zipPath, ZipArchiveOutputStream zipArchiveOutputStream, String parentDir) throws IOException {
        if (zipPath == null || !zipPath.isDirectory()) {
            return;
        }
        File[] subFiles = zipPath.listFiles();
        if (subFiles == null || subFiles.length == 0) {
            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(parentDir + "/"));
            zipArchiveOutputStream.closeArchiveEntry();
            return;
        }
        for (File subFile : subFiles) {
            if (subFile.isDirectory()) {
                ZipFileUtil.zipDirectory(subFile, zipArchiveOutputStream, parentDir + subFile.getName() + "/");
                continue;
            }
            try (BufferedInputStream fileIns = new BufferedInputStream(Files.newInputStream(subFile.toPath(), new OpenOption[0]));){
                int readBytes;
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(parentDir + subFile.getName()));
                byte[] bytes = new byte[4096];
                while ((readBytes = ((InputStream)fileIns).read(bytes)) > 0) {
                    zipArchiveOutputStream.write(bytes, 0, readBytes);
                }
            }
            catch (Exception e) {
                log.error("zip file {} failed", (Object)subFile);
                throw new RuntimeException("zip file error: " + subFile, e);
            }
            finally {
                zipArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public static File decompress(File packageFile) throws IOException {
        return ZipFileUtil.decompress(packageFile, TYPE_ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File decompress(File packageFile, String defaultType) throws IOException {
        File localDir = new File(packageFile.getAbsolutePath().replaceAll("\\.\\w+$", ""));
        if (localDir.equals(packageFile)) {
            localDir = new File(packageFile.getParentFile(), localDir.getName() + "_unzipped");
        }
        if (!localDir.getParentFile().exists()) {
            localDir.getParentFile().mkdirs();
        }
        log.info("unzip export file to: {}", (Object)localDir);
        log.info("force delete dir: {} ", (Object)localDir);
        if (localDir.exists()) {
            FileUtils.forceDelete((File)localDir);
        }
        File dirPath = localDir;
        ArchiveInputStream archiveInput = null;
        try {
            ArchiveEntry entry;
            archiveInput = ZipFileUtil.createArchiveInputByType(packageFile.getAbsolutePath(), ZipFileUtil.inferType(packageFile.getName(), defaultType));
            ArchiveEntry archiveEntry = entry = archiveInput == null ? null : archiveInput.getNextEntry();
            while (entry != null) {
                File file = new File(dirPath, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else if (!file.isHidden()) {
                    file.getParentFile().mkdirs();
                    ByteStreams.copy((InputStream)archiveInput, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                entry = archiveInput.getNextEntry();
            }
        }
        catch (IOException | ArchiveException | CompressorException e) {
            log.error("decompress file " + packageFile + " failed:", e);
        }
        finally {
            if (archiveInput != null) {
                try {
                    archiveInput.close();
                }
                catch (IOException ex) {
                    log.error("close archive exception: " + ex.getMessage());
                }
            }
        }
        return dirPath;
    }

    private static ArchiveInputStream createArchiveInputByType(String packageFile, String type) throws IOException, CompressorException, ArchiveException {
        Path path = Paths.get(packageFile, new String[0]);
        if (TYPE_TGZ.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream(TYPE_TAR, (InputStream)new CompressorStreamFactory().createCompressorInputStream("gz", Files.newInputStream(path, new OpenOption[0])));
            return archiveInput;
        }
        if (TYPE_ZIP.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream(TYPE_ZIP, Files.newInputStream(path, new OpenOption[0]));
            return archiveInput;
        }
        if (TYPE_GZIP.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream(TYPE_ZIP, (InputStream)new CompressorStreamFactory().createCompressorInputStream("gz", Files.newInputStream(path, new OpenOption[0])));
            return archiveInput;
        }
        if (TYPE_TAR.equals(type)) {
            ArchiveInputStream archiveInput = new ArchiveStreamFactory().createArchiveInputStream(TYPE_TAR, Files.newInputStream(path, new OpenOption[0]));
            return archiveInput;
        }
        return null;
    }

    public static Response checkFileType(String packageFile) {
        String type = ZipFileUtil.inferType(packageFile, DEFAULT);
        ArrayList<String> types = new ArrayList<String>();
        types.add(SUFFIX_TAR_GZ);
        types.add(SUFFIX_GZIP);
        types.add(SUFFIX_TGZ);
        types.add(SUFFIX_ZIP);
        types.add(SUFFIX_TAR);
        types.add(SUFFIX_GZ);
        if (type.equalsIgnoreCase(DEFAULT)) {
            String errorMsg = String.format("unsupported file type ,file type must be %s", String.join((CharSequence)",", types));
            return Response.buildFailure((String)BwmServiceErrorCode.BWM_TYPE_NOT_SUPPORTED_ERROR.getCode(), (String)errorMsg);
        }
        return Response.buildSuccess();
    }

    private static String inferType(String packageFile, String defaultType) {
        if (packageFile.endsWith(SUFFIX_TAR_GZ)) {
            return TYPE_TGZ;
        }
        if (packageFile.endsWith(SUFFIX_GZIP)) {
            return TYPE_GZIP;
        }
        if (packageFile.endsWith(SUFFIX_TGZ)) {
            return TYPE_TGZ;
        }
        if (packageFile.endsWith(SUFFIX_TAR)) {
            return TYPE_TAR;
        }
        if (packageFile.endsWith(SUFFIX_ZIP)) {
            return TYPE_ZIP;
        }
        if (packageFile.endsWith(SUFFIX_GZ)) {
            return TYPE_GZIP;
        }
        return defaultType;
    }

    /*
     * Exception decompiling
     */
    public static void compressFilesToZip(List<String> filePaths, String outputFilePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

