/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonFileReaderUtil.class);

    public static List<String> readJsonFiles(String directoryPath) {
        if (StringUtils.isBlank((CharSequence)directoryPath)) {
            log.warn("Directory path is blank");
            return new ArrayList<String>();
        }
        Path path = Paths.get(directoryPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            log.warn("Directory does not exist: {}", (Object)directoryPath);
            return new ArrayList<String>();
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            log.warn("Path is not a directory: {}", (Object)directoryPath);
            return new ArrayList<String>();
        }
        ArrayList<String> jsonContents = new ArrayList<String>();
        try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
            List jsonFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).sorted().collect(Collectors.toList());
            for (Path jsonFilePath : jsonFiles) {
                String content = JsonFileReaderUtil.readFileContent(jsonFilePath.toFile());
                if (!StringUtils.isNotBlank((CharSequence)content)) continue;
                jsonContents.add(content);
            }
        }
        catch (IOException e) {
            log.error("Failed to traverse directory: {}", (Object)directoryPath, (Object)e);
        }
        return jsonContents;
    }

    private static String readFileContent(File file) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error("Failed to read file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return content.toString();
    }

    public static <T> List<T> readJsonFilesAsObject(String directoryPath, Class<T> clazz) {
        List<String> jsonContents = JsonFileReaderUtil.readJsonFiles(directoryPath);
        ArrayList<T> objects = new ArrayList<T>();
        for (String jsonContent : jsonContents) {
            try {
                T object = BwmJsonUtil.parseObject(jsonContent, clazz);
                if (object == null) continue;
                objects.add(object);
            }
            catch (Exception e) {
                log.error("Failed to parse JSON content to {}: {}", new Object[]{clazz.getSimpleName(), jsonContent, e});
            }
        }
        return objects;
    }

    public static List<Map<String, Object>> readJsonFilesAsMap(String directoryPath) {
        List<String> jsonContents = JsonFileReaderUtil.readJsonFiles(directoryPath);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (String jsonContent : jsonContents) {
            try {
                Map<String, Object> map = BwmJsonUtil.parseMap(jsonContent);
                if (map == null || map.isEmpty()) continue;
                maps.add(map);
            }
            catch (Exception e) {
                log.error("Failed to parse JSON content to Map: {}", (Object)jsonContent, (Object)e);
            }
        }
        return maps;
    }
}

