/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.teleport.common.constants.TeleportMetaStatusCode;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CronUtils {
    private static final Logger log = LoggerFactory.getLogger(CronUtils.class);

    private CronUtils() {
        throw new IllegalStateException("not supported");
    }

    public static ZonedDateTime toZonedDateTime(Date utilDate) {
        if (utilDate == null) {
            return null;
        }
        ZoneId systemDefault = ZoneId.systemDefault();
        return ZonedDateTime.ofInstant(utilDate.toInstant(), systemDefault);
    }

    public static String dateToCron(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
        return sdf.format(date);
    }

    public static Date nextCronDate(String cronExpr, Date startTime) {
        try {
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            Cron cron = parser.parse(cronExpr);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            ZonedDateTime nextBegin = ZonedDateTime.ofInstant(startTime.toInstant(), ZoneId.of("Asia/Shanghai"));
            Optional next = executionTime.nextExecution(nextBegin);
            if (next.isPresent()) {
                return Date.from(((ZonedDateTime)next.get()).toInstant());
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Date nextNextCronDate(String cronExpr, Date startTime) {
        try {
            ZonedDateTime nextTime;
            Optional nextDate;
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            Cron cron = parser.parse(cronExpr);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            ZonedDateTime nextBegin = ZonedDateTime.ofInstant(startTime.toInstant(), ZoneId.of("Asia/Shanghai"));
            Optional next = executionTime.nextExecution(nextBegin);
            if (next.isPresent() && (nextDate = executionTime.nextExecution(nextTime = (ZonedDateTime)next.get())).isPresent()) {
                return Date.from(((ZonedDateTime)nextDate.get()).toInstant());
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Date lastCronDate(String cronExpr, Date startTime) {
        try {
            Date addTime = new Date(startTime.getTime() + 1L);
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            Cron cron = parser.parse(cronExpr);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            ZonedDateTime lastBegin = ZonedDateTime.ofInstant(addTime.toInstant(), ZoneId.of("Asia/Shanghai"));
            Optional next = executionTime.lastExecution(lastBegin);
            if (next.isPresent()) {
                return Date.from(((ZonedDateTime)next.get()).toInstant());
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String formatCronExpression(String cronExpression) {
        if (cronExpression == null || cronExpression.isEmpty()) {
            throw new IllegalArgumentException("Cron expression cannot be null or empty");
        }
        CharSequence[] parts = cronExpression.split(" ");
        if (parts.length != 6 && parts.length != 7) {
            throw new IllegalArgumentException("Invalid cron expression format");
        }
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equals("*") || ((String)parts[i]).equals("?")) continue;
            parts[i] = CronUtils.padWithZero((String)parts[i]);
        }
        return String.join((CharSequence)" ", parts);
    }

    private static String padWithZero(String value) {
        if (value.length() >= 2 || value.contains(",") || value.contains("/") || value.contains("-")) {
            return value;
        }
        return String.format("%02d", Integer.parseInt(value));
    }

    public static void validateCron(String cron) {
        long freq;
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cron) || !CronUtils.isValid(cron)) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.CRON_EXPRESSION_ERROR);
        }
        Date firstTrigger = CronUtils.getNextExecution(cron);
        Date secondTrigger = CronUtils.getNextExecution(firstTrigger, cron);
        if (firstTrigger == null || secondTrigger == null) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.META_PARAM_ERROR, "\u5f53\u524d\u8c03\u5ea6\u914d\u7f6e\u4f4e\u4e8e\u6700\u4f4e\u8c03\u5ea6\u6b21\u6570\u8981\u6c42\uff082\u6b21\uff09\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
        }
        long delta = secondTrigger.getTime() - firstTrigger.getTime();
        if (delta < (freq = 60000L)) {
            throw new TeleportException((TeleportStatusCode)TeleportMetaStatusCode.CRON_FREQUENCY_ERROR);
        }
    }

    public static boolean isValid(String cronExpression) {
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public static String getInvalidMessage(String cronExpression) {
        try {
            new CronExpression(cronExpression);
            return null;
        }
        catch (ParseException pe) {
            return pe.getMessage();
        }
    }

    public static Date getNextExecution(String cronExpression) {
        try {
            if (!StringUtils.hasText((String)cronExpression)) {
                return null;
            }
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(new Date(System.currentTimeMillis()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String getFormattedNextExecution(String cronExpression) {
        try {
            Date next = CronUtils.getNextExecution(cronExpression);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(next);
        }
        catch (Exception e) {
            return "\u8c03\u5ea6\u5230\u671f\uff0c\u8bf7\u68c0\u67e5Cron\u8868\u8fbe\u5f0f";
        }
    }

    public static Date getNextExecution(Date date, String cronExpression) {
        if (date == null) {
            return CronUtils.getNextExecution(cronExpression);
        }
        try {
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static List<String> getNextExecutionList(String cronExpression, int count) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            ArrayList<String> dateList = new ArrayList<String>(count);
            CronExpression cron = new CronExpression(cronExpression);
            Date date = new Date(System.currentTimeMillis());
            for (int i = 0; i < count; ++i) {
                date = cron.getNextValidTimeAfter(date);
                dateList.add(simpleDateFormat.format(date));
            }
            return dateList;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

