/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.workflow.migration.common.bean.BwmJsonArray;
import com.aliyun.migration.workflow.migration.common.bean.BwmJsonObject;
import com.aliyun.migration.workflow.migration.common.context.ApplicationContextUtil;
import com.aliyun.migration.workflow.migration.common.serializes.CustomLocalDateTimeDeserializer;
import com.aliyun.migration.workflow.migration.common.serializes.CustomLocalDateTimeSerializer;
import com.aliyun.migration.workflow.migration.common.serializes.CustomerDateDeserializer;
import com.aliyun.migration.workflow.migration.common.serializes.Object2StringDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectDeserializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(BwmJsonUtil.class);
    private static final ObjectMapper IGNORE_ANNOTATIONS_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper ANNOTATIONS_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    public static <T> T getObjectIgnoreAnnotations(String jsonSting, Class<T> beanClass) {
        if (Objects.nonNull(jsonSting) && Objects.nonNull(beanClass)) {
            try {
                return (T)IGNORE_ANNOTATIONS_OBJECT_MAPPER.readValue(jsonSting, beanClass);
            }
            catch (IOException var3) {
                log.error("convert class error ", (Throwable)var3);
                return null;
            }
        }
        return null;
    }

    public static String getJsonStringIgnoreAnnotations(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        try {
            return IGNORE_ANNOTATIONS_OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (Exception var2) {
            return BwmJsonUtil.doToStringException(o, var2);
        }
    }

    public static ObjectMapper getDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new CustomerDateDeserializer());
        simpleModule.addDeserializer(JSONArray.class, (JsonDeserializer)new JSONArrayDeserializer());
        simpleModule.addDeserializer(JSONObject.class, (JsonDeserializer)new JSONObjectDeserializer());
        simpleModule.addSerializer(JSONArray.class, (JsonSerializer)new JSONArraySerializer());
        simpleModule.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    public static <T> T parseObject(String jsonSting, Class<T> beanClass) {
        if (Objects.nonNull(jsonSting) && Objects.nonNull(beanClass)) {
            try {
                return (T)IGNORE_ANNOTATIONS_OBJECT_MAPPER.readValue(jsonSting, beanClass);
            }
            catch (IOException var3) {
                log.error(BwmJsonUtil.doToObjectException(var3));
                return null;
            }
        }
        return null;
    }

    public static <T> T parseObjectWithAnnotation(String jsonSting, Class<T> beanClass) {
        if (Objects.nonNull(jsonSting) && Objects.nonNull(beanClass)) {
            try {
                return (T)ANNOTATIONS_OBJECT_MAPPER.readValue(jsonSting, beanClass);
            }
            catch (IOException var3) {
                log.error(BwmJsonUtil.doToObjectException(var3));
                return null;
            }
        }
        return null;
    }

    public static <T> T parseObject(String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                return (T)IGNORE_ANNOTATIONS_OBJECT_MAPPER.readValue(jsonString, typeReference);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToObjectException(var2));
                return null;
            }
        }
        return null;
    }

    public static BwmJsonObject parseObject(String jsonString) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                return new BwmJsonObject(jsonString);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToObjectException(var2));
                return null;
            }
        }
        return null;
    }

    public static <T> T parseObject(JSONObject jsonObject, Class<T> clazz) {
        return BwmJsonUtil.parseObject(BwmJsonUtil.toJsonString(jsonObject), clazz);
    }

    public static BwmJsonArray parseArray(String jsonString) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                return new BwmJsonArray(jsonString);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToObjectException(var2));
                return null;
            }
        }
        return null;
    }

    public static <T> List<T> parseArray(String jsonString, Class<T> beanClass) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                JavaType javaType = IGNORE_ANNOTATIONS_OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{beanClass});
                return (List)IGNORE_ANNOTATIONS_OBJECT_MAPPER.readValue(jsonString, javaType);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToListException(var2));
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public static <T> List<T> parseArrayWithAnnotation(String jsonString, Class<T> beanClass) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                JavaType javaType = ANNOTATIONS_OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{beanClass});
                return (List)ANNOTATIONS_OBJECT_MAPPER.readValue(jsonString, javaType);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToListException(var2));
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public static BwmJsonObject toJsonObject(Object o) {
        if (Objects.isNull(o)) {
            return null;
        }
        try {
            if (o instanceof String) {
                return new BwmJsonObject(String.valueOf(o));
            }
            String jsonString = IGNORE_ANNOTATIONS_OBJECT_MAPPER.writeValueAsString(o);
            return new BwmJsonObject(jsonString);
        }
        catch (Exception var2) {
            log.error(BwmJsonUtil.doToStringException(o, var2));
            return null;
        }
    }

    public static BwmJsonObject combineJsonObject(BwmJsonObject baseObj, BwmJsonObject jsonObj) {
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            baseObj.put(next, jsonObj.get(next));
        }
        return baseObj;
    }

    public static Integer removeJsonArrayItem(BwmJsonArray jsonArray, Object item) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!jsonArray.get(i).equals(item)) continue;
            jsonArray.remove(i);
            return i;
        }
        return -1;
    }

    public static String toJsonString(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        try {
            return IGNORE_ANNOTATIONS_OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (Exception var2) {
            return BwmJsonUtil.doToStringException(o, var2);
        }
    }

    public static String toAnnotationJsonString(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        try {
            return ANNOTATIONS_OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (Exception var2) {
            return BwmJsonUtil.doToStringException(o, var2);
        }
    }

    public static Map<String, Object> parseMap(String jsonString) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                return (Map)IGNORE_ANNOTATIONS_OBJECT_MAPPER.readValue(jsonString, Map.class);
            }
            catch (Exception var2) {
                log.error(BwmJsonUtil.doToMapException(var2));
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> parseMap(Object obj) {
        return (Map)IGNORE_ANNOTATIONS_OBJECT_MAPPER.convertValue(obj, Map.class);
    }

    public static Map<String, Object> parseMapWithAnnotation(Object obj) {
        return (Map)ANNOTATIONS_OBJECT_MAPPER.convertValue(obj, Map.class);
    }

    public static boolean validJsonString(String jsonString) {
        try {
            IGNORE_ANNOTATIONS_OBJECT_MAPPER.readTree(jsonString);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String doToMapException(Exception e) {
        return "[String stringToStringObjectMap() cause Jackson Serialization Failed] " + e.getMessage();
    }

    private static String doToListException(Exception e) {
        return "[String jsonString2List() cause Jackson Serialization Failed] " + e.getMessage();
    }

    private static String doToObjectException(Exception e) {
        return "[String getObject() cause Jackson Serialization Failed] " + e.getMessage();
    }

    private static String doToStringException(Object o, Exception e) {
        return "[Object toString() cause Jackson Serialization Failed] [" + o.getClass().getName() + "] " + e.getMessage();
    }

    public static <T> T readValueFromJson(String value, TypeReference<T> typeReference) {
        ObjectMapper objectMapper = ApplicationContextUtil.getBean(ObjectMapper.class);
        if (Objects.isNull(objectMapper)) {
            objectMapper = DEFAULT_OBJECT_MAPPER;
        }
        return (T)objectMapper.readValue(value, typeReference);
    }

    public static <T, K> T deepCopy(K sourceObj, Class<T> target) {
        if (Objects.isNull(sourceObj)) {
            return null;
        }
        return BwmJsonUtil.getObjectIgnoreAnnotations(BwmJsonUtil.getJsonStringIgnoreAnnotations(sourceObj), target);
    }

    public static Boolean isJsonString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        try {
            com.alibaba.fastjson2.JSONObject.parseObject((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        IGNORE_ANNOTATIONS_OBJECT_MAPPER.configure(MapperFeature.USE_ANNOTATIONS, Boolean.FALSE.booleanValue());
        IGNORE_ANNOTATIONS_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        IGNORE_ANNOTATIONS_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        IGNORE_ANNOTATIONS_OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(String.class, (JsonDeserializer)new Object2StringDeserializer());
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new CustomerDateDeserializer());
        simpleModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new CustomLocalDateTimeDeserializer());
        simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)new CustomLocalDateTimeSerializer());
        simpleModule.addSerializer(Integer.class, (JsonSerializer)new NumberSerializers.IntegerSerializer(String.class));
        simpleModule.addDeserializer(JSONArray.class, (JsonDeserializer)new JSONArrayDeserializer());
        simpleModule.addDeserializer(JSONObject.class, (JsonDeserializer)new JSONObjectDeserializer());
        simpleModule.addSerializer(JSONArray.class, (JsonSerializer)new JSONArraySerializer());
        simpleModule.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
        IGNORE_ANNOTATIONS_OBJECT_MAPPER.registerModule((Module)simpleModule);
        ANNOTATIONS_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ANNOTATIONS_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

