/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class BwmIdValidateUtil {
    public Boolean workflowIdChecking(List<Workflow> workflowList) {
        HashSet<String> workflowIdList = new HashSet<String>(workflowList.stream().map(Workflow::getWorkflowId).toList());
        return workflowList.size() != workflowIdList.size();
    }

    public Boolean nodeIdChecking(List<Workflow> workflowList) {
        List<String> nodeIdList = workflowList.stream().map(Workflow::getWorkflowNodes).flatMap(Collection::stream).map(WorkflowNode::getNodeId).toList();
        HashSet<String> nodeIdSet = new HashSet<String>(nodeIdList);
        return nodeIdList.size() != nodeIdSet.size();
    }

    public void workflowIdDeduplication(List<Workflow> workflowList) {
        if (this.workflowIdChecking(workflowList).booleanValue()) {
            return;
        }
        workflowList.forEach(workflow -> workflow.setWorkflowId(BwmIdValidateUtil.getMD5(workflow.getProjectId() + workflow.getProjectName() + workflow.getWorkflowId() + workflow.getWorkflowName())));
    }

    public void nodeIdDeduplication(List<Workflow> workflowList) {
        if (this.nodeIdChecking(workflowList).booleanValue()) {
            return;
        }
        workflowList.forEach(workflow -> workflow.getWorkflowNodes().forEach(node -> node.setNodeId(BwmIdValidateUtil.getMD5(node.getProjectId() + node.getProjectName() + node.getWorkflowId() + node.getWorkflowName() + node.getNodeId() + node.getNodeName()))));
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

