/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.bean.HttpClientRes;
import com.aliyun.migration.workflow.migration.common.bean.HttpGetWithEntity;
import com.aliyun.migration.workflow.migration.common.bean.HttpMethodEnum;
import com.aliyun.migration.workflow.migration.common.bean.LogLevel;
import com.aliyun.securitysdk.SecurityUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class BwmHttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(BwmHttpClientUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(BwmHttpClientUtil.class);
    private static final Integer MAX_TIME_OUT = 5000;
    private static final Integer MAX_SO_TIME_OUT = 30000;
    private static final Integer MAX_REQUEST_TIME_OUT = 5000;
    private static final Integer MAX_CONN = 200;
    private static final Integer MAX_CONN_PER_HOST = 10;
    private static final Integer MAX_IDLE_TIME_OUT = 0;
    private static final PoolingHttpClientConnectionManager POOL_CONN_MANAGER = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static CloseableHttpClient httpClient;
    private static final Map<String, String> DEFAULT_JSON_HEADER;

    public static String supplyHttpProtol(String url) {
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = "http://" + (String)url;
        }
        return url;
    }

    public static String uploadFile(String url, Map<String, String> headers, File srcFile) {
        String tgtFilePath = "";
        FileBody fileBody = new FileBody(srcFile, ContentType.MULTIPART_FORM_DATA, srcFile.getName());
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        builder.addPart("file", (ContentBody)fileBody);
        HttpEntity httpEntity = builder.build();
        httpPost.setEntity(httpEntity);
        try {
            SecurityUtil.startSSRFNetHookChecking((String)url);
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            tgtFilePath = BwmHttpClientUtil.parseResponse(execute);
        }
        catch (Exception e) {
            logger.error("upload file error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.META_FILE_UPLOAD_FAILED);
        }
        finally {
            POOL_CONN_MANAGER.closeExpiredConnections();
            POOL_CONN_MANAGER.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
            SecurityUtil.stopSSRFNetHookChecking();
        }
        return tgtFilePath;
    }

    public static void downloadFile(String url, Map<String, String> headers, File tgtFile) {
        HttpGetWithEntity httpGet = new HttpGetWithEntity(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpGet, headers);
        try (CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpGet);){
            SecurityUtil.startSSRFNetHookChecking((String)url);
            int statusCode = execute.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                BwmHttpClientUtil.saveToFile(execute.getEntity(), tgtFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("HttpClientUtils.httpRequest HttpException caught, URL:" + url + ", msg:", e);
        }
        finally {
            POOL_CONN_MANAGER.closeExpiredConnections();
            POOL_CONN_MANAGER.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
            SecurityUtil.stopSSRFNetHookChecking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadUrlToTempFile(String downloadUrl, String fileName, String fileSuffix, int retryCount) throws IOException {
        log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cURL: {}", (Object)downloadUrl);
        Path tempPath = Files.createTempFile(fileName, fileSuffix, new FileAttribute[0]);
        File tempFile = tempPath.toFile();
        log.debug("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempFile.getAbsolutePath());
        try {
            SecurityUtil.startSSRFNetHookChecking((String)downloadUrl);
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            try (InputStream in = connection.getInputStream();){
                long bytesCopied = Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
                log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0cURL: {}, \u4e34\u65f6\u6587\u4ef6\u8def\u5f84: {}, \u6587\u4ef6\u5927\u5c0f: {} bytes", new Object[]{downloadUrl, tempFile.getAbsolutePath(), bytesCopied});
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempPath);
                log.warn("\u4e0b\u8f7d\u5931\u8d25\uff0c\u5df2\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempPath);
            }
            catch (IOException deleteException) {
                log.warn("\u4e0b\u8f7d\u5931\u8d25\u4e14\u65e0\u6cd5\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)tempPath, (Object)deleteException);
            }
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0cURL: {}", (Object)downloadUrl, (Object)e);
            if (retryCount < 2) {
                File file = BwmHttpClientUtil.downloadUrlToTempFile(downloadUrl, fileName, fileSuffix, ++retryCount);
                return file;
            }
            throw new IOException("Failed to download file from URL: " + downloadUrl, e);
        }
        finally {
            SecurityUtil.stopSSRFNetHookChecking();
        }
        return tempFile;
    }

    public static String getUrlFileContent(String downloadUrl) throws IOException {
        File tempFile = BwmHttpClientUtil.downloadUrlToTempFile(downloadUrl, "temp", ".txt", 0);
        String result = new String(Files.readAllBytes(tempFile.toPath()));
        if (tempFile.exists()) {
            tempFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadUrlToFile(String downloadUrl, File targetFile, int retryCount) throws IOException {
        try {
            SecurityUtil.startSSRFNetHookChecking((String)downloadUrl);
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            try (InputStream in = connection.getInputStream();){
                long bytesCopied = Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0cURL: {}, \u4e34\u65f6\u6587\u4ef6\u8def\u5f84: {}, \u6587\u4ef6\u5927\u5c0f: {} bytes", new Object[]{downloadUrl, targetFile.getAbsolutePath(), bytesCopied});
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(targetFile.toPath());
                log.warn("\u4e0b\u8f7d\u5931\u8d25\uff0c\u5df2\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)targetFile);
            }
            catch (IOException deleteException) {
                log.warn("\u4e0b\u8f7d\u5931\u8d25\u4e14\u65e0\u6cd5\u6e05\u7406\u4e34\u65f6\u6587\u4ef6: {}", (Object)targetFile, (Object)deleteException);
            }
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0cURL: {}", (Object)downloadUrl, (Object)e);
            if (retryCount < 2) {
                File file = BwmHttpClientUtil.downloadUrlToFile(downloadUrl, targetFile, ++retryCount);
                return file;
            }
            throw new IOException("Failed to download file from URL: " + downloadUrl, e);
        }
        finally {
            SecurityUtil.stopSSRFNetHookChecking();
        }
        return targetFile;
    }

    public static File downloadUrlsToTempFolder(Map<String, String> downloadFileUrl, String tenantId) throws IOException {
        log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6\uff0cURL: {}", downloadFileUrl);
        Path tempPath = Files.createTempDirectory(tenantId + "_" + System.currentTimeMillis(), new FileAttribute[0]);
        File tempPathFile = tempPath.toFile();
        FileUtils.forceMkdir((File)tempPathFile);
        log.debug("\u6279\u91cf\u4e0b\u8f7d\u6587\u4ef6\u5230\u4e34\u65f6\u8def\u5f84: {}", (Object)tempPathFile.getAbsolutePath());
        for (String fileName : downloadFileUrl.values()) {
            String downloadUrl = downloadFileUrl.get(fileName);
            File tempFile = new File(tempPathFile, fileName);
            BwmHttpClientUtil.downloadUrlToFile(downloadUrl, tempFile, 0);
        }
        return tempPathFile;
    }

    private static void saveToFile(HttpEntity entity, File tgtFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(tgtFile);){
            if (entity != null) {
                entity.writeTo((OutputStream)fileOutputStream);
            }
            logger.info("File saved successfully.");
        }
        catch (IOException e) {
            logger.error("file saved error ", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.META_FILE_SAVE_FAILED);
        }
    }

    private static CloseableHttpClient getConnection() {
        CloseableHttpClient httpClient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setConnectionManager((HttpClientConnectionManager)POOL_CONN_MANAGER).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
        if (POOL_CONN_MANAGER.getTotalStats() != null) {
            logger.warn("now client pool {}", (Object)POOL_CONN_MANAGER.getTotalStats().toString());
        }
        return httpClient;
    }

    public static HttpClientRes httpRequestWithJsonHeader(HttpMethodEnum methodType, String url, String body) {
        return BwmHttpClientUtil.httpRequest(methodType, url, body, DEFAULT_JSON_HEADER, LogLevel.debug);
    }

    public static HttpClientRes httpRequest(HttpMethodEnum methodType, String url, String body, Map<String, String> headerMap) {
        return BwmHttpClientUtil.httpRequest(methodType, url, body, headerMap, LogLevel.debug);
    }

    public static HttpClientRes httpRequest(HttpMethodEnum methodType, String url, String body, Map<String, String> headerMap, LogLevel logLevel) {
        HttpClientRes var11;
        try {
            CloseableHttpResponse response = null;
            if (methodType.equals((Object)HttpMethodEnum.HEAD)) {
                response = BwmHttpClientUtil.doHead(url, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.DELETE)) {
                response = BwmHttpClientUtil.doDelete(url, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.POST)) {
                response = BwmHttpClientUtil.doPost(url, body, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.PUT)) {
                response = BwmHttpClientUtil.doPut(url, body, headerMap);
            } else if (methodType.equals((Object)HttpMethodEnum.GET)) {
                response = BwmHttpClientUtil.doGet(url, body, headerMap);
            } else {
                if (!methodType.equals((Object)HttpMethodEnum.PATCH)) {
                    logger.error("method not fit, methodType:" + methodType.name());
                    HttpClientRes httpClientRes = null;
                    return httpClientRes;
                }
                response = BwmHttpClientUtil.doPatch(url, body, headerMap);
            }
            ArrayList<String> reqLogs = new ArrayList<String>();
            reqLogs.add("====HttpClient RequestURL: " + url);
            reqLogs.add("====HttpClient RequestHeader: " + JSON.toJSONString(headerMap));
            reqLogs.add("====HttpClient RequestBody: " + body);
            BwmHttpClientUtil.httpLog(reqLogs, logLevel);
            int statusCode = response.getStatusLine().getStatusCode();
            ArrayList<Header> headerList = new ArrayList<Header>();
            headerList.addAll(Arrays.asList(response.getAllHeaders()));
            String responseBody = BwmHttpClientUtil.parseResponse(response);
            ArrayList<String> respLogs = new ArrayList<String>();
            respLogs.add("====HttpClient ResponseCode: " + statusCode);
            respLogs.add("====HttpClient ResponseBody: " + responseBody);
            BwmHttpClientUtil.httpLog(respLogs, logLevel);
            var11 = new HttpClientRes(statusCode, headerList, responseBody);
        }
        catch (Exception var15) {
            throw new RuntimeException("HttpClientUtils.httpRequest HttpException caught, URL:" + url + ", msg:", var15);
        }
        finally {
            POOL_CONN_MANAGER.closeExpiredConnections();
            POOL_CONN_MANAGER.closeIdleConnections((long)MAX_IDLE_TIME_OUT.intValue(), TimeUnit.SECONDS);
        }
        return var11;
    }

    private static void httpLog(List<String> contents, LogLevel logLevel) {
        if (!CollectionUtils.isEmpty(contents) && LogLevel.none != logLevel) {
            if (LogLevel.info == logLevel) {
                for (String content : contents) {
                    logger.info(content);
                }
            }
            if (LogLevel.debug == logLevel) {
                for (String content : contents) {
                    logger.debug(content);
                }
            }
            if (LogLevel.warn == logLevel) {
                for (String content : contents) {
                    logger.warn(content);
                }
            }
            if (LogLevel.error == logLevel) {
                for (String content : contents) {
                    logger.error(content);
                }
            }
        }
    }

    private static CloseableHttpResponse doPost(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPost.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPost, headers);
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    private static CloseableHttpResponse doPatch(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPatch httpPatch = new HttpPatch(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPatch.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPatch, headers);
        return httpClient.execute((HttpUriRequest)httpPatch);
    }

    private static CloseableHttpResponse doPut(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpPut.setEntity((HttpEntity)new StringEntity(bodyJsonParams, StandardCharsets.UTF_8));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpPut, headers);
        return httpClient.execute((HttpUriRequest)httpPut);
    }

    private static CloseableHttpResponse doDelete(String url, Map<String, String> headers) throws IOException {
        HttpDelete httpDelete = new HttpDelete(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpDelete, headers);
        return httpClient.execute((HttpUriRequest)httpDelete);
    }

    private static CloseableHttpResponse doGet(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)bodyJsonParams)) {
            Map paramMap = (Map)JSON.parseObject((String)bodyJsonParams, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            if (!CollectionUtils.isEmpty((Map)paramMap)) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    paramList.add(new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())));
                }
            }
            String fmtParamStr = null;
            if (!CollectionUtils.isEmpty(paramList)) {
                fmtParamStr = URLEncodedUtils.format(paramList, (Charset)Consts.UTF_8);
            }
            if (StringUtils.isNotBlank(fmtParamStr)) {
                url = url.contains("?") ? String.format("%s&%s", url, fmtParamStr) : String.format("%s?%s", url, fmtParamStr);
            }
        }
        HttpGetWithEntity httpGet = new HttpGetWithEntity(url);
        if (StringUtils.isNotEmpty((CharSequence)bodyJsonParams)) {
            httpGet.setEntity((HttpEntity)new StringEntity(bodyJsonParams, ContentType.APPLICATION_JSON));
        }
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpGet, headers);
        return httpClient.execute((HttpUriRequest)httpGet);
    }

    private static CloseableHttpResponse doHead(String url, Map<String, String> headers) throws IOException {
        HttpHead httpHead = new HttpHead(url);
        BwmHttpClientUtil.addHeader((HttpUriRequest)httpHead, headers);
        return httpClient.execute((HttpUriRequest)httpHead);
    }

    private static String parseResponse(CloseableHttpResponse response) {
        String defaultCharset = "UTF-8";
        if (response.getEntity() != null && response.getEntity().getContentType() != null) {
            Header type = response.getEntity().getContentType();
            logger.debug("Type:" + type.getValue());
            String charset = BwmHttpClientUtil.getCharSet(type.getValue());
            if (!StringUtils.isEmpty((CharSequence)charset)) {
                defaultCharset = charset;
            }
        }
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)defaultCharset);
        }
        catch (Exception var4) {
            logger.error("\u89e3\u6790http\u8fd4\u56de\u503c\u51fa\u9519\u5566" + var4.toString());
            return null;
        }
    }

    private static String getCharSet(String content) {
        String regex = ".*charset=([^;]*).*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static void addHeader(HttpUriRequest httpUriRequest, Map<String, String> headers) {
        if (httpUriRequest != null && headers != null && !headers.keySet().isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                httpUriRequest.addHeader(key, value);
            }
        }
    }

    static {
        DEFAULT_JSON_HEADER = new HashMap<String, String>();
        POOL_CONN_MANAGER.setMaxTotal(MAX_CONN.intValue());
        POOL_CONN_MANAGER.setDefaultMaxPerRoute(MAX_CONN_PER_HOST.intValue());
        requestConfig = RequestConfig.custom().setConnectionRequestTimeout(MAX_REQUEST_TIME_OUT.intValue()).setSocketTimeout(MAX_SO_TIME_OUT.intValue()).setConnectTimeout(MAX_TIME_OUT.intValue()).build();
        httpClient = BwmHttpClientUtil.getConnection();
        DEFAULT_JSON_HEADER.put("Content-Type", "application/json;charset=UTF-8");
    }
}

