/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.teleport.common.element.meta.Version;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BwmCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(BwmCommonUtil.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\$)\\{?(\\w+)\\}?");

    public static String replaceVariable(String param) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(param);
        while (matcher.find()) {
            String variable = matcher.group(2);
            String value = System.getProperty(variable);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = matcher.group();
            }
            mapping.put(matcher.group(), value);
        }
        String retString = param;
        for (String key : mapping.keySet()) {
            retString = retString.replace(key, (CharSequence)mapping.get(key));
        }
        return retString;
    }

    public static Map<String, Object> convertObjMap(Map<String, String> dataMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(dataMap)) {
            return resultMap;
        }
        resultMap.putAll(dataMap);
        return resultMap;
    }

    public static Map<String, String> convertStrMap(Map<String, Object> dataMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(dataMap)) {
            return resultMap;
        }
        dataMap.forEach((k, v) -> {
            if (Objects.isNull(v)) {
                return;
            }
            resultMap.put((String)k, v.toString());
        });
        return resultMap;
    }

    public static Map<String, Object> convertMapFromStr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new HashMap<String, Object>();
        }
        return BwmJsonUtil.parseObject(str, Map.class);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        if (Objects.isNull(date)) {
            log.error("date is null, default use now()");
            return LocalDateTime.now();
        }
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        return zonedDateTime.toLocalDateTime();
    }

    public static String getTaskNameByInput(String input) {
        if (StringUtils.isBlank((CharSequence)input) || !input.contains(".")) {
            return input;
        }
        return input.substring(input.lastIndexOf(".") + 1);
    }

    public static String createConvertMetaVersion() {
        return Version.ofLatestConvertVersion().toString();
    }

    public static CodeProgramType getCodeType(String nodeType) {
        if (StringUtils.isBlank((CharSequence)nodeType)) {
            return null;
        }
        CodeProgramType codeProgramType = NumberUtils.isDigits((String)nodeType) ? CodeProgramType.getNodeTypeByCode((int)Integer.parseInt(nodeType)) : CodeProgramType.getNodeTypeByName((String)nodeType);
        return codeProgramType;
    }

    public static String getPluginLoadPath() {
        return System.getProperty("plugin.path", BwmCommonConstant.PLUGIN_PATH);
    }

    public static String getPluginExternalLoadPath() {
        String pluginPath = System.getenv("plugin.external.path");
        if (StringUtils.isBlank((CharSequence)pluginPath)) {
            log.warn("not found env : plugin.external.path ");
            return System.getProperty("plugin.external.path", BwmCommonConstant.PLUGIN_PATH);
        }
        return pluginPath;
    }
}

