/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.type;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public enum DbType {
    MYSQL(0, "mysql"),
    POSTGRESQL(1, "postgresql"),
    HIVE(2, "hive"),
    SPARK(3, "spark"),
    CLICKHOUSE(4, "clickhouse"),
    POLARDB_MYSQL(5, "polardb_mysql"),
    POLARDB_PG(6, "polardb_pg"),
    POLARDB_O(7, "polardb_o"),
    POLARDB_DRDS(8, "polardb_drds"),
    REDIS(9, "redis"),
    MONGODB(10, "mongodb"),
    HBASE(11, "hbase"),
    LINDORM(12, "lindorm"),
    CASSANDRA(13, "cassandra"),
    ADB_MYSQL(14, "adb_mysql"),
    ADB_PG(15, "abd_pg"),
    DLA(16, "dla"),
    ORACLE(17, "oracle"),
    SQLSERVER(18, "sqlserver"),
    DB2(19, "db2"),
    PRESTO(20, "presto"),
    H2(21, "h2"),
    REDSHIFT(22, "redshift"),
    ATHENA(23, "athena"),
    TRINO(24, "trino"),
    STARROCKS(25, "starrocks"),
    AZURESQL(26, "azuresql"),
    DAMENG(27, "dameng"),
    OCEANBASE(28, "oceanbase"),
    SSH(29, "ssh"),
    KYUUBI(30, "kyuubi"),
    DATABEND(31, "databend"),
    SNOWFLAKE(32, "snowflake"),
    VERTICA(33, "vertica"),
    HANA(34, "hana"),
    DORIS(35, "doris"),
    MARIADB(36, "mariadb"),
    MAXCOMPUTE(37, "maxcompute"),
    GDB(38, "gdb"),
    GAUSSDB(39, "gaussdb"),
    DLI(40, "dli"),
    DATABRICKS(41, "databricks"),
    SYNAPSE(42, "synapse"),
    UNKUNWN(43, "unknown");

    private static final Map<Integer, DbType> DB_TYPE_MAP;
    private final int code;
    private final String descp;

    private DbType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static DbType of(int type) {
        if (DB_TYPE_MAP.containsKey(type)) {
            return DB_TYPE_MAP.get(type);
        }
        return null;
    }

    public static DbType ofName(String name) {
        return Arrays.stream(DbType.values()).filter(e -> e.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no such db type"));
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public boolean isHive() {
        return this == HIVE;
    }

    public boolean isSupportMultipleStatement() {
        return this.isHive() || this == SPARK;
    }

    static {
        DB_TYPE_MAP = Arrays.stream(DbType.values()).collect(Collectors.toMap(DbType::getCode, Functions.identity()));
    }
}

