/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.spi;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.api.plugin.PluginEntity;
import com.aliyun.migration.api.plugin.PluginType;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.workflow.migration.common.jarload.JarLoader;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHandler.class);
    private static final Map<String, Class<? extends Reader>> READER_CACHE = new ConcurrentHashMap<String, Class<? extends Reader>>();
    private static final Map<String, Class<? extends Writer>> WRITE_CACHE = new ConcurrentHashMap<String, Class<? extends Writer>>();
    private static final Map<String, Class<? extends Converter>> CONVERT_CACHE = new ConcurrentHashMap<String, Class<? extends Converter>>();
    private static String JAR_PATH = BwmCommonUtil.getPluginExternalLoadPath();

    private PluginHandler() {
    }

    private static void loadExtenalClass(String keyword, String className) {
        if (StringUtils.isBlank((CharSequence)JAR_PATH) || !new File(JAR_PATH).exists()) {
            log.debug("extenal plugin path is not found");
            return;
        }
        log.info("start load extenal plugin class");
        Object[] paths = new String[]{JAR_PATH};
        log.info("load path is {}", paths);
        JarLoader classLoader = new JarLoader((String[])paths);
        PluginHandler.loadClass(classLoader, keyword, className);
    }

    public static void register(String keyword, String className) {
        Boolean aBoolean = PluginHandler.loadClass(PluginHandler.class.getClassLoader(), keyword, className);
        if (aBoolean.booleanValue()) {
            log.info("register plugin success {}", (Object)className);
            return;
        }
        PluginHandler.loadExtenalClass(keyword, className);
    }

    private static Boolean loadClass(ClassLoader classLoader, String keyword, String className) {
        keyword = keyword.toUpperCase(Locale.ROOT);
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("class not found {}", (Object)className);
            return Boolean.FALSE;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            if (READER_CACHE.containsKey(keyword)) {
                log.warn("Already registered reader: {},{},will be replaced", (Object)keyword, READER_CACHE.get(keyword));
            }
            READER_CACHE.put(keyword, clazz);
        } else if (Writer.class.isAssignableFrom(clazz)) {
            if (WRITE_CACHE.containsKey(keyword)) {
                log.warn("Already registered writer: {},{},will be replaced", (Object)keyword, WRITE_CACHE.get(keyword));
            }
            WRITE_CACHE.put(keyword, clazz);
        } else if (Converter.class.isAssignableFrom(clazz)) {
            if (CONVERT_CACHE.containsKey(keyword)) {
                log.warn("Already registered converter: {},{},will be replaced", (Object)keyword, CONVERT_CACHE.get(keyword));
            }
            CONVERT_CACHE.put(keyword, clazz);
        } else {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"register plugin failed");
        }
        log.debug("current plugin register finish {} ,{}", (Object)keyword, (Object)className);
        return Boolean.TRUE;
    }

    public static Reader getReader(String readerType) {
        if (StringUtils.isBlank((CharSequence)readerType)) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"readerType can not be null");
        }
        Class<? extends Reader> aClass = READER_CACHE.get(readerType = readerType.toUpperCase(Locale.ROOT));
        if (null == aClass) {
            log.error("failed get reader {}", (Object)readerType);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"reader not found");
        }
        Reader reader = null;
        try {
            reader = aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("reader instance failed {}", (Object)readerType, (Object)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"reader instance failed");
        }
        return reader;
    }

    public static Writer getWriter(String writerType) {
        Class<? extends Writer> aClass = WRITE_CACHE.get(writerType = writerType.toUpperCase(Locale.ROOT));
        if (null == aClass) {
            log.error("failed get writer {}", (Object)writerType);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"writer not found");
        }
        Writer writer = null;
        try {
            writer = aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("writer instance failed {}", (Object)writerType, (Object)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"writer instance failed");
        }
        return writer;
    }

    public static Converter getConverter(String converterType) {
        Class<? extends Converter> aClass = CONVERT_CACHE.get(converterType = converterType.toUpperCase(Locale.ROOT));
        if (null == aClass) {
            log.error("failed get converter {}", (Object)converterType);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"converter not found");
        }
        Converter converter = null;
        try {
            converter = aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("writer instance failed {}", (Object)converterType, (Object)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"converter instance failed");
        }
        return converter;
    }

    public static List<PluginEntity> listPluginByType(String type) {
        ArrayList<PluginEntity> res = new ArrayList<PluginEntity>();
        PluginType pluginType = PluginType.getByName((String)type);
        if (Objects.isNull(pluginType)) {
            log.error("not found the plugin type , should be {}", (Object)Arrays.stream(PluginType.values()).map(PluginType::getName).collect(Collectors.joining(",")));
            return res;
        }
        switch (pluginType) {
            case READER: {
                PluginHandler.addReaderPlugin(res);
                break;
            }
            case WRITER: {
                PluginHandler.addWritePlugin(res);
                break;
            }
            case CONVERTER: {
                PluginHandler.addConvertPlugin(res);
                break;
            }
            default: {
                PluginHandler.addReaderPlugin(res);
                PluginHandler.addConvertPlugin(res);
                PluginHandler.addWritePlugin(res);
            }
        }
        return res;
    }

    private static void addReaderPlugin(List<PluginEntity> res) {
        if (null == res) {
            res = new ArrayList<PluginEntity>();
        }
        for (Map.Entry<String, Class<? extends Reader>> readerEntry : READER_CACHE.entrySet()) {
            PluginEntity build = PluginEntity.builder().name(readerEntry.getKey()).pluginType(PluginType.READER).className(readerEntry.getValue().getName()).build();
            res.add(build);
        }
    }

    private static void addConvertPlugin(List<PluginEntity> res) {
        if (null == res) {
            res = new ArrayList<PluginEntity>();
        }
        for (Map.Entry<String, Class<? extends Converter>> readerEntry : CONVERT_CACHE.entrySet()) {
            PluginEntity build = PluginEntity.builder().name(readerEntry.getKey()).pluginType(PluginType.CONVERTER).className(readerEntry.getValue().getName()).build();
            res.add(build);
        }
    }

    private static void addWritePlugin(List<PluginEntity> res) {
        if (null == res) {
            res = new ArrayList<PluginEntity>();
        }
        for (Map.Entry<String, Class<? extends Writer>> readerEntry : WRITE_CACHE.entrySet()) {
            PluginEntity build = PluginEntity.builder().name(readerEntry.getKey()).pluginType(PluginType.WRITER).className(readerEntry.getValue().getName()).build();
            res.add(build);
        }
    }

    public static void cleanPlugin() {
        READER_CACHE.clear();
        WRITE_CACHE.clear();
        CONVERT_CACHE.clear();
    }

    public static String listPlugin(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return "";
        }
        PluginType pluginType = PluginType.getByName((String)type);
        switch (pluginType) {
            case READER: {
                return StringUtils.join((Iterable)((Set)Optional.of(READER_CACHE.keySet()).orElse(new HashSet())).stream().map(x -> x.toLowerCase(Locale.ROOT)).collect(Collectors.toList()), (String)"\n");
            }
            case WRITER: {
                return StringUtils.join((Iterable)((Set)Optional.of(WRITE_CACHE.keySet()).orElse(new HashSet())).stream().map(x -> x.toLowerCase(Locale.ROOT)).collect(Collectors.toList()), (String)"\n");
            }
            case CONVERTER: {
                return StringUtils.join((Iterable)((Set)Optional.of(CONVERT_CACHE.keySet()).orElse(new HashSet())).stream().map(x -> x.toLowerCase(Locale.ROOT)).collect(Collectors.toList()), (String)"\n");
            }
        }
        return "";
    }
}

