/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.report.InstanceMappingOverviewSheetProperties;
import com.aliyun.migration.api.constant.report.InstanceMappingSheetProperties;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageSrResultStatisticFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageSrResultStatisticFileOperator.class);
    private static Charset charset = Charset.forName("UTF-8");

    public static void writeDiscoverySrResultMappingOverviewFile(List<WorkflowProjectPackage> pkg, BwmSaasConfiguration bwmSaasConfiguration) {
        JSONArray mappingSrJsonArray = new JSONArray();
        String mappingSrFilePath = bwmSaasConfiguration.getDiscoverySrStatisticsFileSavePath("task_result", null);
        HashSet workflowIdSet = new HashSet();
        HashSet nodeIdSet = new HashSet();
        HashSet resourceIdSet = new HashSet();
        HashSet udfIdSet = new HashSet();
        HashSet datasourceIdSet = new HashSet();
        if (CollectionUtils.isNotEmpty(pkg)) {
            for (WorkflowProjectPackage workflowProjectPackage : pkg) {
                if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
                    workflowIdSet.addAll(workflowProjectPackage.getWorkflowList().stream().map(Workflow::getWorkflowId).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
                    for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                        if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                        nodeIdSet.addAll(workflow.getWorkflowNodes().stream().map(WorkflowNode::getNodeId).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getFiles())) {
                    resourceIdSet.addAll(workflowProjectPackage.getFiles().stream().map(WorkflowFileResource::getFileId).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
                }
                if (!CollectionUtils.isEmpty((Collection)workflowProjectPackage.getFunctions())) {
                    udfIdSet.addAll(workflowProjectPackage.getFunctions().stream().map(WorkflowFunctionResource::getFunctionId).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
                }
                if (CollectionUtils.isEmpty((Collection)workflowProjectPackage.getDatasources())) continue;
                datasourceIdSet.addAll(workflowProjectPackage.getDatasources().stream().map(WorkflowDatasource::getDatasourceId).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
            }
        }
        mappingSrJsonArray.add((Object)InstanceMappingOverviewSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).workflow_src_total(Integer.valueOf(workflowIdSet.size())).workflow_tgt_total(Integer.valueOf(-1)).workflow_success_count(Integer.valueOf(-1)).workflow_fail_count(Integer.valueOf(-1)).node_src_total(Integer.valueOf(nodeIdSet.size())).node_tgt_total(Integer.valueOf(-1)).node_success_count(Integer.valueOf(-1)).node_fail_count(Integer.valueOf(-1)).resource_src_total(Integer.valueOf(resourceIdSet.size())).resource_tgt_total(Integer.valueOf(-1)).resource_success_count(Integer.valueOf(-1)).resource_fail_count(Integer.valueOf(-1)).udf_src_total(Integer.valueOf(udfIdSet.size())).udf_tgt_total(Integer.valueOf(-1)).udf_success_count(Integer.valueOf(-1)).udf_fail_count(Integer.valueOf(-1)).datasource_src_total(Integer.valueOf(datasourceIdSet.size())).datasource_tgt_total(Integer.valueOf(-1)).datasource_success_count(Integer.valueOf(-1)).datasource_fail_count(Integer.valueOf(-1)).status(Integer.valueOf(-1)).detail(null).build().getValuesForSR());
        try {
            FileUtils.write((File)new File(mappingSrFilePath), (CharSequence)mappingSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrResultMappingOverviewFile error", (Throwable)e);
        }
    }

    public static void writeMigrationSrResultMappingOverviewFile(WorkflowProjectPackage srcPkg, WorkflowProjectPackage tgtPkg, StatisticOp statisticOp, BwmSaasConfiguration bwmSaasConfiguration) {
        if (statisticOp == null) {
            log.warn("\u672a\u83b7\u53d6\u5230StatisticOp\u7edf\u8ba1\u4fe1\u606f\uff0c\u8df3\u8fc7\u5b58\u50a8");
            return;
        }
        JSONArray mappingSrJsonArray = new JSONArray();
        String mappingSrFilePath = bwmSaasConfiguration.getMigrationSrStatisticsFileSavePath("task_result");
        Integer workflowSrcTotal = 0;
        Integer workflowTgtTotal = 0;
        Integer nodeSrcTotal = 0;
        Integer nodeTgtTotal = 0;
        Integer resourceSrcTotal = 0;
        Integer resourceTgtTotal = 0;
        Integer udfSrcTotal = 0;
        Integer udfTgtTotal = 0;
        Integer datasourceSrcTotal = 0;
        Integer datasourceTgtTotal = 0;
        Integer successCount = Optional.of(statisticOp.getWorkflowSuccessStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowNodeSuccessStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowResourceSuccessStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowFunSuccessStatisticOp().getAtomicInteger().intValue()).orElse(0);
        Integer failCount = Optional.of(statisticOp.getWorkflowFailureStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowNodeFailureStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowResourceFailureStatisticOp().getAtomicInteger().intValue()).orElse(0) + Optional.of(statisticOp.getWorkflowFunFailureStatisticOp().getAtomicInteger().intValue()).orElse(0);
        InstanceMappingOverviewSheetProperties.Status status = InstanceMappingOverviewSheetProperties.Status.SUCCESS;
        status = failCount == 0 ? InstanceMappingOverviewSheetProperties.Status.SUCCESS : (successCount == 0 ? InstanceMappingOverviewSheetProperties.Status.FAILED : InstanceMappingOverviewSheetProperties.Status.PARTIAL_SUCCESS);
        if (srcPkg != null) {
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getWorkflowList())) {
                workflowSrcTotal = workflowSrcTotal + srcPkg.getWorkflowList().size();
                for (Workflow workflow : srcPkg.getWorkflowList()) {
                    if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                    nodeSrcTotal = nodeSrcTotal + workflow.getWorkflowNodes().size();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getFiles())) {
                resourceSrcTotal = resourceSrcTotal + srcPkg.getFiles().size();
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getFunctions())) {
                udfSrcTotal = udfSrcTotal + srcPkg.getFunctions().size();
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getDatasources())) {
                datasourceSrcTotal = datasourceSrcTotal + srcPkg.getDatasources().size();
            }
        }
        if (tgtPkg != null) {
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getWorkflowList())) {
                workflowTgtTotal = workflowTgtTotal + tgtPkg.getWorkflowList().size();
                for (Workflow workflow : tgtPkg.getWorkflowList()) {
                    if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                    nodeTgtTotal = nodeTgtTotal + workflow.getWorkflowNodes().size();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getFiles())) {
                resourceTgtTotal = resourceTgtTotal + tgtPkg.getFiles().size();
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getFunctions())) {
                udfTgtTotal = udfTgtTotal + tgtPkg.getFunctions().size();
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getDatasources())) {
                datasourceTgtTotal = datasourceTgtTotal + tgtPkg.getDatasources().size();
            }
        }
        mappingSrJsonArray.add((Object)InstanceMappingOverviewSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).workflow_src_total(workflowSrcTotal).workflow_tgt_total(workflowTgtTotal).workflow_success_count(Optional.of(statisticOp.getWorkflowSuccessStatisticOp().getAtomicInteger().intValue()).orElse(-1)).workflow_fail_count(Optional.of(statisticOp.getWorkflowFailureStatisticOp().getItermAndMsgs().size()).orElse(-1)).node_src_total(nodeSrcTotal).node_tgt_total(nodeTgtTotal).node_success_count(Optional.of(statisticOp.getWorkflowNodeSuccessStatisticOp().getItermAndMsgs().size()).orElse(-1)).node_fail_count(Optional.of(statisticOp.getWorkflowNodeFailureStatisticOp().getItermAndMsgs().size()).orElse(-1)).resource_src_total(resourceSrcTotal).resource_tgt_total(resourceTgtTotal).resource_success_count(Optional.of(statisticOp.getWorkflowResourceSuccessStatisticOp().getItermAndMsgs().size()).orElse(-1)).resource_fail_count(Optional.of(statisticOp.getWorkflowResourceFailureStatisticOp().getItermAndMsgs().size()).orElse(-1)).udf_src_total(udfSrcTotal).udf_tgt_total(udfTgtTotal).udf_success_count(Optional.of(statisticOp.getWorkflowFunSuccessStatisticOp().getItermAndMsgs().size()).orElse(-1)).udf_fail_count(Optional.of(statisticOp.getWorkflowFunFailureStatisticOp().getItermAndMsgs().size()).orElse(-1)).datasource_src_total(datasourceSrcTotal).datasource_tgt_total(Integer.valueOf(-1)).datasource_success_count(Integer.valueOf(-1)).datasource_fail_count(Integer.valueOf(-1)).status(Integer.valueOf(status.getCode())).detail(null).build().getValuesForSR());
        try {
            FileUtils.write((File)new File(mappingSrFilePath), (CharSequence)mappingSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrResultMappingOverviewFile error", (Throwable)e);
        }
    }

    public static void writeMigrationSrResultMappingOverviewFile(WorkflowProjectPackage srcPkg, WorkflowProjectPackage tgtPkg, BwmSaasConfiguration bwmSaasConfiguration) {
        JSONArray mappingSrJsonArray = new JSONArray();
        String mappingSrFilePath = bwmSaasConfiguration.getMigrationSrStatisticsFileSavePath("task_result");
        Integer workflowSrcTotal = 0;
        Integer workflowTgtTotal = 0;
        Integer nodeSrcTotal = 0;
        Integer nodeTgtTotal = 0;
        Integer resourceSrcTotal = 0;
        Integer resourceTgtTotal = 0;
        Integer udfSrcTotal = 0;
        Integer udfTgtTotal = 0;
        Integer datasourceSrcTotal = 0;
        Integer datasourceTgtTotal = 0;
        InstanceMappingOverviewSheetProperties.Status status = InstanceMappingOverviewSheetProperties.Status.SUCCESS;
        if (srcPkg != null) {
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getWorkflowList())) {
                workflowSrcTotal = workflowSrcTotal + srcPkg.getWorkflowList().size();
                for (Workflow workflow : srcPkg.getWorkflowList()) {
                    if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                    nodeSrcTotal = nodeSrcTotal + workflow.getWorkflowNodes().size();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getFiles())) {
                resourceSrcTotal = resourceSrcTotal + srcPkg.getFiles().size();
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getFunctions())) {
                udfSrcTotal = udfSrcTotal + srcPkg.getFunctions().size();
            }
            if (!CollectionUtils.isEmpty((Collection)srcPkg.getDatasources())) {
                datasourceSrcTotal = datasourceSrcTotal + srcPkg.getDatasources().size();
            }
        }
        if (tgtPkg != null) {
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getWorkflowList())) {
                workflowTgtTotal = workflowTgtTotal + tgtPkg.getWorkflowList().size();
                for (Workflow workflow : tgtPkg.getWorkflowList()) {
                    if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) continue;
                    nodeTgtTotal = nodeTgtTotal + workflow.getWorkflowNodes().size();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getFiles())) {
                resourceTgtTotal = resourceTgtTotal + tgtPkg.getFiles().size();
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getFunctions())) {
                udfTgtTotal = udfTgtTotal + tgtPkg.getFunctions().size();
            }
            if (!CollectionUtils.isEmpty((Collection)tgtPkg.getDatasources())) {
                datasourceTgtTotal = datasourceTgtTotal + tgtPkg.getDatasources().size();
            }
        }
        mappingSrJsonArray.add((Object)InstanceMappingOverviewSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).workflow_src_total(workflowSrcTotal).workflow_tgt_total(workflowTgtTotal).workflow_success_count(Integer.valueOf(-1)).workflow_fail_count(Integer.valueOf(-1)).node_src_total(nodeSrcTotal).node_tgt_total(nodeTgtTotal).node_success_count(Integer.valueOf(-1)).node_fail_count(Integer.valueOf(-1)).resource_src_total(resourceSrcTotal).resource_tgt_total(resourceTgtTotal).resource_success_count(Integer.valueOf(-1)).resource_fail_count(Integer.valueOf(-1)).udf_src_total(udfSrcTotal).udf_tgt_total(udfTgtTotal).udf_success_count(Integer.valueOf(-1)).udf_fail_count(Integer.valueOf(-1)).datasource_src_total(datasourceSrcTotal).datasource_tgt_total(Integer.valueOf(-1)).datasource_success_count(Integer.valueOf(-1)).datasource_fail_count(Integer.valueOf(-1)).status(Integer.valueOf(status.getCode())).detail(null).build().getValuesForSR());
        try {
            FileUtils.write((File)new File(mappingSrFilePath), (CharSequence)mappingSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrResultMappingOverviewFile error", (Throwable)e);
        }
    }

    public static void writeMigrationSrResultMappingFile(WorkflowProjectPackage workflowProjectPackage, StatisticOp statisticOp, BwmSaasConfiguration bwmSaasConfiguration) {
        if (statisticOp == null) {
            log.warn("\u672a\u83b7\u53d6\u5230StatisticOp\u7edf\u8ba1\u4fe1\u606f\uff0c\u8df3\u8fc7\u5b58\u50a8");
            return;
        }
        JSONArray mappingSrJsonArray = new JSONArray();
        String mappingSrFilePath = bwmSaasConfiguration.getMigrationSrStatisticsFileSavePath("conversion_mapping");
        mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.PROJECT).source_id(workflowProjectPackage.getWorkflowProject().getProjectId()).target_id(workflowProjectPackage.getWorkflowProject().getProjectId()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail(null).build().getValuesForSR());
        if (statisticOp.getWorkflowSuccessStatisticOp() != null && statisticOp.getWorkflowSuccessStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowSuccessStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowSuccessStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.WORKFLOW).source_id((String)item.getKey()).target_id((String)item.getKey()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowFailureStatisticOp() != null && statisticOp.getWorkflowFailureStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowFailureStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowFailureStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.WORKFLOW).source_id((String)item.getKey()).target_id(null).status(Integer.valueOf(InstanceMappingSheetProperties.Status.FAILED.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getNodeMappings() != null && statisticOp.getNodeMappings().size() > 0) {
            for (StatisticOp.NodeMapping nodeMapping : statisticOp.getNodeMappings()) {
                mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.NODE).source_id(nodeMapping.getSrcNodeId()).target_id(nodeMapping.getTgtNodeId()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail(null).build().getValuesForSR());
            }
        } else if (statisticOp.getWorkflowNodeSuccessStatisticOp() != null && statisticOp.getWorkflowNodeSuccessStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowNodeSuccessStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowNodeSuccessStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.NODE).source_id((String)item.getKey()).target_id((String)item.getKey()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowNodeFailureStatisticOp() != null && statisticOp.getWorkflowNodeFailureStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowNodeFailureStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowNodeFailureStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.NODE).source_id((String)item.getKey()).target_id(null).status(Integer.valueOf(InstanceMappingSheetProperties.Status.FAILED.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowFunSuccessStatisticOp() != null && statisticOp.getWorkflowFunSuccessStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowFunSuccessStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowFunSuccessStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.UDF).source_id((String)item.getKey()).target_id((String)item.getKey()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowFunFailureStatisticOp() != null && statisticOp.getWorkflowFunFailureStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowFunFailureStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowFunFailureStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.UDF).source_id((String)item.getKey()).target_id(null).status(Integer.valueOf(InstanceMappingSheetProperties.Status.FAILED.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowResourceSuccessStatisticOp() != null && statisticOp.getWorkflowResourceSuccessStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowResourceSuccessStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowResourceSuccessStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.RESOURCE).source_id((String)item.getKey()).target_id((String)item.getKey()).status(Integer.valueOf(InstanceMappingSheetProperties.Status.SUCCESS.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        if (statisticOp.getWorkflowResourceFailureStatisticOp() != null && statisticOp.getWorkflowResourceFailureStatisticOp().getItermAndMsgs() != null && statisticOp.getWorkflowResourceFailureStatisticOp().getItermAndMsgs().size() > 0) {
            statisticOp.getWorkflowResourceFailureStatisticOp().getItermAndMsgs().forEach(item -> mappingSrJsonArray.add((Object)InstanceMappingSheetProperties.builder().tenant_id(bwmSaasConfiguration.getMeta().getTenantUuid()).instance_id(bwmSaasConfiguration.getMeta().getInstanceUuid()).mapping_type(InstanceMappingSheetProperties.MappingType.RESOURCE).source_id((String)item.getKey()).target_id(null).status(Integer.valueOf(InstanceMappingSheetProperties.Status.FAILED.getCode())).inner_success_count(null).detail((String)item.getValue()).build().getValuesForSR()));
        }
        try {
            FileUtils.write((File)new File(mappingSrFilePath), (CharSequence)mappingSrJsonArray.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrResultMappingFile error", (Throwable)e);
        }
    }
}

