/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.BwmCommonConstant;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageXlsReportFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmScriptNodeUtil;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageFileOperator.class);
    private static Charset charset = Charset.forName("UTF-8");

    public static String writeFile(WorkflowProjectPackage workflowProjectPackage, StatisticOp localXlsStatisticOp, File targetPackageFile) throws IOException {
        File targetTmp = new File(targetPackageFile.getParentFile(), ".tmp");
        BwmPackageFileOperator.exportPackageMainPart(workflowProjectPackage, targetTmp, targetPackageFile.getName());
        BwmPackageXlsReportFileOperator.writeStatisticOp(localXlsStatisticOp, targetTmp);
        ZipFileUtil.zipDir(targetTmp, targetPackageFile);
        log.info("zipped file: {}", (Object)targetPackageFile);
        FileUtils.deleteDirectory((File)targetTmp);
        return targetPackageFile.getPath();
    }

    public static String writeFile(WorkflowProjectPackage workflowProjectPackage, File targetPackageFile) throws IOException {
        File targetTmp = new File(targetPackageFile.getParentFile(), ".tmp");
        BwmPackageFileOperator.exportPackageMainPart(workflowProjectPackage, targetTmp, targetPackageFile.getName());
        ZipFileUtil.zipDir(targetTmp, targetPackageFile);
        log.info("zipped file: {}", (Object)targetPackageFile);
        FileUtils.deleteDirectory((File)targetTmp);
        return targetPackageFile.getPath();
    }

    public static void exportPackageMainPart(WorkflowProjectPackage workflowProjectPackage, File targetTmp, String targetDirName) throws IOException {
        if (targetTmp.exists()) {
            FileUtils.deleteDirectory((File)targetTmp);
        }
        String filenameWithoutFileType = targetDirName;
        if (targetDirName.lastIndexOf(46) != -1) {
            filenameWithoutFileType = targetDirName.substring(0, targetDirName.lastIndexOf(46));
        }
        File targetRootDir = new File(targetTmp, filenameWithoutFileType);
        File targetProjectDir = new File(targetTmp, filenameWithoutFileType + "/data/project");
        FileUtils.forceMkdir((File)targetProjectDir);
        BwmPackageFileOperator.writeProject(workflowProjectPackage.getWorkflowProject(), new File(targetProjectDir, "project.json"));
        BwmPackageFileOperator.writeDatasource(workflowProjectPackage.getDatasources(), new File(targetProjectDir, "datasource.json"));
        File projectScriptDir = new File(targetProjectDir, "script");
        FileUtils.forceMkdir((File)projectScriptDir);
        BwmPackageFileOperator.buildNodeScriptSavePath(workflowProjectPackage);
        if (workflowProjectPackage.getFiles() != null) {
            for (WorkflowFileResource file : workflowProjectPackage.getFiles()) {
                if (file.getCustomProperties() != null && file.getCustomProperties().containsKey("RawScript")) {
                    FileUtils.writeStringToFile((File)new File(targetRootDir, file.getPath()), (String)file.getCustomProperties().get("RawScript").toString(), (Charset)charset);
                    file.getCustomProperties().put("RawScript", null);
                    continue;
                }
                File sourceFile = new File(file.getPath());
                if (!sourceFile.exists()) {
                    sourceFile = new File(workflowProjectPackage.getFilePath(), file.getPath());
                }
                if (!sourceFile.exists()) {
                    log.warn("\u539f\u6587\u4ef6\u4e22\u5931\uff0c\u65e0\u6cd5\u8f6c\u79fb\u6587\u4ef6\uff1a{}", (Object)file.getPath());
                    continue;
                }
                String newPath = BwmPackageFileOperator.buildFileResourceSavePath(file);
                if (sourceFile.isFile()) {
                    FileUtils.copyFile((File)sourceFile, (File)new File(targetRootDir, newPath));
                } else {
                    FileUtils.forceMkdir((File)new File(targetRootDir, newPath));
                }
                file.setPath(newPath);
            }
            BwmPackageFileOperator.writeFileResource(workflowProjectPackage.getFiles(), new File(targetProjectDir, "files.json"));
        }
        File targetWorkflowDirFile = new File(targetProjectDir.getPath(), "workflow");
        FileUtils.forceMkdir((File)targetWorkflowDirFile);
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            File workflowDir = new File(targetWorkflowDirFile, Optional.ofNullable((workflow.getWorkflowName() + "#" + workflow.getWorkflowId()).replaceAll("/", "_")).orElse(UUID.randomUUID().toString()));
            FileUtils.forceMkdir((File)workflowDir);
            BwmPackageFileOperator.workflowNodeScriptDealing(workflow, targetRootDir, projectScriptDir);
            File targetWorkflowFile = new File(workflowDir, "workflow.json");
            Workflow wf = BwmJsonUtil.deepCopy(workflow, Workflow.class);
            wf.setWorkflowNodes(null);
            wf.setNodeRelations(null);
            wf.setTriggers(null);
            wf.setFiles(null);
            wf.setFunctions(null);
            FileUtils.writeStringToFile((File)targetWorkflowFile, (String)BwmJsonUtil.toJsonString(wf), (Charset)charset);
            File targetNodeDir = new File(workflowDir, "nodeSpec.json");
            FileUtils.writeStringToFile((File)targetNodeDir, (String)BwmJsonUtil.toJsonString(workflow.getWorkflowNodes()), (Charset)charset);
            File nodeRelationDir = new File(workflowDir, "nodeRelationSpec.json");
            FileUtils.writeStringToFile((File)nodeRelationDir, (String)BwmJsonUtil.toJsonString(workflow.getNodeRelations()), (Charset)charset);
            if (Objects.nonNull(workflow.getTriggers())) {
                File triggerDir = new File(workflowDir, "trigger.json");
                FileUtils.writeStringToFile((File)triggerDir, (String)BwmJsonUtil.toJsonString(workflow.getTriggers()), (Charset)charset);
            }
            if (Objects.nonNull(workflow.getFunctions())) {
                List functions = workflow.getFunctions();
                File funFile = new File(workflowDir, "functions.json");
                FileUtils.writeStringToFile((File)funFile, (String)BwmJsonUtil.toJsonString(functions), (Charset)charset);
            }
            if (!Objects.nonNull(workflow.getFiles())) continue;
            List files = workflow.getFiles();
            File filesFile = new File(workflowDir, "files.json");
            for (WorkflowFileResource file : files) {
                if (file.getCustomProperties() != null && file.getCustomProperties().containsKey("RawScript")) {
                    FileUtils.writeStringToFile((File)new File(targetRootDir, file.getPath()), (String)file.getCustomProperties().get("RawScript").toString(), (Charset)charset);
                    file.getCustomProperties().put("RawScript", null);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)file.getPath())) {
                    log.warn("\u672a\u83b7\u53d6\u6587\u4ef6\uff0c\u8df3\u8fc7\u8f6c\u79fb\u6587\u4ef6\u8f6c\u79fb\uff1a{}", (Object)file.getName());
                    continue;
                }
                File sourceFile = new File(file.getPath());
                if (!sourceFile.exists()) {
                    sourceFile = new File(workflowProjectPackage.getFilePath(), file.getPath());
                }
                if (!sourceFile.exists()) {
                    log.warn("\u539f\u6587\u4ef6\u4e22\u5931\uff0c\u65e0\u6cd5\u8f6c\u79fb\u6587\u4ef6\uff1a{}", (Object)file.getPath());
                    continue;
                }
                String newPath = BwmPackageFileOperator.buildFileResourceSavePath(file, workflow);
                if (sourceFile.isFile()) {
                    FileUtils.copyFile((File)sourceFile, (File)new File(targetRootDir, newPath));
                } else {
                    FileUtils.forceMkdir((File)new File(targetRootDir, newPath));
                }
                file.setPath(newPath);
            }
            FileUtils.writeStringToFile((File)filesFile, (String)BwmJsonUtil.toJsonString(files), (Charset)charset);
        }
    }

    private static void workflowNodeScriptDealing(Workflow workflow, File targetRootDir, File projectScriptDir) throws IOException {
        if (CollectionUtils.isEmpty((Collection)workflow.getWorkflowNodes())) {
            return;
        }
        for (WorkflowNode node : workflow.getWorkflowNodes()) {
            if (StringUtils.isEmpty((CharSequence)node.getScriptPath())) continue;
            File targetScriptFile = new File(targetRootDir, node.getScriptPath());
            FileUtils.writeStringToFile((File)targetScriptFile, (String)node.getScript(), (Charset)charset);
            if (node.getNodeType().equalsIgnoreCase("SQL")) {
                targetProjectScriptDir = StringUtils.isEmpty((CharSequence)node.getDbType()) ? new File(projectScriptDir, "SQL/UNDEFINED") : new File(projectScriptDir, "SQL/" + node.getDbType());
                if (!targetProjectScriptDir.exists()) {
                    FileUtils.forceMkdir((File)targetProjectScriptDir);
                }
                targetProjectScriptDir = new File(targetProjectScriptDir, targetScriptFile.getName());
                FileUtils.writeStringToFile((File)targetProjectScriptDir, (String)node.getScript(), (Charset)charset);
            } else {
                targetProjectScriptDir = new File(projectScriptDir, node.getNodeType());
                if (!targetProjectScriptDir.exists()) {
                    FileUtils.forceMkdir((File)targetProjectScriptDir);
                }
                targetProjectScriptDir = new File(targetProjectScriptDir, targetScriptFile.getName());
                FileUtils.writeStringToFile((File)targetProjectScriptDir, (String)node.getScript(), (Charset)charset);
            }
            node.setScript(null);
        }
    }

    private static void writeProject(WorkflowProject workflowProject, File targetProjectFile) {
        try {
            FileUtils.writeStringToFile((File)targetProjectFile, (String)BwmJsonUtil.toJsonString(workflowProject), (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeDatasource(List<WorkflowDatasource> workflowDatasource, File targetDatasourceFile) {
        try {
            FileUtils.writeStringToFile((File)targetDatasourceFile, (String)BwmJsonUtil.toJsonString(workflowDatasource), (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeFileResource(List<WorkflowFileResource> workflowFileResource, File targetFileResourceFile) {
        try {
            FileUtils.writeStringToFile((File)targetFileResourceFile, (String)BwmJsonUtil.toJsonString(workflowFileResource), (Charset)charset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void buildNodeScriptSavePath(WorkflowProjectPackage workflowProjectPackage) {
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            ((List)Optional.ofNullable(workflow.getWorkflowNodes()).orElse(new ArrayList())).forEach(x -> x.setChildren(null));
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                StringBuilder scriptPath = new StringBuilder();
                scriptPath.append("data").append("/").append("project").append("/").append("workflow").append("/").append((workflow.getWorkflowName() + "#" + workflow.getWorkflowId()).replaceAll("/", "_")).append("/").append("script/");
                if (BwmScriptNodeUtil.nodeTypeInList(node.getNodeType()).booleanValue()) {
                    scriptPath.append(((String)(StringUtils.isEmpty((CharSequence)node.getProjectName()) ? "" : node.getProjectName() + "#") + (String)(StringUtils.isEmpty((CharSequence)node.getNodeName()) ? "" : node.getNodeName() + "#") + (StringUtils.isEmpty((CharSequence)node.getNodeId()) ? "" : node.getNodeId()) + BwmScriptNodeUtil.getNodeType(node.getNodeType()).getExtension()).replaceAll("/", "_"));
                } else if (StringUtils.isBlank((CharSequence)node.getNodeType())) {
                    log.warn("\u672a\u83b7\u53d6\u8282\u70b9\u7c7b\u578b\uff0c\u8df3\u8fc7\u811a\u672c\u5916\u7f6e\u5b58\u50a8\uff1a{}", (Object)node.getNodeName());
                } else if (node.getNodeType().toLowerCase().equals("sql")) {
                    scriptPath.append(((String)(StringUtils.isEmpty((CharSequence)node.getProjectName()) ? "" : node.getProjectName() + "#") + (String)(StringUtils.isEmpty((CharSequence)node.getNodeName()) ? "" : node.getNodeName() + "#") + (StringUtils.isEmpty((CharSequence)node.getNodeId()) ? "" : node.getNodeId()) + ".sql").replaceAll("/", "_"));
                } else if (BwmCommonConstant.BwmScriptNode.specialTypeList.containsKey(node.getNodeType())) {
                    scriptPath.append(((String)(StringUtils.isEmpty((CharSequence)node.getProjectName()) ? "" : node.getProjectName() + "#") + (String)(StringUtils.isEmpty((CharSequence)node.getNodeName()) ? "" : node.getNodeName() + "#") + (StringUtils.isEmpty((CharSequence)node.getNodeId()) ? "" : node.getNodeId()) + (String)BwmCommonConstant.BwmScriptNode.specialTypeList.get(node.getNodeType())).replaceAll("/", "_"));
                } else {
                    scriptPath.append(((String)(StringUtils.isEmpty((CharSequence)node.getProjectName()) ? "" : node.getProjectName() + "#") + (String)(StringUtils.isEmpty((CharSequence)node.getNodeName()) ? "" : node.getNodeName() + "#") + (StringUtils.isEmpty((CharSequence)node.getNodeId()) ? "" : node.getNodeId()) + ".script").replaceAll("/", "_"));
                }
                node.setScriptPath(scriptPath.toString());
            }
        }
    }

    public static String buildFileResourceSavePath(WorkflowFileResource file) {
        String result = "data/project/resource/" + file.getFolder() + "/" + file.getName();
        return result.replaceAll("/+", "/");
    }

    public static String buildFileResourceSavePath(WorkflowFileResource file, Workflow workflow) {
        String result = "data/project/workflow/" + (workflow.getWorkflowName() + "#" + workflow.getWorkflowId()).replaceAll("/", "_") + "/resource/" + file.getFolder() + "/" + file.getName();
        return result.replaceAll("/+", "/");
    }

    public static WorkflowProjectPackage readFile(String filePath, String sqlTransResultFilePath) {
        WorkflowProjectPackage workflowProjectPackage = BwmPackageFileOperator.readFile(filePath);
        if (workflowProjectPackage != null && StringUtils.isNotBlank((CharSequence)sqlTransResultFilePath) && new File(sqlTransResultFilePath).exists() && new File(sqlTransResultFilePath).isDirectory()) {
            log.info("\u8bc6\u522b\u5230\u5916\u6302\u811a\u672c\u8def\u5f84\uff0c\u5f00\u59cb\u8bfb\u53d6:{}", (Object)sqlTransResultFilePath);
            File[] sqlTransResultFiles = new File(sqlTransResultFilePath).listFiles();
            HashMap nodeMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
                workflowProjectPackage.getWorkflowList().forEach(wf -> {
                    if (CollectionUtils.isNotEmpty((Collection)wf.getWorkflowNodes())) {
                        wf.getWorkflowNodes().forEach(x -> nodeMap.put(x.getNodeId(), x));
                    }
                });
            }
            for (File sqlTransResultFile : sqlTransResultFiles) {
                if (!sqlTransResultFile.isFile()) continue;
                String nodeId = sqlTransResultFile.getName().substring(0, sqlTransResultFile.getName().lastIndexOf("."));
                String sqlTransResult = BwmPackageFileOperator.getStrFromFile(sqlTransResultFile, null);
                if (!StringUtils.isNotBlank((CharSequence)nodeId) || !nodeMap.containsKey(nodeId)) continue;
                ((WorkflowNode)nodeMap.get(nodeId)).setScript(sqlTransResult);
                log.info("\u8bfb\u53d6\u5230\u5916\u6302\u811a\u672c:{}\uff0c\u66f4\u65b0\u5230\u8282\u70b9{}\u4e2d", (Object)sqlTransResultFile.getName(), (Object)((WorkflowNode)nodeMap.get(nodeId)).getNodeName());
            }
        }
        return workflowProjectPackage;
    }

    public static WorkflowProjectPackage readFile(String filePath) {
        String datasourceJson;
        List<WorkflowDatasource> workflowDatasource;
        if (StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists()) {
            log.error("not.found.this.filePath: {}", (Object)filePath);
            return null;
        }
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        File packageFile = new File(filePath);
        File packageDir = null;
        if (packageFile.exists() && packageFile.isFile()) {
            try {
                packageDir = ZipFileUtil.decompress(new File(filePath));
            }
            catch (IOException e) {
                log.error("decompress.filePath.error ", (Throwable)e);
                return null;
            }
        } else if (packageFile.exists() && packageFile.isDirectory()) {
            packageDir = packageFile;
        } else {
            log.error("not.found.this.filePath: {}", (Object)filePath);
        }
        File dataDir = BwmPackageFileOperator.findFolderInDir(packageDir, "data");
        if (null == dataDir || !dataDir.exists()) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND);
        }
        File dataInitDir = dataDir.getParentFile();
        String dataInitDirPath = dataInitDir.getAbsolutePath();
        File rootDir = new File(dataDir, "project");
        String projectJson = BwmPackageFileOperator.getStrFromFile(new File(rootDir, "project.json"), JsonType.JSON_TYPE.value);
        WorkflowProject workflowProject = BwmJsonUtil.parseObject(projectJson, WorkflowProject.class);
        List<File> scriptFiles = BwmPackageFileOperator.listAllFiles(new File(rootDir, "script"));
        HashMap scriptFileMap = new HashMap();
        if (!scriptFiles.isEmpty()) {
            scriptFiles.forEach(x -> scriptFileMap.put(x.getName(), x));
        }
        if (CollectionUtils.isEmpty(workflowDatasource = BwmJsonUtil.parseObject(datasourceJson = BwmPackageFileOperator.getStrFromFile(new File(rootDir, "datasource.json"), JsonType.JSON_ARR_TYPE.value), new TypeReference<List<WorkflowDatasource>>(){}))) {
            workflowDatasource = new ArrayList<WorkflowDatasource>();
        }
        workflowProjectPackage.setDatasources(workflowDatasource);
        String filesFileJson = BwmPackageFileOperator.getStrFromFile(new File(rootDir, "files.json"), JsonType.JSON_ARR_TYPE.value);
        List<WorkflowFileResource> workflowFileResources = BwmJsonUtil.parseObject(filesFileJson, new TypeReference<List<WorkflowFileResource>>(){});
        workflowFileResources.forEach(x -> x.setPath(dataInitDirPath + "/" + x.getPath()));
        workflowProjectPackage.setFiles(workflowFileResources);
        File workflowDirFile = new File(rootDir, "workflow");
        File[] files = workflowDirFile.listFiles();
        if (CollectionUtils.isEmpty((Collection)workflowProjectPackage.getWorkflowList())) {
            workflowProjectPackage.setWorkflowList(new ArrayList());
        }
        if (Objects.isNull(files)) {
            log.warn("file not found {}", (Object)workflowDirFile.getPath());
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND);
        }
        for (File workflowDir : files) {
            String workflowJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "workflow.json"), JsonType.JSON_TYPE.value);
            Workflow workflow = BwmJsonUtil.parseObject(workflowJson, Workflow.class);
            workflow.setProjectName(workflowProject.getName());
            workflow.setProjectId(workflowProject.getProjectId());
            if (Objects.isNull(workflow)) {
                log.error("parse workflow json error, result is null");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)workflow.getWorkflowId()) && StringUtils.isEmpty((CharSequence)workflow.getWorkflowName())) {
                log.warn("workflow\u8def\u5f84\u4e0b\u83b7\u53d6\u5230\u4e00\u4e2a\u7a7a\u6587\u4ef6\u5939:{}", (Object)workflowDir.getPath());
                continue;
            }
            String workflowNodeJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "nodeSpec.json"), JsonType.JSON_ARR_TYPE.value);
            List<WorkflowNode> workflowNodeListInit = BwmJsonUtil.parseObject(workflowNodeJson, new TypeReference<List<WorkflowNode>>(){});
            List workflowNodeList = workflowNodeListInit.stream().filter(Objects::nonNull).peek(x -> x.setNodeName(StringUtils.trim((String)x.getNodeName()))).collect(Collectors.toList());
            for (WorkflowNode node : workflowNodeList) {
                node.setProjectName(workflowProject.getName());
                node.setProjectId(workflowProject.getProjectId());
                node.setWorkflowName(workflow.getWorkflowName());
                node.setWorkflowId(workflow.getWorkflowId());
            }
            Map nodeMap = workflowNodeList.stream().filter(Objects::nonNull).collect(Collectors.toMap(WorkflowNode::getNodeId, Function.identity(), (oldValue, newValue) -> oldValue));
            String workflowRelationJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "nodeRelationSpec.json"), JsonType.JSON_ARR_TYPE.value);
            List<RelationPackage> relations = BwmJsonUtil.parseObject(workflowRelationJson, new TypeReference<List<RelationPackage>>(){});
            workflow.setNodeRelations(relations);
            workflow.setWorkflowNodes(workflowNodeList);
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                if (node.getScriptPath() == null) continue;
                File targetScriptDir = new File(workflowDir, node.getScriptPath());
                if (scriptFileMap.containsKey(targetScriptDir.getName())) {
                    File rootScriptFile = (File)scriptFileMap.get(targetScriptDir.getName());
                    node.setScriptPath(rootScriptFile.getAbsolutePath());
                    try {
                        String script = Files.readString(Paths.get(rootScriptFile.getPath(), new String[0]));
                        node.setScript(script);
                    }
                    catch (IOException e) {
                        log.error("read script error {}", (Object)targetScriptDir.getPath(), (Object)e);
                    }
                    continue;
                }
                if (!targetScriptDir.exists()) continue;
                node.setScriptPath(targetScriptDir.getAbsolutePath());
                try {
                    String script = Files.readString(Paths.get(targetScriptDir.getPath(), new String[0]));
                    node.setScript(script);
                }
                catch (IOException e) {
                    log.error("read script error {}", (Object)targetScriptDir.getPath(), (Object)e);
                }
            }
            String triggerJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "trigger.json"), JsonType.JSON_ARR_TYPE.value);
            List<WorkflowTrigger> workflowTriggers = BwmJsonUtil.parseObject(triggerJson, new TypeReference<List<WorkflowTrigger>>(){});
            workflow.setTriggers(workflowTriggers);
            String functonsJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "functions.json"), JsonType.JSON_ARR_TYPE.value);
            List<WorkflowFunctionResource> workflowFunctions = BwmJsonUtil.parseObject(functonsJson, new TypeReference<List<WorkflowFunctionResource>>(){});
            workflow.setFunctions(workflowFunctions);
            filesFileJson = BwmPackageFileOperator.getStrFromFile(new File(workflowDir, "files.json"), JsonType.JSON_ARR_TYPE.value);
            workflowFileResources = BwmJsonUtil.parseObject(filesFileJson, new TypeReference<List<WorkflowFileResource>>(){});
            workflowFileResources.forEach(x -> x.setPath(dataInitDirPath + "/" + x.getPath()));
            workflow.setFiles(workflowFileResources);
            workflowProjectPackage.getWorkflowList().add(workflow);
        }
        workflowProjectPackage.setWorkflowProject(workflowProject);
        workflowProjectPackage.setFilePath(rootDir.getPath());
        File statisticFile = BwmPackageFileOperator.findFileInDir(packageDir, "LHMPackageOverview.xls");
        try {
            BwmPackageXlsReportFileOperator.getChangeFromStatisticXls(workflowProjectPackage, statisticFile);
        }
        catch (Exception e) {
            log.error("getChangeFromStatisticXls error\uff0c\u6ce8\u610f\u4fee\u6539\u53ef\u80fd\u662f\u4e0d\u5168\u7684 {}", (Object)statisticFile.getPath(), (Object)e);
        }
        return workflowProjectPackage;
    }

    public static File findFolderInDir(File dir, String folderName) {
        if (dir.isDirectory()) {
            if (dir.getName().equals(folderName)) {
                return dir;
            }
            for (File file : dir.listFiles()) {
                File result = BwmPackageFileOperator.findFolderInDir(file, folderName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static File findFileInDir(File dir, String fileName) {
        if (dir.isFile() && dir.getName().equals(fileName)) {
            return dir;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                File result = BwmPackageFileOperator.findFileInDir(file, fileName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static String getStrFromFile(File file, String defaultValue) {
        if (!file.exists()) {
            return defaultValue;
        }
        try {
            String filesFileJson = FileUtils.readFileToString((File)file, (Charset)charset);
            return filesFileJson;
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    private static List<File> listAllFiles(File dir) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (!dir.exists()) {
            return fileList;
        }
        if (!dir.isDirectory()) {
            return List.of(dir);
        }
        File[] filesAndDirs = dir.listFiles();
        if (filesAndDirs == null || filesAndDirs.length == 0) {
            return fileList;
        }
        for (File fileOrDir : filesAndDirs) {
            if (fileOrDir.isDirectory()) {
                fileList.addAll(BwmPackageFileOperator.listAllFiles(fileOrDir));
                continue;
            }
            fileList.add(fileOrDir);
        }
        return fileList;
    }

    public static WorkflowFileResource generateScriptResourceFileForNode(String rawScript, String fileName, String projectId) {
        WorkflowFileResource fileResource = new WorkflowFileResource();
        fileResource.setProjectId(projectId);
        fileResource.setName(fileName);
        fileResource.setFileId(fileName);
        ArrayList paths = new ArrayList();
        DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
        fileResource.setFolder(Joiner.on((String)File.separator).join(paths));
        File tmpFIle = new File(FileUtils.getTempDirectory(), fileResource.getName());
        try {
            FileUtils.writeStringToFile((File)tmpFIle, (String)rawScript, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("write script error {}", (Object)tmpFIle.getPath(), (Object)e);
        }
        fileResource.setPath(tmpFIle.getAbsolutePath());
        return fileResource;
    }

    public static enum JsonType {
        JSON_TYPE("{}"),
        JSON_ARR_TYPE("[]");

        public String value;

        private JsonType(String value) {
            this.value = value;
        }
    }
}

