/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.sqoop2di;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqoopConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqoopConverter.class);
    private List<Datasource> datasourceList;

    public AbstractSqoopConverter(List<Datasource> datasourceList) {
        this.datasourceList = datasourceList;
    }

    public abstract void convert(JSONObject var1, DIJsonProcessor var2);

    public String getDatabaseFromUrl(String jdbcUrl) {
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String databaseName = uri.getPath().substring(1);
            return databaseName;
        }
        catch (Exception e) {
            log.error("parse.database.from.jdbcurl", (Throwable)e);
            return "";
        }
    }

    public String getDatasourceNamebyId(Integer datasourceId) {
        if (this.datasourceList == null || this.datasourceList.size() == 0) {
            return null;
        }
        for (Datasource datasource : this.datasourceList) {
            if (!datasource.getId().equals(datasourceId)) continue;
            return datasource.getName();
        }
        return null;
    }
}

