/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.sparkContent;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import java.util.List;
import java.util.Map;

public class SparkContent {
    protected SparkVersion sparkVersion;
    protected String language;
    protected String args;
    protected List<String> configs;
    protected String mainClass;
    protected String mainJar;
    protected List<String> assistJars;

    public SparkContent(Map<String, Object> properties, Map<String, String> runtimeResource) {
        List fileResources = runtimeResource.keySet().stream().toList();
        if (fileResources != null && fileResources.size() > 0) {
            this.mainJar = (String)fileResources.get(0);
            this.assistJars = fileResources;
        }
        this.sparkVersion = SparkVersion.getSparkVersion((String)properties.get("sparkVersion"));
        if (this.sparkVersion == null) {
            this.sparkVersion = SparkVersion.v1;
        }
        this.language = (String)properties.get("language");
        if (this.language == null) {
            this.language = "java";
        }
        this.mainClass = (String)properties.get("mainClass");
        this.args = (String)properties.get("args");
        this.configs = (List)properties.get("configs");
    }

    public SparkContent(Map<String, Object> properties, List<WorkflowFileResource> fileResources) {
        if (fileResources != null && fileResources.size() > 0) {
            this.mainJar = fileResources.get(0).getName();
            this.assistJars = fileResources.stream().map(WorkflowFileResource::getName).toList();
        }
        this.sparkVersion = SparkVersion.getSparkVersion((String)properties.get("sparkVersion"));
        if (this.sparkVersion == null) {
            this.sparkVersion = SparkVersion.v1;
        }
        this.language = (String)properties.get("language");
        if (this.language == null) {
            this.language = "java";
        }
        this.args = (String)properties.get("args");
        this.configs = (List)properties.get("configs");
    }

    public String getContent() {
        StringBuilder content = new StringBuilder();
        content.append("##@resource_reference{").append(this.mainJar).append("}\n");
        this.assistJars.forEach(x -> content.append("##@resource_reference{").append((String)x).append("}\n"));
        JSONObject contentJson = new JSONObject();
        contentJson.put((Object)"version", (Object)this.sparkVersion.getValue());
        contentJson.put((Object)"language", (Object)this.language);
        if (this.args != null) {
            contentJson.put((Object)"args", (Object)this.args);
        }
        if (this.configs != null) {
            contentJson.put((Object)"configs", this.configs);
        }
        content.append(contentJson.toJSONString(new JSONWriter.Feature[0]));
        return content.toString();
    }

    public static enum SparkVersion {
        v1("1.x"),
        v2("2.x"),
        v3("3.x");

        public String value;

        private SparkVersion(String value) {
            this.value = value;
        }

        public static SparkVersion getSparkVersion(String value) {
            if (value == null) {
                return null;
            }
            for (SparkVersion sparkVersion : SparkVersion.values()) {
                if (!sparkVersion.value.equals(value)) continue;
                return sparkVersion;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }
    }
}

