/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.datax2di;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DIType;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ClickHouse2ClickHouseForDataXReaderConverter
extends AbstractDataxConverter {
    private static final Logger log = LoggerFactory.getLogger(ClickHouse2ClickHouseForDataXReaderConverter.class);

    @Override
    public void convert(JSONObject readerJson, DIJsonProcessor readerJp) {
        Object[] objectArray;
        JSONObject connection;
        JSONObject parameter = readerJson.getJSONObject("parameter");
        if (parameter == null) {
            log.warn("reader.parameter.can.not.be.null");
            return;
        }
        String username = parameter.containsKey("username") ? parameter.getString("username") : "";
        String password = parameter.containsKey("password") ? parameter.getString("password") : "";
        ArrayList jdbcUrl = new ArrayList();
        ArrayList table = new ArrayList();
        ArrayList column = new ArrayList();
        String splitPk = parameter.containsKey("splitPk") ? parameter.getString("splitPk") : "";
        String where = parameter.containsKey("where") ? parameter.getString("where") : "";
        ArrayList querySql = new ArrayList();
        Integer fetchSize = parameter.containsKey("fetchSize") ? parameter.getInteger("fetchSize") : null;
        ArrayList session = new ArrayList();
        if (parameter.containsKey("connection")) {
            connection = (JSONObject)parameter.getJSONArray("connection").get(0);
            if (connection.containsKey("jdbcUrl")) {
                connection.getJSONArray("jdbcUrl").forEach(x -> jdbcUrl.add(x.toString()));
            }
            if (connection.containsKey("table")) {
                connection.getJSONArray("table").forEach(x -> table.add(x.toString()));
            }
            if (connection.containsKey("querySql")) {
                connection.getJSONArray("querySql").forEach(x -> querySql.add(x.toString()));
            }
        }
        if (parameter.containsKey("column")) {
            parameter.getJSONArray("column").forEach(x -> column.add(x.toString()));
        }
        if (parameter.containsKey("session")) {
            parameter.getJSONArray("session").forEach(x -> session.add(x.toString()));
        }
        readerJp.set("stepType", (Object)DIType.CLICKHOUSE.getStepType());
        readerJp.set("parameter.selectedDatabase", (Object)this.getDatabaseFromUrl((String)jdbcUrl.get(0)));
        readerJp.set("parameter.splitPk", (Object)(StringUtils.isNotBlank((CharSequence)splitPk) ? splitPk : ""));
        readerJp.set("parameter.where", (Object)(StringUtils.isNotBlank((CharSequence)where) ? where : ""));
        if (CollectionUtils.isEmpty(column)) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "*";
        } else {
            objectArray = column.toArray();
        }
        readerJp.set("parameter.column", (Object)objectArray);
        readerJp.set("parameter.fetchSize", (Object)(fetchSize == null ? 512 : fetchSize));
        connection = new JSONArray();
        JSONObject singleConnection = new JSONObject();
        singleConnection.put((Object)"table", (Object)(CollectionUtils.isEmpty(table) ? new String[]{} : table.toArray()));
        singleConnection.put((Object)"querySql", (Object)(CollectionUtils.isEmpty(querySql) ? new String[]{} : querySql.toArray()));
        singleConnection.put((Object)"datasource", (Object)this.getDatabaseFromUrl((String)jdbcUrl.get(0)));
        connection.add((Object)singleConnection);
        readerJp.set("parameter.connection", (Object)connection);
    }
}

