/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrJobType;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrProperty;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.utils.ScriptArgsReplace;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmRegexUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractNodeConvert
extends AbstractConvert<List<WorkflowNode>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeConvert.class);
    protected Workflow workflow;
    protected BwmConfiguration bwmConfiguration;
    protected Map<String, Object> selfConfMap = new HashMap<String, Object>();
    protected Map<String, Map<String, Object>> confMap = new HashMap<String, Map<String, Object>>();

    public AbstractNodeConvert(TaskContext taskContext) {
        super(taskContext);
        BwmConfiguration bwmConfiguration;
        this.bwmConfiguration = bwmConfiguration = BwmConfiguration.from(taskContext.getBwmConfiguration());
        this.selfConfMap = bwmConfiguration.getMap("self", new HashMap<String, Object>());
        Object orDefault = this.selfConfMap.getOrDefault("conf", "[]");
        this.confMap = this.getConfMap(orDefault);
    }

    protected Map<String, Object> getNodeConfMap(WorkflowNode node) {
        Map<String, Object> value;
        ArrayList keyList;
        String key;
        if (CollectionUtils.isEmpty(this.confMap) || Objects.isNull(node)) {
            log.warn("not fond confmap or ndoe is null");
            return new HashMap<String, Object>();
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (!keyList.contains("all")) continue;
            return value;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{node.getNodeName()}) && keyList.contains(node.getNodeName())) {
                return value;
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{node.getNodeId()}) || !keyList.contains(node.getNodeId())) continue;
            return value;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            String keys = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(keys.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            for (String key2 : keyList) {
                if (!BwmRegexUtil.match(key2, node.getNodeName())) continue;
                return value;
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.confMap.entrySet()) {
            key = entry.getKey();
            keyList = new ArrayList();
            Arrays.asList(key.split(",")).forEach(x -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{x})) {
                    keyList.add(x.trim());
                }
            });
            value = entry.getValue();
            if (!keyList.contains("normal")) continue;
            return value;
        }
        return new HashMap<String, Object>();
    }

    private Map<String, Map<String, Object>> getConfMap(Object orDefault) {
        HashMap<String, Map<String, Object>> resConfMap = new HashMap<String, Map<String, Object>>();
        if (orDefault instanceof JSONArray) {
            JSONArray array = (JSONArray)orDefault;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String nodes = jsonObject.getString("nodes");
                JSONObject ruleJsonObject = jsonObject.getJSONObject("rule");
                BwmConfiguration from = BwmConfiguration.from(ruleJsonObject.toString());
                Map<String, Object> settingsMap = from.getMap("settings");
                resConfMap.put(nodes, settingsMap);
            }
        }
        return resConfMap;
    }

    public void supplyBaseMsg(WorkflowNode tgtworkflowNode) {
        if (Objects.isNull(tgtworkflowNode) || Objects.isNull(this.workflow)) {
            return;
        }
        tgtworkflowNode.setProjectName(this.workflow.getProjectName());
        tgtworkflowNode.setProjectId(this.workflow.getProjectId());
        tgtworkflowNode.setWorkflowId(this.workflow.getWorkflowId());
        tgtworkflowNode.setWorkflowName(this.workflow.getWorkflowName());
    }

    public AbstractNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        BwmConfiguration bwmConfiguration;
        this.bwmConfiguration = bwmConfiguration = BwmConfiguration.from(taskContext.getBwmConfiguration());
        this.selfConfMap = bwmConfiguration.getMap("self", new HashMap<String, Object>());
        Object orDefault = this.selfConfMap.getOrDefault("conf", "[]");
        this.confMap = this.getConfMap(orDefault);
        this.workflow = workflow;
    }

    protected List<String> getParentNodeIds(WorkflowNode workflowNode) {
        List nodeRelations = this.workflow.getNodeRelations();
        if (CollectionUtils.isEmpty((Collection)nodeRelations)) {
            return new ArrayList<String>();
        }
        return nodeRelations.stream().filter(x -> x.getTo().equalsIgnoreCase(workflowNode.getNodeId())).map(RelationPackage::getFrom).toList();
    }

    protected List<String> getChildrenNodeIds(WorkflowNode workflowNode) {
        List nodeRelations = this.workflow.getNodeRelations();
        if (CollectionUtils.isEmpty((Collection)nodeRelations)) {
            return new ArrayList<String>();
        }
        return nodeRelations.stream().filter(x -> x.getFrom().equalsIgnoreCase(workflowNode.getNodeId())).map(RelationPackage::getTo).toList();
    }

    protected List<WorkflowNode> getParentNodes(WorkflowNode workflowNode) {
        List nodeRelations = this.workflow.getNodeRelations();
        List workflowNodes = this.workflow.getWorkflowNodes();
        Map<String, List<WorkflowNode>> nodeIdMap = workflowNodes.stream().collect(Collectors.groupingBy(WorkflowNode::getNodeId));
        if (CollectionUtils.isEmpty((Collection)nodeRelations) || CollectionUtils.isEmpty((Collection)workflowNodes)) {
            return new ArrayList<WorkflowNode>();
        }
        List<WorkflowNode> res = nodeRelations.stream().filter(x -> x.getTo().equalsIgnoreCase(workflowNode.getNodeId())).map(RelationPackage::getFrom).map(x -> {
            List nodes = (List)nodeIdMap.get(x);
            if (CollectionUtils.isEmpty((Collection)nodes)) {
                return null;
            }
            return (WorkflowNode)nodes.get(0);
        }).collect(Collectors.toList());
        return res;
    }

    protected List<WorkflowNode> getChildreNodes(WorkflowNode workflowNode) {
        List nodeRelations = this.workflow.getNodeRelations();
        List workflowNodes = this.workflow.getWorkflowNodes();
        Map<String, List<WorkflowNode>> nodeIdMap = workflowNodes.stream().collect(Collectors.groupingBy(WorkflowNode::getNodeId));
        if (CollectionUtils.isEmpty((Collection)nodeRelations) || CollectionUtils.isEmpty((Collection)workflowNodes)) {
            return new ArrayList<WorkflowNode>();
        }
        List<WorkflowNode> res = nodeRelations.stream().filter(x -> x.getFrom().equalsIgnoreCase(workflowNode.getNodeId())).map(RelationPackage::getTo).map(x -> {
            List nodes = (List)nodeIdMap.get(x);
            if (CollectionUtils.isEmpty((Collection)nodes)) {
                return null;
            }
            return (WorkflowNode)nodes.get(0);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return res;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return (String)this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.target.unknownNodeTypeAs", CodeProgramType.VIRTUAL.name());
    }

    private static CodeProgramType getEmrCodeType(String nodeType) {
        try {
            return CodeProgramType.valueOf((String)nodeType);
        }
        catch (Exception e) {
            log.error("cur nodetype not int CodeProgramType {}", (Object)nodeType);
            return CodeProgramType.EMR_SHELL;
        }
    }

    public static String wfToEmrCode(WorkflowNode node) {
        CodeProgramType nodeType = AbstractNodeConvert.getEmrCodeType(node.getNodeType());
        EmrCode emrCode = new EmrCode();
        emrCode.setName(node.getNodeName());
        emrCode.setDescription("DataWorks Migration");
        EmrLauncher launcher = new EmrLauncher();
        launcher.setAllocationSpec(AbstractNodeConvert.getDefaultAllocationSpec());
        emrCode.setLauncher(launcher);
        EmrProperty properties = new EmrProperty();
        properties.setArguments(Arrays.asList(node.getScript()));
        properties.setTags(Arrays.asList(node.getNodeName()));
        emrCode.setProperties(properties);
        switch (nodeType) {
            case EMR_HIVE: {
                emrCode.setType(EmrJobType.HIVE_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SHELL: {
                emrCode.setType(EmrJobType.SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_IMPALA: {
                emrCode.setType(EmrJobType.IMPALA_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_MR: {
                emrCode.setType(EmrJobType.MR);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_PRESTO: {
                emrCode.setType(EmrJobType.PRESTO_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK: {
                emrCode.setType(EmrJobType.SPARK);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SHELL: {
                emrCode.setType(EmrJobType.SPARK_SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SQL: {
                emrCode.setType(EmrJobType.SPARK_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_KYUUBI: {
                emrCode.setType(EmrJobType.KYUUBI);
                return GsonUtils.toJsonString((Object)emrCode);
            }
        }
        return node.getScript();
    }

    private static Map<String, Object> getDefaultAllocationSpec() {
        EmrAllocationSpec allocationSpec = new EmrAllocationSpec();
        allocationSpec.setMemory(String.valueOf(2048));
        allocationSpec.setPriority(String.valueOf(1));
        allocationSpec.setVcores(String.valueOf(1));
        allocationSpec.setQueue("default");
        return allocationSpec.toMap();
    }

    protected List<WorkflowFileResource> getAllFileResources() {
        List workflowFiles = this.workflow.getFiles();
        List projectFiles = this.taskContext.getWorkflowProjectPackage().getFiles();
        return ListUtils.union((List)ListUtils.emptyIfNull((List)workflowFiles), (List)ListUtils.emptyIfNull((List)projectFiles));
    }

    public static EmrCode wfNodeAsEmrCode(WorkflowNode node) {
        try {
            if (NodeUtils.isEmrNode((String)node.getNodeType())) {
                return (EmrCode)GsonUtils.fromJsonString((String)node.getScript(), EmrCode.class);
            }
        }
        catch (Exception var2) {
            Exception e = var2;
            log.error("convert to EmrCode failed code: {}, exception: ", (Object)node.getScript(), (Object)e);
        }
        return null;
    }

    protected String getDefaultNodeOutput(String nodeId) {
        return Joiner.on((String)".").join((Object)this.workflow.getProjectName(), (Object)(nodeId + "_out"), new Object[0]);
    }

    public void scriptParamRelpace(WorkflowNode node, Workflow workflow) {
        if (StringUtils.isBlank((CharSequence)node.getScript())) {
            return;
        }
        String script = node.getScript();
        node.setScript(ScriptArgsReplace.replace(node.getScript(), node.getParamMap(), workflow.getCustomProperties(), null));
    }

    public CodeProgramType getCodeProgramType(String nodeType) {
        boolean isNumeric = nodeType.matches("\\d+");
        if (isNumeric) {
            return CodeProgramType.getNodeTypeByCode((int)Integer.parseInt(nodeType));
        }
        return CodeProgramType.getNodeTypeByName((String)nodeType);
    }
}

