/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.config;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.config.WriterProjectMappingRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class WriterProjectMappingRuleGroup {
    List<WriterProjectMappingRule> writerProjectMappingRuleList = new ArrayList<WriterProjectMappingRule>();
    String defaultProjectId;
    String defaultProjectName;

    public WriterProjectMappingRuleGroup(String jsonStr, String defaultProjectIdInDatasource, String defaultProjectNameInDatasource) {
        WriterProjectMappingRule defaultMapping;
        JSONArray jsonArray;
        this.defaultProjectId = defaultProjectIdInDatasource;
        this.defaultProjectName = defaultProjectNameInDatasource;
        if (jsonStr == null) {
            return;
        }
        try {
            jsonArray = JSONArray.parse((String)jsonStr, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        catch (Exception e) {
            return;
        }
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                WriterProjectMappingRule writerProjectMappingRule = new WriterProjectMappingRule();
                writerProjectMappingRule.parseJSON(jsonArray.getString(i));
                if (writerProjectMappingRule.parseJSON(jsonArray.getString(i)) == null) continue;
                this.writerProjectMappingRuleList.add(writerProjectMappingRule);
            }
        }
        if ((defaultMapping = this.getDefault()) != null) {
            this.defaultProjectId = defaultMapping.getProjectId();
            this.defaultProjectName = defaultMapping.getProjectName();
        }
    }

    public Pair<String, String> getTargetProjectId4Workflow(Workflow workflow) {
        WriterProjectMappingRule writerProjectMappingRule = this.matchWorkflowId(workflow.getWorkflowId());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        writerProjectMappingRule = this.matchWorkflowName(workflow.getWorkflowName());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        return Pair.of((Object)this.defaultProjectId, (Object)this.defaultProjectName);
    }

    public Pair<String, String> getTargetProjectId4Node(WorkflowNode node) {
        WriterProjectMappingRule writerProjectMappingRule = this.matchNodeId(node.getNodeId());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        writerProjectMappingRule = this.matchNodeName(node.getNodeName());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        writerProjectMappingRule = this.matchWorkflowId(node.getWorkflowId());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        writerProjectMappingRule = this.matchWorkflowName(node.getWorkflowName());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        return Pair.of((Object)this.defaultProjectId, (Object)this.defaultProjectName);
    }

    public Pair<String, String> getTargetProjectId4FileResouce(WorkflowFileResource resource) {
        WriterProjectMappingRule writerProjectMappingRule = this.matchNodeId(resource.getFileId());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        writerProjectMappingRule = this.matchNodeName(resource.getName());
        if (writerProjectMappingRule != null) {
            return Pair.of((Object)writerProjectMappingRule.getProjectId(), (Object)writerProjectMappingRule.getProjectName());
        }
        return Pair.of((Object)this.defaultProjectId, (Object)this.defaultProjectName);
    }

    public WriterProjectMappingRule matchWorkflowId(String workflowId) {
        for (WriterProjectMappingRule writerProjectMappingRule : this.writerProjectMappingRuleList) {
            if (!writerProjectMappingRule.getFilterType().equals((Object)WriterProjectMappingRule.FilterType.WORKFLOW) || !writerProjectMappingRule.matchId(workflowId).booleanValue()) continue;
            return writerProjectMappingRule;
        }
        return null;
    }

    public WriterProjectMappingRule matchWorkflowName(String workflowName) {
        for (WriterProjectMappingRule writerProjectMappingRule : this.writerProjectMappingRuleList) {
            if (!writerProjectMappingRule.getFilterType().equals((Object)WriterProjectMappingRule.FilterType.WORKFLOW) || !writerProjectMappingRule.matchName(workflowName).booleanValue()) continue;
            return writerProjectMappingRule;
        }
        return null;
    }

    public WriterProjectMappingRule matchNodeId(String nodeId) {
        for (WriterProjectMappingRule writerProjectMappingRule : this.writerProjectMappingRuleList) {
            if (!writerProjectMappingRule.getFilterType().equals((Object)WriterProjectMappingRule.FilterType.NODE) || !writerProjectMappingRule.matchId(nodeId).booleanValue()) continue;
            return writerProjectMappingRule;
        }
        return null;
    }

    public WriterProjectMappingRule matchNodeName(String nodeName) {
        for (WriterProjectMappingRule writerProjectMappingRule : this.writerProjectMappingRuleList) {
            if (!writerProjectMappingRule.getFilterType().equals((Object)WriterProjectMappingRule.FilterType.NODE) || !writerProjectMappingRule.matchName(nodeName).booleanValue()) continue;
            return writerProjectMappingRule;
        }
        return null;
    }

    public WriterProjectMappingRule getDefault() {
        for (WriterProjectMappingRule writerProjectMappingRule : this.writerProjectMappingRuleList) {
            if (!writerProjectMappingRule.getFilterType().equals((Object)WriterProjectMappingRule.FilterType.DEFAULT)) continue;
            return writerProjectMappingRule;
        }
        return null;
    }
}

