/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.alibaba.cola.dto.SingleResponse;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks_public20240518.models.CreateResourceFileResponse;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractPlugin;
import com.aliyun.migration.workflow.migration.common.bean.BwmNode;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrResultStatisticFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrSnapshotFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmNameValidateUtil;
import com.aliyun.migration.workflow.migration.common.utils.TopoSortUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriter
extends AbstractPlugin
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(AbstractWriter.class);
    protected WorkflowProjectPackage workflowProjectPackage;

    public Writer init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        Datasource writerDatasource = taskContext.getWriterDatasource();
        Map writerDatasourceProperties = writerDatasource.getProperties();
        String targetFilePath = (String)writerDatasourceProperties.get("export-file-path");
        taskContext.setTargetFilePackage(targetFilePath);
        return this;
    }

    @Override
    protected WorkflowProjectPackage getWorkflowPackage() {
        WorkflowProjectPackage workflowProjectPackage;
        BwmSaasConfiguration bwmSaasConfiguration;
        if (Objects.nonNull(this.taskContext) && Objects.nonNull(this.taskContext.getWorkflowProjectPackage())) {
            return this.taskContext.getWorkflowProjectPackage();
        }
        Datasource scheduleDataSource = this.taskContext.getWriterDatasource();
        if (Objects.isNull(scheduleDataSource)) {
            return null;
        }
        Map properties = scheduleDataSource.getProperties();
        String filePath = (String)properties.get("source-file-path");
        String sqlTransResultFilePath = null;
        if (StringUtils.isNotBlank((CharSequence)this.taskContext.getSaasConfiguration()) && (bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class)).getLocal() != null && bwmSaasConfiguration.getLocal().getInputFileReadPath() != null) {
            sqlTransResultFilePath = bwmSaasConfiguration.getLocal().getInputFileReadPath().getMainPackageExtendedScriptFolder();
        }
        if (Objects.isNull(workflowProjectPackage = BwmPackageFileOperator.readFile(filePath, sqlTransResultFilePath))) {
            log.error("get.workflowProjectPackage.error");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.WORKFLOW_PACKAGE_NOT_FOUND);
        }
        this.taskContext.setWorkflowProjectPackage(BwmJsonUtil.deepCopy(workflowProjectPackage, WorkflowProjectPackage.class));
        return workflowProjectPackage;
    }

    @Override
    public String export() {
        this.freshPackageBasicInfo(this.taskContext.getWorkflowProjectPackage());
        this.freshPackageBasicInfo(this.taskContext.getTargetWorkflowProjectPackage());
        if (this.taskContext.getSaasConfiguration() != null) {
            if (this.taskContext.getTargetWorkflowProjectPackage() != null) {
                BwmPackageSrSnapshotFileOperator.writeMigrationSrSnapshotFile(this.taskContext.getTargetWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingFile(this.taskContext.getTargetWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingOverviewFile(this.taskContext.getWorkflowProjectPackage(), this.taskContext.getTargetWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            } else {
                BwmPackageSrSnapshotFileOperator.writeMigrationSrSnapshotFile(this.taskContext.getWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingFile(this.taskContext.getWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            }
        }
        String export = super.export();
        String sourceFilePath = (String)this.taskContext.getWriterDatasource().getProperties().get("source-file-path");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourceFilePath})) {
            File sourceFile;
            if (sourceFilePath.endsWith(".zip")) {
                sourceFilePath = sourceFilePath.substring(0, sourceFilePath.length() - 4);
            }
            if ((sourceFile = new File(sourceFilePath)).exists()) {
                try {
                    FileUtils.forceDelete((File)sourceFile);
                }
                catch (Exception e) {
                    log.error("delete.source.file.error", (Throwable)e);
                }
            }
        }
        return export;
    }

    protected void globalCheckNodeName(List<Workflow> workflowList) {
        if (CollectionUtils.isEmpty(workflowList)) {
            return;
        }
        HashSet<String> gloableNodeNameSet = new HashSet<String>();
        AtomicInteger suffixNameCounter = new AtomicInteger(0);
        for (Workflow workflow : workflowList) {
            workflow.setWorkflowName(BwmNameValidateUtil.toValidName(workflow.getWorkflowName()));
            List workflowNodes = workflow.getWorkflowNodes();
            if (CollectionUtils.isEmpty((Collection)workflowNodes)) continue;
            for (WorkflowNode workflowNode : workflowNodes) {
                String nodeName = BwmNameValidateUtil.toValidName(workflowNode.getNodeName());
                workflowNode.setNodeName(nodeName);
                workflowNode.setWorkflowName(workflow.getWorkflowName());
                if (gloableNodeNameSet.contains(nodeName.toLowerCase(Locale.ROOT))) {
                    String newNodeName = nodeName + "_" + suffixNameCounter.incrementAndGet();
                    workflowNode.setNodeName(newNodeName);
                    continue;
                }
                gloableNodeNameSet.add(nodeName.toLowerCase(Locale.ROOT));
            }
        }
    }

    protected void globalCheckNodeNameOnlyValidate(List<Workflow> workflowList) {
        if (CollectionUtils.isEmpty(workflowList)) {
            return;
        }
        AtomicInteger suffixNameCounter = new AtomicInteger(0);
        for (Workflow workflow : workflowList) {
            workflow.setWorkflowName(BwmNameValidateUtil.toValidName(workflow.getWorkflowName()));
            List workflowNodes = workflow.getWorkflowNodes();
            if (CollectionUtils.isEmpty((Collection)workflowNodes)) continue;
            for (WorkflowNode workflowNode : workflowNodes) {
                String nodeName = BwmNameValidateUtil.toValidName(workflowNode.getNodeName());
                workflowNode.setNodeName(nodeName);
                workflowNode.setWorkflowName(workflow.getWorkflowName());
            }
        }
    }

    public String write() {
        WorkflowProject workflowProject = this.workflowProjectPackage.getWorkflowProject();
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        StatisticOp statisticOp = this.taskContext.getStatisticOp();
        statisticOp.addWorkflowTotal(workflowList.size());
        this.globalCheckNodeName(workflowList);
        for (Workflow workflow : workflowList) {
            try {
                this.writeSingleWorkflow(workflow);
                statisticOp.addWorkflowSuccess(workflow.getWorkflowId());
            }
            catch (Exception e) {
                log.error("create workflow error project={} workflowname={}", new Object[]{workflowProject.getName(), workflow.getWorkflowName(), e});
                statisticOp.addWorkflowFailure(workflow.getWorkflowName(), e.getMessage());
            }
        }
        this.supportWorkflowDependency(workflowList);
        return workflowProject.getName();
    }

    private void supportWorkflowDependency(List<Workflow> workflowList) {
        Map<String, WorkflowNode> allNodes = this.getAllNodes(workflowList);
        for (Workflow workflow : workflowList) {
            List nodeRelations = workflow.getNodeRelations();
            List workflowNodes = workflow.getWorkflowNodes();
            Set worklwoNodsIds = ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).stream().map(WorkflowNode::getNodeId).collect(Collectors.toSet());
            nodeRelations.forEach(x -> {
                if (!x.getReType().equals((Object)RelationPackage.ReType.NODE)) {
                    return;
                }
                String from = x.getFrom();
                String to = x.getTo();
                if (!worklwoNodsIds.contains(from) || !worklwoNodsIds.contains(to)) {
                    if (!allNodes.containsKey(from) || !allNodes.containsKey(to)) {
                        log.error("\u975e\u6cd5\u4f9d\u8d56\uff0c\u81f3\u5c11\u4e00\u4e2a\u8282\u70b9\u4e22\u5931\uff0c\u4e0a\u6e38id\uff1a{}, \u4e0b\u6e38id\uff1a{}", (Object)from, (Object)to);
                        return;
                    }
                    WorkflowNode workflowNode = (WorkflowNode)allNodes.get(from);
                    String tNodeId = workflowNode.getTNodeId();
                    WorkflowNode needUpdateNode = (WorkflowNode)allNodes.get(to);
                    if (Objects.isNull(needUpdateNode)) {
                        return;
                    }
                    List parentTargetIds = needUpdateNode.getParentTargetIds();
                    parentTargetIds.add(workflowNode.getProjectName() + "." + tNodeId);
                    try {
                        this.updateNodeReal(needUpdateNode, needUpdateNode.getTNodeId());
                    }
                    catch (Exception e) {
                        log.error("update workflownode lineage error", (Throwable)e);
                    }
                }
            });
        }
    }

    private Map<String, WorkflowNode> getAllNodes(List<Workflow> workflowList) {
        if (CollectionUtils.isEmpty(workflowList)) {
            return new HashMap<String, WorkflowNode>();
        }
        HashMap<String, WorkflowNode> resMap = new HashMap<String, WorkflowNode>();
        for (Workflow workflow : workflowList) {
            List workflowNodes = workflow.getWorkflowNodes();
            Map<String, WorkflowNode> collect = ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).stream().collect(Collectors.toMap(WorkflowNode::getNodeId, x -> x));
            resMap.putAll(collect);
        }
        return resMap;
    }

    public String writeSingleNode(WorkflowNode workflowNode) {
        SingleResponse<Long> createNodeResp = this.createNode(workflowNode);
        return String.valueOf(createNodeResp.getData());
    }

    public String updateSingleNode(WorkflowNode workflowNode) {
        SingleResponse<Long> updateNodeResp = this.updateNode(workflowNode, workflowNode.getTNodeId(), Boolean.TRUE);
        return String.valueOf(updateNodeResp.getData());
    }

    protected abstract void createFolder(String var1, String var2, String var3);

    protected abstract Long getExistedNode(WorkflowNode var1);

    protected abstract Long existWorkflowId(Workflow var1);

    protected abstract Long createWorkflowBaseReal(Workflow var1) throws Exception;

    protected abstract Long existResourceFileId(WorkflowFileResource var1, String var2);

    protected abstract void deleteResourceFile(long var1, long var3) throws Exception;

    protected abstract Object createResourceFileReal(WorkflowFileResource var1, String var2, String var3) throws Exception;

    protected abstract Object createFunctionReal(WorkflowFunctionResource var1, String var2, String var3) throws Exception;

    protected abstract Long createNodeReal(WorkflowNode var1) throws Exception;

    protected abstract Long updateNodeReal(WorkflowNode var1, String var2) throws Exception;

    protected abstract void submitReal(String var1, String var2);

    public String writeSingleWorkflow(Workflow workflow) throws Exception {
        SingleResponse<Long> workflowBaseResp;
        if (CollectionUtils.isNotEmpty((Collection)workflow.getFunctions())) {
            this.taskContext.getStatisticOp().addWorkflowFunTotal(workflow.getFunctions().size());
        }
        if (CollectionUtils.isNotEmpty((Collection)workflow.getFiles())) {
            this.taskContext.getStatisticOp().addWorkflowResourceTotal(workflow.getFiles().size());
        }
        if (CollectionUtils.isNotEmpty((Collection)workflow.getWorkflowNodes())) {
            this.taskContext.getStatisticOp().addWorkflowNodeTotal(workflow.getWorkflowNodes().size());
        }
        if (!(workflowBaseResp = this.createWorkflowBase(workflow)).isSuccess()) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.CREATE_WORKFLOW_BASE_FAILED, (String)workflowBaseResp.getErrMessage());
        }
        List workflowNodesInit = workflow.getWorkflowNodes();
        if (CollectionUtils.isEmpty((Collection)workflowNodesInit)) {
            log.error("\u5f53\u524dworkflow \uff1a {}  \u8282\u70b9\u4e3a\u7a7a", (Object)workflow.getWorkflowName());
            return workflowBaseResp.getData() == null ? null : String.valueOf(workflowBaseResp.getData());
        }
        List<WorkflowNode> workflowNodes = workflowNodesInit.stream().filter(Objects::nonNull).toList();
        List<BwmNode> bwmNodes = TopoSortUtil.getSimpleNodes(workflowNodes);
        List<Pair<String, String>> edages = ((List)Optional.ofNullable(workflow.getNodeRelations()).orElse(new ArrayList())).stream().map(x -> Pair.of((Object)x.getFrom(), (Object)x.getTo())).collect(Collectors.toList());
        List<List<BwmNode>> sortedNodes = TopoSortUtil.topologicalSort(edages, bwmNodes);
        int size = workflowNodes.size();
        AtomicInteger nodeCount = new AtomicInteger(size);
        log.info("\u5f53\u524dworkflow \uff1a {}  \u8282\u70b9\u603b\u4e2a\u6570\u4e3a\uff1a{}", (Object)workflow.getWorkflowName(), (Object)nodeCount.get());
        ArrayList<WorkflowNode> preWorkflowList = new ArrayList<WorkflowNode>();
        Map<String, WorkflowNode> nodeMap = workflowNodes.stream().collect(Collectors.toMap(x -> String.valueOf(x.getNodeId()), it -> it));
        boolean isCreateOrUpdateNode = true;
        for (List<BwmNode> nodes : sortedNodes) {
            for (BwmNode bwmNode : nodes) {
                WorkflowNode workflowNode = nodeMap.get(bwmNode.getId());
                if (Objects.isNull(workflowNode)) continue;
                List<String> preTNodeIds = ListUtils.emptyIfNull(preWorkflowList).stream().filter(Objects::nonNull).filter(x -> {
                    List nodeRelations = workflow.getNodeRelations();
                    Set preWorkflowNodeRelations = ListUtils.emptyIfNull((List)nodeRelations).stream().filter(y -> y.getFrom().equalsIgnoreCase(x.getNodeId())).filter(y -> y.getTo().equalsIgnoreCase(bwmNode.getId())).collect(Collectors.toSet());
                    return CollectionUtils.isNotEmpty(preWorkflowNodeRelations);
                }).map(WorkflowNode::getTNodeId).collect(Collectors.toList());
                ArrayList preTNodeIdsWithProjectId = new ArrayList();
                preTNodeIds.forEach(preTNodeId -> workflow.getWorkflowNodes().stream().filter(node -> node.getTNodeId() != null && node.getTNodeId().equals(preTNodeId)).findFirst().ifPresent(x -> preTNodeIdsWithProjectId.add(x.getProjectName() + "." + preTNodeId)));
                workflowNode.setParentTargetIds(preTNodeIdsWithProjectId);
                this.createFolder(workflowNode.getCategoryValue(), workflowNode.getProjectId(), workflow.getWorkflowName());
                boolean isCreate = false;
                Long isExistedNodeId = this.getExistedNode(workflowNode);
                if (Objects.nonNull(isExistedNodeId) && isExistedNodeId != 0L) {
                    workflowNode.setTNodeId(String.valueOf(isExistedNodeId));
                    SingleResponse<Long> updateResp = this.updateNode(workflowNode, "" + isExistedNodeId, Boolean.TRUE);
                    isCreateOrUpdateNode = updateResp.isSuccess();
                } else {
                    isCreate = true;
                    SingleResponse<Long> createResp = this.createNode(workflowNode);
                    isCreateOrUpdateNode = createResp.isSuccess();
                    if (isCreateOrUpdateNode) {
                        Long dwId = (Long)createResp.getData();
                        if (CodeProgramType.DI == BwmCommonUtil.getCodeType(workflowNode.getNodeType()) && dwId > 0L) {
                            this.updateNode(workflowNode, "" + dwId, Boolean.FALSE);
                        }
                        workflowNode.setTNodeId(String.valueOf(dwId));
                    }
                }
                this.submit(workflowNode.getProjectId(), workflowNode.getTNodeId());
                log.info("\u5f53\u524dworkflow \uff1a {} \u5f53\u524dnode\uff1a{} \u662f\u5426\u521b\u5efa: {}, \u662f\u5426\u66f4\u65b0\uff1a{} \u8282\u70b9\u603b\u4e2a\u6570\u4e3a\uff1a{} ,\u5269\u4f59\u5b8c\u6210\u4e2a\u6570: {} ", new Object[]{workflow.getWorkflowName(), workflowNode.getNodeName(), isCreate, !isCreate, size, nodeCount.decrementAndGet()});
                preWorkflowList.add(workflowNode);
            }
        }
        boolean isCreateResourceSuccess = this.createFiles(workflow.getFiles(), workflow.getProjectId(), workflow.getWorkflowName());
        boolean isCreateFunction = this.createFunction(workflow.getFunctions(), workflow.getProjectId(), workflow.getWorkflowName());
        if (!isCreateOrUpdateNode) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_WRITE_FAILED);
        }
        if (!isCreateFunction) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.CREATE_FUN_FAILED);
        }
        if (!isCreateResourceSuccess) {
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.CREATE_RESOURCE_FAILED);
        }
        return String.valueOf(workflowBaseResp.getData() == null ? null : String.valueOf(workflowBaseResp.getData()));
    }

    private SingleResponse<Long> createWorkflowBase(Workflow workflow) {
        try {
            Long existWorkflowId = this.existWorkflowId(workflow);
            if (Objects.nonNull(existWorkflowId) && existWorkflowId != 0L) {
                log.warn("\u5f53\u524dworkflow \uff1a {} \u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa", (Object)workflow.getWorkflowName());
                return SingleResponse.of((Object)existWorkflowId);
            }
            Long workflowBaseReal = this.createWorkflowBaseReal(workflow);
            return SingleResponse.of((Object)workflowBaseReal);
        }
        catch (Exception e) {
            log.error("createWorkflowBase error", (Throwable)e);
            return SingleResponse.buildFailure((String)BwmServiceErrorCode.CREATE_WORKFLOW_BASE_FAILED.getDescription(), (String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createFiles(List<WorkflowFileResource> workflowFileResources, String projectId, String workflowName) {
        if (CollectionUtils.isEmpty(workflowFileResources)) {
            return Boolean.TRUE;
        }
        Boolean res = Boolean.TRUE;
        Iterator<WorkflowFileResource> iterator = workflowFileResources.iterator();
        while (iterator.hasNext()) {
            WorkflowFileResource workflowFileResource = iterator.next();
            try {
                block9: {
                    CreateResourceFileResponse response;
                    if (!new File(workflowFileResource.getPath()).exists()) {
                        log.info("\u672c\u5730\u8d44\u6e90\u6587\u4ef6\u4e22\u5931\uff1a {}", (Object)workflowFileResource.getName());
                        this.taskContext.getStatisticOp().addWorkflowResourceFailure(workflowFileResource.getFileId(), "\u672c\u5730\u8d44\u6e90\u6587\u4ef6\u4e22\u5931");
                        continue;
                    }
                    Long existResourceFileId = this.existResourceFileId(workflowFileResource, projectId);
                    Boolean resourceReUploadEnable = (Boolean)JSONObject.parseObject((String)this.taskContext.getBwmConfiguration()).get("if.resource.existed.update.or.not");
                    if (existResourceFileId != null && existResourceFileId > 0L) {
                        if (resourceReUploadEnable != null && resourceReUploadEnable.booleanValue()) {
                            log.info("\u8d44\u6e90\u6587\u4ef6\uff1a {} \u5df2\u5b58\u5728\uff0c\u5220\u9664\u540e\u91cd\u5efa", (Object)workflowFileResource.getName());
                            this.deleteResourceFile(Long.parseLong(projectId), existResourceFileId);
                            response = (CreateResourceFileResponse)this.createResourceFileReal(workflowFileResource, projectId, workflowName);
                            this.submitResource(projectId, response.getBody().getData().toString());
                            break block9;
                        } else {
                            log.info("\u8d44\u6e90\u6587\u4ef6\uff1a {} \u5df2\u5b58\u5728\uff0c\u8df3\u8fc7", (Object)workflowFileResource.getName());
                            continue;
                        }
                    }
                    log.info("\u8d44\u6e90\u6587\u4ef6\uff1a {} \u521b\u5efa", (Object)workflowFileResource.getName());
                    response = (CreateResourceFileResponse)this.createResourceFileReal(workflowFileResource, projectId, workflowName);
                    this.submitResource(projectId, response.getBody().getData().toString());
                }
                this.taskContext.getStatisticOp().addWorkflowResourceSuccess(workflowFileResource.getFileId());
            }
            catch (Exception e) {
                log.error("create File error file={}", (Object)workflowFileResource.getName(), (Object)e);
                res = Boolean.FALSE;
                this.taskContext.getStatisticOp().addWorkflowResourceFailure(workflowFileResource.getFileId(), e.getMessage());
                continue;
            }
            break;
        }
        return res;
    }

    protected boolean createFunction(List<WorkflowFunctionResource> workflowFunctionResources, String projectId, String workflowName) {
        if (CollectionUtils.isEmpty(workflowFunctionResources)) {
            return Boolean.TRUE;
        }
        Boolean res = Boolean.TRUE;
        for (WorkflowFunctionResource workflowFunctionResource : workflowFunctionResources) {
            try {
                Long id = (Long)this.createFunctionReal(workflowFunctionResource, projectId, workflowName);
                this.submitUdf(projectId, id.toString());
                this.taskContext.getStatisticOp().addWorkflowFunSuccess(workflowFunctionResource.getFunctionId());
            }
            catch (Exception e) {
                log.error("create function error function={}", (Object)workflowFunctionResource.getName(), (Object)e);
                res = false;
                this.taskContext.getStatisticOp().addWorkflowFunFailure(workflowFunctionResource.getFunctionId(), e.getMessage());
            }
        }
        return res;
    }

    protected SingleResponse<Long> createNode(WorkflowNode workflowNode) {
        try {
            Long workflowBaseReal = this.createNodeReal(workflowNode);
            this.taskContext.getStatisticOp().addWorkflowNodeSuccess(workflowNode.getNodeId());
            return SingleResponse.of((Object)workflowBaseReal);
        }
        catch (Exception e) {
            log.error("createNodeReal error workflow={} workflownode={}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
            this.taskContext.getStatisticOp().addWorkflowNodeFailure(workflowNode.getNodeId(), e.getMessage());
            return SingleResponse.buildFailure((String)BwmServiceErrorCode.NODE_WRITE_FAILED.getDescription(), (String)e.getMessage());
        }
    }

    private SingleResponse<Long> updateNode(WorkflowNode workflowNode, String fieldId, boolean isStatistic) {
        try {
            Long workflowBaseReal = this.updateNodeReal(workflowNode, fieldId);
            if (isStatistic) {
                this.taskContext.getStatisticOp().addWorkflowNodeSuccess(workflowNode.getNodeId());
            }
            return SingleResponse.of((Object)workflowBaseReal);
        }
        catch (Exception e) {
            log.error("updateNode error", (Throwable)e);
            if (isStatistic) {
                this.taskContext.getStatisticOp().addWorkflowNodeFailure(workflowNode.getNodeId(), e.getMessage());
            }
            return SingleResponse.buildFailure((String)BwmServiceErrorCode.NODE_UPDATE_FAILED.getDescription(), (String)e.getMessage());
        }
    }

    private void submit(String projectId, String fieldId) {
        String bwmConfigurationStr = this.taskContext.getBwmConfiguration();
        BwmConfiguration fromConf = BwmConfiguration.from(bwmConfigurationStr);
        Boolean isAutoSubmit = ((JSONObject)fromConf.get("conf")).getBoolean("workflowAutoDeploy");
        if (isAutoSubmit == null) {
            isAutoSubmit = false;
        }
        if (isAutoSubmit.booleanValue()) {
            this.submitReal(projectId, fieldId);
        }
    }

    private void submitResource(String projectId, String fieldId) {
        String bwmConfigurationStr = this.taskContext.getBwmConfiguration();
        BwmConfiguration fromConf = BwmConfiguration.from(bwmConfigurationStr);
        Boolean isAutoSubmit = fromConf.getBool("resourceAutoCommit", false);
        if (isAutoSubmit.booleanValue()) {
            this.submitReal(projectId, fieldId);
        }
    }

    private void submitUdf(String projectId, String fieldId) {
        String bwmConfigurationStr = this.taskContext.getBwmConfiguration();
        BwmConfiguration fromConf = BwmConfiguration.from(bwmConfigurationStr);
        Boolean isAutoSubmit = fromConf.getBool("functionAutoCommit", false);
        if (isAutoSubmit.booleanValue()) {
            this.submitReal(projectId, fieldId);
        }
    }

    public StatisticOp makeXlxStatisticOp() {
        WorkflowProjectPackage pkg = this.taskContext.getTargetWorkflowProjectPackage() != null ? this.taskContext.getTargetWorkflowProjectPackage() : this.taskContext.getWorkflowProjectPackage();
        StatisticOp statisticOp = super.makeXlxStatisticOp(pkg);
        this.taskContext.setLocalXlsStatisticOp(statisticOp);
        return statisticOp;
    }

    public void close() {
        this.taskContext.getStatisticOp().print();
    }
}

