/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractPlugin;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrSnapshotFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmRegexUtil;
import com.aliyun.migrationx.common.context.TransformerContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReader
extends AbstractPlugin
implements Reader {
    private static final Logger log = LoggerFactory.getLogger(AbstractReader.class);

    public List<WorkflowProject> getProjectList() {
        return List.of();
    }

    protected void optimalizeReader() {
        String outFilePath;
        Datasource readerDatasource = this.taskContext.getReaderDatasource();
        Map properties = readerDatasource.getProperties();
        String sourFilePath = (String)properties.get("source-file-path");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourFilePath})) {
            this.taskContext.setSourceFilePackage(sourFilePath);
        }
        if (StringUtils.isNotBlank((CharSequence)(outFilePath = (String)properties.get("export-file-path")))) {
            this.taskContext.setTargetFilePackage(outFilePath);
        }
    }

    protected void supplyDataSourceOperatorType(Datasource scheduleDataSource) {
        Map connectionMap = scheduleDataSource.getProperties();
        if (Objects.isNull(scheduleDataSource.getOperaterType())) {
            String operatorTypeSt = ((Map)Optional.ofNullable(connectionMap).orElse(new HashMap())).getOrDefault("operator", Datasource.OperaterType.AUTO.name());
            Datasource.OperaterType operaterType = Datasource.OperaterType.of((String)operatorTypeSt);
            scheduleDataSource.setOperaterType(operaterType);
        }
    }

    public void workflowListSort() {
        List<String> workflowWhiteList = this.getWorkflowWhiteList();
        if (!workflowWhiteList.isEmpty()) {
            ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
            for (Workflow wf : this.taskContext.getWorkflowProjectPackage().getWorkflowList()) {
                if (!this.isWorkflowInList(workflowWhiteList, wf)) continue;
                workflowList.add(wf);
            }
            this.taskContext.getWorkflowProjectPackage().setWorkflowList(workflowList);
            if (workflowList.isEmpty()) {
                log.warn("\u7ecf\u8fc7\u767d\u540d\u5355\u7b5b\u9009\u540e\uff0cworkflow\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            return;
        }
        List<String> workflowBlackList = this.getWorkflowBlackList();
        if (!workflowBlackList.isEmpty()) {
            ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
            for (Workflow wf : this.taskContext.getWorkflowProjectPackage().getWorkflowList()) {
                if (this.isWorkflowInList(workflowBlackList, wf)) continue;
                workflowList.add(wf);
            }
            this.taskContext.getWorkflowProjectPackage().setWorkflowList(workflowList);
            if (workflowList.isEmpty()) {
                log.warn("\u7ecf\u8fc7\u9ed1\u540d\u5355\u7b5b\u9009\u540e\uff0cworkflow\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
        }
    }

    public List<String> getWorkflowBlackList() {
        JSONObject conf = JSONObject.parseObject((String)this.taskContext.getBwmConfiguration());
        if (conf != null && conf.containsKey("workflow.black.list")) {
            ArrayList<String> workflowBlackList = new ArrayList<String>();
            Arrays.stream(conf.getString("workflow.black.list").split(",")).toList().forEach(workflowStr -> workflowBlackList.add(workflowStr.trim()));
            return workflowBlackList;
        }
        return Collections.emptyList();
    }

    public List<String> getWorkflowWhiteList() {
        JSONObject conf = JSONObject.parseObject((String)this.taskContext.getBwmConfiguration());
        if (conf != null && conf.containsKey("workflow.white.list")) {
            ArrayList<String> workflowWhiteList = new ArrayList<String>();
            Arrays.stream(conf.getString("workflow.white.list").split(",")).toList().forEach(workflowStr -> workflowWhiteList.add(workflowStr.trim()));
            return workflowWhiteList;
        }
        return Collections.emptyList();
    }

    public boolean isWorkflowInList(List<String> workflowList, Workflow wf) {
        List<String> workflowWhiteList = this.getWorkflowWhiteList();
        if (workflowList == null || workflowList.isEmpty()) {
            return false;
        }
        if (wf.getWorkflowId() != null && workflowList.contains(wf.getWorkflowId())) {
            return true;
        }
        if (wf.getWorkflowName() != null && workflowList.contains(wf.getWorkflowName())) {
            return true;
        }
        if (wf.getWorkflowName() != null) {
            for (String entry : workflowList) {
                if (!BwmRegexUtil.match(entry, wf.getWorkflowName())) continue;
                return true;
            }
        }
        return false;
    }

    public StatisticOp makeStatisticOp() {
        WorkflowProjectPackage pkg = this.taskContext.getTargetWorkflowProjectPackage() != null ? this.taskContext.getTargetWorkflowProjectPackage() : this.taskContext.getWorkflowProjectPackage();
        StatisticOp statisticOp = super.makeXlxStatisticOp(pkg);
        this.taskContext.setLocalXlsStatisticOp(statisticOp);
        return statisticOp;
    }

    @Override
    public String export() {
        File sourceFile;
        this.freshPackageBasicInfo(this.taskContext.getWorkflowProjectPackage());
        this.freshPackageBasicInfo(this.taskContext.getTargetWorkflowProjectPackage());
        if (this.taskContext.getSaasConfiguration() != null) {
            if (this.taskContext.getTargetWorkflowProjectPackage() != null) {
                BwmPackageSrSnapshotFileOperator.writeDiscoverySrSnapshotFile(this.taskContext.getTargetWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            } else {
                BwmPackageSrSnapshotFileOperator.writeDiscoverySrSnapshotFile(this.taskContext.getWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            }
        }
        String export = super.export();
        String sourceFilePath = (String)this.taskContext.getReaderDatasource().getProperties().get("source-file-path");
        if (sourceFilePath.endsWith(".zip") && (sourceFile = new File(sourceFilePath = sourceFilePath.substring(0, sourceFilePath.length() - 4))).exists()) {
            try {
                FileUtils.forceDelete((File)sourceFile);
            }
            catch (Exception e) {
                log.error("delete.source.file.error", (Throwable)e);
            }
        }
        return export;
    }

    public Workflow read(String workflowId) {
        return null;
    }

    public WorkflowProject getWorkflowProject() {
        return null;
    }

    public List<Workflow> getWorkflowList() {
        return null;
    }

    public List<WorkflowNode> getNodes() {
        return null;
    }

    public List<WorkflowFileResource> getFiles() {
        return null;
    }

    public List<WorkflowFunctionResource> getFunctions() {
        return null;
    }

    public void close() {
        TransformerContext.clear();
    }
}

