/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageXlsReportFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmPackageCheckingUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlugin.class);
    protected TaskContext taskContext;

    protected void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    protected String export() {
        try {
            String outPath = Optional.ofNullable(this.taskContext.getTargetFilePackage()).orElse("temp");
            if (this.taskContext.getTargetWorkflowProjectPackage() != null) {
                BwmPackageFileOperator.writeFile(this.taskContext.getTargetWorkflowProjectPackage(), this.taskContext.getLocalXlsStatisticOp(), new File(outPath));
            } else {
                BwmPackageFileOperator.writeFile(this.taskContext.getWorkflowProjectPackage(), this.taskContext.getLocalXlsStatisticOp(), new File(outPath));
            }
        }
        catch (IOException e) {
            log.error("write file error", (Throwable)e);
            return null;
        }
        return this.taskContext.getTargetFilePackage();
    }

    public void freshPackageBasicInfo(WorkflowProjectPackage pkg) {
        if (ObjectUtils.isEmpty((Object)pkg)) {
            return;
        }
        WorkflowProject workflowProject = pkg.getWorkflowProject();
        String projectName = workflowProject.getName();
        String projectId = workflowProject.getProjectId();
        if (CollectionUtils.isNotEmpty((Collection)pkg.getWorkflowList())) {
            pkg.getWorkflowList().forEach(workflow -> {
                if (StringUtils.isBlank((CharSequence)workflow.getProjectId())) {
                    workflow.setProjectId(projectId);
                }
                if (StringUtils.isBlank((CharSequence)workflow.getProjectName())) {
                    workflow.setProjectName(projectName);
                }
                if (CollectionUtils.isNotEmpty((Collection)workflow.getWorkflowNodes())) {
                    workflow.getWorkflowNodes().forEach(node -> {
                        if (StringUtils.isBlank((CharSequence)node.getProjectId())) {
                            node.setProjectId(projectId);
                        }
                        if (StringUtils.isBlank((CharSequence)node.getProjectName())) {
                            node.setProjectName(projectName);
                        }
                        if (StringUtils.isBlank((CharSequence)node.getWorkflowId())) {
                            node.setWorkflowId(workflow.getWorkflowId());
                        }
                        if (StringUtils.isBlank((CharSequence)node.getWorkflowName())) {
                            node.setWorkflowName(workflow.getWorkflowName());
                        }
                    });
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)pkg.getFiles())) {
            pkg.getFiles().forEach(file -> {
                if (StringUtils.isBlank((CharSequence)file.getProjectId())) {
                    file.setProjectId(projectId);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)pkg.getFunctions())) {
            pkg.getFunctions().forEach(function -> {
                if (StringUtils.isBlank((CharSequence)function.getProjectId())) {
                    function.setProjectId(projectId);
                }
            });
        }
    }

    public StatisticOp makeXlxStatisticOp(WorkflowProjectPackage pkg) {
        log.info("\u7ed3\u679c\u5305\u5185\u5bb9\u68c0\u67e5\uff1a");
        BwmPackageCheckingUtil bwmPackageCheckingUtil = new BwmPackageCheckingUtil(pkg);
        bwmPackageCheckingUtil.oneClickChecking();
        bwmPackageCheckingUtil.logCheckingReport();
        return BwmPackageXlsReportFileOperator.makeStatisticOp(pkg);
    }

    protected WorkflowProjectPackage getWorkflowPackage() {
        return null;
    }
}

