/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common;

import com.alibaba.cola.dto.SingleResponse;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CycleType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.CronExpressUtil;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.AbstractPlugin;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.config.FilterRule;
import com.aliyun.migration.workflow.migration.common.config.FilterRuleGroup;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrResultStatisticFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrSnapshotFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmRegexUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractConverter
extends AbstractPlugin
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(AbstractConverter.class);
    protected String sourceFilePath;
    protected String targetFilePath;
    protected Map<String, Object> selfConfMap;
    protected FilterRuleGroup filterRuleGroup;
    protected List<String> workflowResourceBlackList = new ArrayList<String>();
    protected List<String> workflowUdfBlackList = new ArrayList<String>();
    protected AbstractConvertFactory convertFactory;

    public abstract AbstractConvertFactory getConvertFactory();

    public Converter init(TaskContext taskContext) throws IOException {
        this.setTaskContext(taskContext);
        Datasource readerDatasource = taskContext.getReaderDatasource();
        Map readerDatasourceProperties = readerDatasource.getProperties();
        this.sourceFilePath = (String)readerDatasourceProperties.get("export-file-path");
        Datasource writerDatasource = taskContext.getWriterDatasource();
        Map writerDatasourceProperties = writerDatasource.getProperties();
        this.targetFilePath = (String)writerDatasourceProperties.get("source-file-path");
        taskContext.setTargetFilePackage(this.targetFilePath);
        BwmConfiguration bwmConfiguration = BwmConfiguration.from(taskContext.getBwmConfiguration());
        this.selfConfMap = bwmConfiguration.getMap("self", new HashMap<String, Object>());
        this.prepareFilterRuleGroup();
        this.prepareBlackList();
        Boolean isUseMx = (Boolean)this.selfConfMap.getOrDefault("if.use.migrationx.before", false);
        Boolean isUseDwNewIdea = (Boolean)this.selfConfMap.getOrDefault("if.use.dataworks.newidea", false);
        this.taskContext.setIsUserDataWorksFlowSpec(isUseDwNewIdea);
        this.taskContext.setIsUserMx(isUseMx);
        this.convertFactory = this.getConvertFactory();
        return this;
    }

    @Override
    protected WorkflowProjectPackage getWorkflowPackage() {
        WorkflowProjectPackage workflowProjectPackage = this.taskContext.getWorkflowProjectPackage();
        if (Objects.isNull(workflowProjectPackage)) {
            BwmSaasConfiguration bwmSaasConfiguration;
            Datasource readerDatasource = this.taskContext.getReaderDatasource();
            Map readerDatasourceProperties = readerDatasource.getProperties();
            String filePath = (String)readerDatasourceProperties.get("export-file-path");
            if (filePath == null || !new File(filePath).exists()) {
                log.warn("not found bwm package");
                return new WorkflowProjectPackage();
            }
            String sqlTransResultFilePath = null;
            if (StringUtils.isNotBlank((CharSequence)this.taskContext.getSaasConfiguration()) && (bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class)).getLocal() != null && bwmSaasConfiguration.getLocal().getInputFileReadPath() != null) {
                sqlTransResultFilePath = bwmSaasConfiguration.getLocal().getInputFileReadPath().getMainPackageExtendedScriptFolder();
            }
            workflowProjectPackage = BwmPackageFileOperator.readFile(filePath, sqlTransResultFilePath);
        }
        if (Objects.isNull(workflowProjectPackage)) {
            log.warn("package is null");
            return new WorkflowProjectPackage();
        }
        return workflowProjectPackage;
    }

    protected void prepareFilterRuleGroup() {
        this.filterRuleGroup = new FilterRuleGroup();
        this.filterRuleGroup.setFilterRuleList(new ArrayList<FilterRule>());
        if (this.selfConfMap.containsKey("filter.rule")) {
            ((JSONArray)this.selfConfMap.get("filter.rule")).forEach(item -> {
                FilterRule filterRule = new FilterRule(((JSONObject)item).toJSONString(new JSONWriter.Feature[0]));
                this.filterRuleGroup.getFilterRuleList().add(filterRule);
            });
        }
    }

    protected void prepareBlackList() {
        this.getBlackList("workflow.resource.black.list", this.workflowResourceBlackList);
        this.getBlackList("workflow.udf.black.list", this.workflowUdfBlackList);
    }

    protected void getBlackList(String blackListName, List<String> blackList) {
        String blackListStr = (String)this.selfConfMap.get(blackListName);
        if (StringUtils.isBlank((CharSequence)blackListStr)) {
            return;
        }
        Arrays.asList(blackListStr.split(",")).forEach(x -> blackList.add(x.trim()));
    }

    protected Boolean inBlackListOrNot(String name, String id, List<String> blackList) {
        if (blackList == null || blackList.isEmpty()) {
            return false;
        }
        if (id != null && blackList.contains(id)) {
            return true;
        }
        if (name != null && blackList.contains(name)) {
            return true;
        }
        for (String entry : blackList) {
            if (!BwmRegexUtil.match(entry, name)) continue;
            return true;
        }
        return false;
    }

    public abstract WorkflowProjectPackage convertUseMx();

    public abstract WorkflowProjectPackage convertSelf();

    public WorkflowProjectPackage convert() {
        WorkflowProjectPackage workflowProjectPackage = null;
        if (this.taskContext.getIsUserMx().booleanValue()) {
            workflowProjectPackage = this.convertUseMx();
            this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
            return workflowProjectPackage;
        }
        WorkflowProjectPackage targetWorkflowProjectPackage = this.convertSelf();
        this.taskContext.setTargetWorkflowProjectPackage(targetWorkflowProjectPackage);
        targetWorkflowProjectPackage.getWorkflowList().forEach(wf -> wf.getWorkflowNodes().forEach(node -> this.taskContext.getStatisticOp().addWorkflowNodeResult(node.getNodeId(), Integer.valueOf(1))));
        return targetWorkflowProjectPackage;
    }

    protected void convertParam(Workflow tgtWorkflow) {
    }

    protected WorkflowNode getCustomWorkflowNode(WorkflowNode originNode) {
        return originNode;
    }

    public SingleResponse<Boolean> check() {
        return SingleResponse.of((Object)Boolean.TRUE);
    }

    protected void convertCustomProperties(Map<String, Object> customProperties, Workflow tgtWorkflow) {
        if (CollectionUtils.isEmpty(customProperties)) {
            return;
        }
        List workflowNodes = tgtWorkflow.getWorkflowNodes();
        Optional.ofNullable(workflowNodes).orElseGet(ArrayList::new).forEach(x -> {
            if (CollectionUtils.isEmpty((Map)x.getParamMap())) {
                x.setParamMap(new HashMap());
            }
            if ((this.taskContext.getIsUserDataWorksFlowSpec() == null || !this.taskContext.getIsUserDataWorksFlowSpec().booleanValue()) && customProperties.containsKey("param")) {
                for (String key : ((HashMap)customProperties.get("param")).keySet()) {
                    x.getParamMap().put(key, ((HashMap)customProperties.get("param")).get(key));
                }
            }
        });
    }

    protected void convertTrigger(List<WorkflowTrigger> triggers, Workflow tgtWorkflow) {
        if (CollectionUtils.isEmpty(triggers)) {
            return;
        }
        WorkflowTrigger workflowTrigger = triggers.get(0);
        workflowTrigger.setCron(this.convertCrontab(workflowTrigger.getCron()));
        CycleType cycleTypeByCode = CycleType.getCycleTypeByCode((int)CronExpressUtil.parseCronToCycleType((String)workflowTrigger.getCron()));
        workflowTrigger.setType(cycleTypeByCode.name());
        List workflowNodes = tgtWorkflow.getWorkflowNodes();
        Optional.ofNullable(workflowNodes).orElseGet(ArrayList::new).forEach(x -> x.setTrigger(workflowTrigger));
        tgtWorkflow.setTriggers(List.of(workflowTrigger));
    }

    protected String convertCrontab(String scheduleCrontab) {
        try {
            return CronExpressUtil.quartzCronExpressionToDwCronExpress((String)scheduleCrontab);
        }
        catch (ParseException e) {
            log.error("convert quartz cron expression error: ", (Throwable)e);
            return "day";
        }
    }

    protected void compactNodeMap(WorkflowNode workflowNode, List<WorkflowNode> tgtNodes) {
        if (CollectionUtils.isEmpty(tgtNodes)) {
            StatisticOp.NodeMapping nodeMapping = new StatisticOp.NodeMapping();
            nodeMapping.setProjectName(workflowNode.getProjectName());
            nodeMapping.setWorkflowName(workflowNode.getWorkflowId());
            nodeMapping.setSrcNodeId(workflowNode.getNodeId());
            nodeMapping.setSrcNodeName(workflowNode.getNodeName());
            this.taskContext.getStatisticOp().addNodeMap(nodeMapping);
        } else {
            tgtNodes.forEach(x -> {
                StatisticOp.NodeMapping nodeMapping = new StatisticOp.NodeMapping();
                nodeMapping.setProjectName(workflowNode.getProjectName());
                nodeMapping.setWorkflowName(workflowNode.getWorkflowId());
                nodeMapping.setSrcNodeId(workflowNode.getNodeId());
                nodeMapping.setSrcNodeName(workflowNode.getNodeName());
                nodeMapping.setTgtNodeId(x.getNodeId());
                nodeMapping.setTgtNodeName(x.getNodeName());
                this.taskContext.getStatisticOp().addNodeMap(nodeMapping);
            });
        }
    }

    protected void rebuildRelation(List<RelationPackage> relationPackages, WorkflowNode workflowNode, List<WorkflowNode> tgtNodes, List<RelationPackage> orgRelationPackages) {
        if (CollectionUtils.isEmpty(relationPackages)) {
            return;
        }
        List<RelationPackage> parents = ((List)Optional.of(orgRelationPackages).orElse(new ArrayList())).stream().filter(x -> x.getTo().equals(workflowNode.getNodeId())).collect(Collectors.toList());
        List<RelationPackage> children = ((List)Optional.of(orgRelationPackages).orElse(new ArrayList())).stream().filter(x -> x.getFrom().equals(workflowNode.getNodeId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tgtNodes)) {
            Optional.of(parents).orElseGet(ArrayList::new).forEach(relationPackage -> {
                relationPackages.remove(relationPackage);
                String from = relationPackage.getFrom();
                Optional.of(children).orElseGet(ArrayList::new).forEach(x -> {
                    relationPackages.remove(x);
                    String to = x.getTo();
                    relationPackages.add(RelationPackage.builder().from(from).to(to).reType(RelationPackage.ReType.NODE).build());
                });
            });
        } else {
            ArrayList<WorkflowNode> firstNodes = new ArrayList<WorkflowNode>();
            ArrayList<WorkflowNode> endNodes = new ArrayList<WorkflowNode>();
            this.zeroDegreeList(ListUtils.subtract(relationPackages, orgRelationPackages), tgtNodes, firstNodes, endNodes);
            this.removeRelationIfTgtNotExist(relationPackages, tgtNodes, workflowNode, parents, children);
            for (WorkflowNode firstNode : firstNodes) {
                Optional.of(parents).orElseGet(ArrayList::new).forEach(relationPackage -> {
                    if (relationPackages.contains(relationPackage)) {
                        relationPackages.remove(relationPackage);
                    }
                    String from = relationPackage.getFrom();
                    relationPackages.add(RelationPackage.builder().from(from).to(firstNode.getNodeId()).reType(RelationPackage.ReType.NODE).build());
                });
            }
            for (WorkflowNode endNode : endNodes) {
                Optional.of(children).orElseGet(ArrayList::new).forEach(relationPackage -> {
                    if (relationPackages.contains(relationPackage)) {
                        relationPackages.remove(relationPackage);
                    }
                    String to = relationPackage.getTo();
                    relationPackages.add(RelationPackage.builder().from(endNode.getNodeId()).to(to).reType(RelationPackage.ReType.NODE).build());
                });
            }
        }
    }

    private void removeRelationIfTgtNotExist(List<RelationPackage> relationPackages, List<WorkflowNode> tgtNodes, WorkflowNode workflowNode, List<RelationPackage> parents, List<RelationPackage> children) {
        boolean origIsExist = false;
        for (WorkflowNode tgtNode : tgtNodes) {
            if (!tgtNode.getNodeId().equalsIgnoreCase(workflowNode.getNodeId())) continue;
            origIsExist = true;
            break;
        }
        if (!origIsExist) {
            Optional.of(parents).orElseGet(ArrayList::new).forEach(relationPackage -> relationPackages.remove(relationPackage));
            Optional.of(children).orElseGet(ArrayList::new).forEach(relationPackage -> relationPackages.remove(relationPackage));
        }
    }

    public void zeroDegreeList(List<RelationPackage> relationPackages, List<WorkflowNode> tgtNodes, List<WorkflowNode> firstNodeList, List<WorkflowNode> endNodeList) {
        for (WorkflowNode node : tgtNodes) {
            int inDegree = 0;
            int outDegree = 0;
            for (RelationPackage relation : relationPackages) {
                if (relation.getFrom().equals(node.getNodeId())) {
                    ++outDegree;
                }
                if (!relation.getTo().equals(node.getNodeId())) continue;
                ++inDegree;
            }
            if (inDegree == 0) {
                firstNodeList.add(node);
            }
            if (outDegree != 0) continue;
            endNodeList.add(node);
        }
    }

    public void addRelations(List<RelationPackage> relationPackages, RelationPackage relationPackage) {
        if (CollectionUtils.isEmpty(relationPackages)) {
            relationPackages = new ArrayList<RelationPackage>();
        }
        if (!relationPackages.contains(relationPackage)) {
            relationPackages.add(relationPackage);
        }
    }

    protected static <T> T convertAll(AbstractConvert<T> convert, T t, String identifier, String name, StatisticOp.StatisticIterm totalIterm, StatisticOp.StatisticIterm succsssIterm, StatisticOp.StatisticIterm failIterm) {
        if (Objects.nonNull(totalIterm)) {
            totalIterm.incrementOne(identifier);
        }
        try {
            T res = convert.convert(t);
            if (Objects.nonNull(succsssIterm)) {
                succsssIterm.incrementOne(identifier);
            }
            return res;
        }
        catch (Exception e) {
            log.error("convert error identifier={} name={}", new Object[]{identifier, name, e});
            if (Objects.nonNull(failIterm)) {
                failIterm.incrementFailedOne(identifier, e.getMessage());
            }
            return null;
        }
    }

    public Map<String, Object> getParamValueMapSetting() {
        JSONObject paramMapStr = this.selfConfMap.getOrDefault("param.value.map", null);
        if (paramMapStr != null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (String key : paramMapStr.keySet()) {
                paramMap.put(key, paramMapStr.get(key));
            }
            return paramMap;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getParamMapSetting() {
        JSONObject paramMapStr = this.selfConfMap.getOrDefault("param.map", null);
        if (paramMapStr != null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (String key : paramMapStr.keySet()) {
                paramMap.put(key, paramMapStr.get(key));
            }
            return paramMap;
        }
        return new HashMap<String, Object>();
    }

    public StatisticOp makeXlxStatisticOp() {
        this.freshPackageBasicInfo(this.taskContext.getWorkflowProjectPackage());
        this.freshPackageBasicInfo(this.taskContext.getTargetWorkflowProjectPackage());
        WorkflowProjectPackage pkg = this.taskContext.getTargetWorkflowProjectPackage() != null ? this.taskContext.getTargetWorkflowProjectPackage() : this.taskContext.getWorkflowProjectPackage();
        StatisticOp statisticOp = super.makeXlxStatisticOp(pkg);
        this.taskContext.setLocalXlsStatisticOp(statisticOp);
        return statisticOp;
    }

    @Override
    public String export() {
        File sourceFile;
        if (this.taskContext.getSaasConfiguration() != null) {
            if (this.taskContext.getTargetWorkflowProjectPackage() != null) {
                BwmPackageSrSnapshotFileOperator.writeMigrationSrSnapshotFile(this.taskContext.getTargetWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingFile(this.taskContext.getTargetWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingOverviewFile(this.taskContext.getWorkflowProjectPackage(), this.taskContext.getTargetWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            } else {
                BwmPackageSrSnapshotFileOperator.writeMigrationSrSnapshotFile(this.taskContext.getWorkflowProjectPackage(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
                BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingFile(this.taskContext.getWorkflowProjectPackage(), this.taskContext.getStatisticOp(), (BwmSaasConfiguration)JSONObject.parseObject((String)this.taskContext.getSaasConfiguration(), BwmSaasConfiguration.class));
            }
        }
        String export = super.export();
        String sourceFilePath = (String)this.taskContext.getReaderDatasource().getProperties().get("source-file-path");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourceFilePath})) {
            if (sourceFilePath.endsWith(".zip")) {
                sourceFilePath = sourceFilePath.substring(0, sourceFilePath.length() - 4);
            }
            if ((sourceFile = new File(sourceFilePath)).exists()) {
                try {
                    FileUtils.forceDelete((File)sourceFile);
                }
                catch (Exception e) {
                    log.error("delete.source.file.error", (Throwable)e);
                }
            }
        }
        sourceFilePath = (String)this.taskContext.getReaderDatasource().getProperties().get("export-file-path");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sourceFilePath})) {
            if (sourceFilePath.endsWith(".zip")) {
                sourceFilePath = sourceFilePath.substring(0, sourceFilePath.length() - 4);
            }
            if ((sourceFile = new File(sourceFilePath)).exists()) {
                try {
                    FileUtils.forceDelete((File)sourceFile);
                }
                catch (Exception e) {
                    log.error("delete.source.file.error", (Throwable)e);
                }
            }
        }
        return export;
    }

    public void close() {
        this.taskContext.getStatisticOp().print();
    }
}

