/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.workflow.migration.common.utils.DwClient;
import com.aliyun.migration.workflow.migration.dw.openapi.tool.DwTaskTool;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwDIJobPlainMigrationCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(DwDIJobPlainMigrationCommand.class);

    public DwDIJobPlainMigrationCommand() {
        this.addOption();
    }

    @Override
    public void exec(String[] args) throws Exception {
        String targetResGroupId;
        String targetRealtimeResourceGroupIdentified;
        CommandLine cmd = this.parse.parse(this.options, args);
        if (cmd.hasOption("help")) {
            this.usage();
            return;
        }
        String sourceEndpoint = cmd.getOptionValue("sourceEndpoint");
        if (sourceEndpoint == null) {
            log.error("sourceEndpoint is null");
            return;
        }
        String sourceAk = cmd.getOptionValue("sourceAk");
        if (sourceAk == null) {
            log.error("sourceAk is null");
            return;
        }
        String sourceSk = cmd.getOptionValue("sourceSk");
        if (sourceSk == null) {
            log.error("sourceSk is null");
            return;
        }
        String sourceProjectId = cmd.getOptionValue("sourceProjectId");
        if (sourceProjectId == null) {
            log.error("sourceProjectId is null");
            return;
        }
        String sourceProjectName = cmd.getOptionValue("sourceProjectName");
        if (sourceProjectName == null) {
            log.error("sourceProjectName is null");
            return;
        }
        String targetEndpoint = cmd.getOptionValue("targetEndpoint");
        if (targetEndpoint == null) {
            log.error("targetEndpoint is null");
            return;
        }
        String targetAk = cmd.getOptionValue("targetAk");
        if (targetAk == null) {
            log.error("targetAk is null");
            return;
        }
        String targetSk = cmd.getOptionValue("targetSk");
        if (targetSk == null) {
            log.error("targetSk is null");
            return;
        }
        String targetProjectId = cmd.getOptionValue("targetProjectId");
        if (targetProjectId == null) {
            log.error("targetProjectId is null");
            return;
        }
        String targetProjectName = cmd.getOptionValue("targetProjectName");
        if (targetProjectName == null) {
            log.error("targetProjectName is null");
            return;
        }
        String targetOfflineResourceGroupIdentified = cmd.getOptionValue("targetOfflineResourceGroupIdentified");
        if (targetOfflineResourceGroupIdentified == null) {
            log.info("targetOfflineResourceGroupIdentified is null, use OrgSetting");
        }
        if ((targetRealtimeResourceGroupIdentified = cmd.getOptionValue("targetRealtimeResourceGroupIdentified")) == null) {
            log.info("targetRealtimeResourceGroupIdentified is null, use OrgSetting");
        }
        if ((targetResGroupId = cmd.getOptionValue("targetResGroupId")) == null) {
            log.info("targetResGroupId is null, use OrgSetting");
        }
        String clearAllDIJobBeforeImport = cmd.getOptionValue("clearAllDIJobBeforeImport");
        Boolean clearAllDIJobBeforeImportFlag = false;
        clearAllDIJobBeforeImportFlag = clearAllDIJobBeforeImport == null || !clearAllDIJobBeforeImport.equals("true") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        String nameTail = cmd.getOptionValue("nameTail");
        String getDIJobResponseFileName = cmd.getOptionValue("getDIJobResponseFileName");
        String createDIJobRequestFileName = cmd.getOptionValue("createDIJobRequestFileName");
        DwTaskTool sourceDwTaskTool = new DwTaskTool(sourceEndpoint, sourceAk, sourceSk);
        DwClient sourceDwClient = sourceDwTaskTool.getDwClient();
        List response = sourceDwClient.exportDIJobDefinationList(Long.parseLong(sourceProjectId));
        if (getDIJobResponseFileName != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(getDIJobResponseFileName));){
                writer.write(JSONArray.toJSONString((Object)response, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            }
        }
        DwTaskTool targetDwTaskTool = new DwTaskTool(targetEndpoint, targetAk, targetSk);
        DwClient targetDwClient = targetDwTaskTool.getDwClient();
        if (clearAllDIJobBeforeImportFlag.booleanValue()) {
            List targetResponse = targetDwClient.exportDIJobDefinationList(Long.parseLong(targetProjectId));
            targetDwClient.deleteDIJobListByGetResponse(targetResponse);
        }
        response.forEach(job -> {
            if (nameTail != null && !nameTail.equals("")) {
                job.jobName = job.jobName + "_" + nameTail;
            }
            job.projectId = Long.parseLong(targetProjectId);
            if (targetOfflineResourceGroupIdentified != null && job.getResourceSettings().getOfflineResourceSettings() != null) {
                job.getResourceSettings().getOfflineResourceSettings().setResourceGroupIdentifier(targetOfflineResourceGroupIdentified);
            }
            if (targetRealtimeResourceGroupIdentified != null && job.getResourceSettings().getRealtimeResourceSettings() != null) {
                job.getResourceSettings().getRealtimeResourceSettings().setResourceGroupIdentifier(targetRealtimeResourceGroupIdentified);
            }
            if (targetResGroupId != null && job.getTransformationRules() != null) {
                job.getTransformationRules().forEach(rule -> {
                    JSONObject ruleJSONObject;
                    if (rule.getRuleExpression().contains("\"resGroupId\"")) {
                        ruleJSONObject = JSONObject.parseObject((String)rule.getRuleExpression());
                        ruleJSONObject.put((Object)"resGroupId", (Object)targetResGroupId);
                        rule.setRuleExpression(ruleJSONObject.toJSONString(new JSONWriter.Feature[0]));
                    }
                    if (rule.getRuleExpression().contains("\"outputList\"")) {
                        ruleJSONObject = JSONObject.parseObject((String)rule.getRuleExpression());
                        JSONArray outputArray = new JSONArray();
                        ruleJSONObject.getJSONArray("outputList").forEach(output -> {
                            if (output.toString().contains("\"outputName\"")) {
                                JSONObject outputJSONObject = JSONObject.parseObject((String)output.toString());
                                Object outputName = outputJSONObject.getString("outputName");
                                outputName = targetProjectName + DwDIJobPlainMigrationCommand.getSubstringAfterFirstDot((String)outputName);
                                outputJSONObject.put((Object)"outputName", outputName);
                                outputArray.add((Object)outputJSONObject);
                            }
                        });
                        ruleJSONObject.put((Object)"outputList", (Object)outputArray);
                        rule.setRuleExpression(ruleJSONObject.toJSONString(new JSONWriter.Feature[0]));
                    }
                });
            }
        });
        ArrayList requests = new ArrayList();
        targetDwClient.importDIJobListByGetResponse(response, requests);
        if (createDIJobRequestFileName != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(createDIJobRequestFileName));){
                writer.write(JSONArray.toJSONString(requests, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            }
        }
        log.info("finish");
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    public static String getSubstringAfterFirstDot(String str) {
        int dotIndex = str.indexOf(46);
        if (dotIndex != -1 && dotIndex < str.length() - 1) {
            return str.substring(dotIndex);
        }
        return "";
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"sourceEndpoint").argName("sourceEndpoint").hasArg().desc("\u6e90\u7aefEndpoint").required(true).build());
        this.options.addOption(Option.builder((String)"sourceAk").argName("sourceAk").hasArg().desc("\u6e90\u7aefAk").required(true).build());
        this.options.addOption(Option.builder((String)"sourceSk").argName("sourceSk").hasArg().desc("\u6e90\u7aefSk").required(true).build());
        this.options.addOption(Option.builder((String)"sourceProjectId").argName("sourceProjectId").hasArg().desc("\u6e90\u7aefProjectId").required(true).build());
        this.options.addOption(Option.builder((String)"sourceProjectName").argName("sourceProjectName").hasArg().desc("\u6e90\u7aefProjectName").required(true).build());
        this.options.addOption(Option.builder((String)"targetEndpoint").argName("targetEndpoint").hasArg().desc("\u76ee\u6807\u7aefEndpoint").required(true).build());
        this.options.addOption(Option.builder((String)"targetAk").argName("targetAk").hasArg().desc("\u76ee\u6807\u7aefAk").required(true).build());
        this.options.addOption(Option.builder((String)"targetSk").argName("targetSk").hasArg().desc("\u76ee\u6807\u7aefSk").required(true).build());
        this.options.addOption(Option.builder((String)"targetProjectId").argName("targetProjectId").hasArg().desc("\u76ee\u6807\u7aefProjectId").required(true).build());
        this.options.addOption(Option.builder((String)"targetProjectName").argName("targetProjectName").hasArg().desc("\u76ee\u6807\u7aefProjectName").required(true).build());
        this.options.addOption(Option.builder((String)"targetOfflineResourceGroupIdentified").argName("targetOfflineResourceGroupIdentified").hasArg().desc("\u76ee\u6807\u7aef\u79bb\u7ebf\u6570\u636e\u96c6\u6210\u8d44\u6e90\u7ec4\uff0c\u4e0d\u586b\u5219\u6cbf\u7528\u6e90\u7aef\u8bbe\u7f6e").required(false).build());
        this.options.addOption(Option.builder((String)"targetRealtimeResourceGroupIdentified").argName("targetRealtimeResourceGroupIdentified").hasArg().desc("\u76ee\u6807\u7aef\u5728\u7ebf\u6570\u636e\u96c6\u6210\u8d44\u6e90\u7ec4\uff0c\u4e0d\u586b\u5219\u6cbf\u7528\u6e90\u7aef\u8bbe\u7f6e").required(false).build());
        this.options.addOption(Option.builder((String)"targetResGroupId").argName("targetResGroupId").hasArg().desc("\u76ee\u6807\u7aef\u6620\u5c04\u89c4\u5219Rule\u6240\u7528\u8d44\u6e90\u7ec4\uff0c\u6ce8\u610f\u586b\u5199Id\uff0c\u800c\u4e0d\u662fIdentified").required(false).build());
        this.options.addOption(Option.builder((String)"nameTail").argName("nameTail").hasArg().desc("\u76ee\u6807\u7aef\u4efb\u52a1\u540d\u65b0\u589e\u5c3e\u7f00\uff0c\u53ef\u4e3a\u7a7a").required(false).build());
        this.options.addOption(Option.builder((String)"clearAllDIJobBeforeImport").argName("clearAllDIJobBeforeImport").hasArg().desc("\u662f\u5426\u6e05\u7a7a\u76ee\u6807\u7aef\u6240\u6709\u6570\u636e\u96c6\u6210\u4efb\u52a1").required(false).build());
        this.options.addOption(Option.builder((String)"getDIJobResponseFileName").argName("getDIJobResponseFileName").hasArg().desc("\u662f\u5426\u5c06\u83b7\u53d6\u6e90\u7aefDIJob\u7684Response\u4fdd\u5b58\u4e3a\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"createDIJobRequestFileName").argName("createDIJobRequestFileName").hasArg().desc("\u662f\u5426\u5c06\u521b\u5efa\u76ee\u6807\u7aefDIJob\u7684Request\u4fdd\u5b58\u4e3a\u6587\u4ef6").required(false).build());
    }

    @Override
    public String getName() {
        return "dw_di_job_plain_migration";
    }

    @Override
    public String desc() {
        return "\u901a\u8fc7\u914d\u7f6e\u4e00\u952e\u5e73\u8fc1Dw\u6570\u636e\u96c6\u6210\u4efb\u52a1";
    }
}

