/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.sts;

import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessCredentialClient;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.core.AklessCredProviderFactory;
import com.aliyun.credentials.Client;
import com.aliyun.migration.teleport.cloud.client.StsService;
import com.aliyun.migration.teleport.cloud.entity.SecurityUserInfo;
import com.aliyun.migration.teleport.cloud.entity.StsProperties;
import com.aliyun.migration.teleport.cloud.service.PropertiesBuilder;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.sts20150401.models.AssumeRoleRequest;
import com.aliyun.sts20150401.models.AssumeRoleResponse;
import com.aliyun.sts20150401.models.AssumeRoleResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleWithServiceIdentityRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleWithServiceIdentityResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsServiceImpl
implements StsService {
    private static final Logger log = LoggerFactory.getLogger(StsServiceImpl.class);
    private static final Long STS_MAX_DURATION_SECONDS = 28800L;

    @Override
    public SecurityUserInfo getSTSUserInfo4Oss(String region) {
        return this.getSTSUserInfo(PropertiesBuilder.buildStsProperties(region));
    }

    @Override
    public SecurityUserInfo getSLRUserInfo4DataWorks(String region, String tenantId) {
        return this.getSLRUserInfo4DataWorks(PropertiesBuilder.buildSlrProperties4DataWorks(tenantId, region));
    }

    @Override
    public SecurityUserInfo getSTSUserInfo(StsProperties stsProperties) {
        String uid = stsProperties.getUid();
        String stsRole = stsProperties.getStsRole();
        String roleSessionName = stsProperties.getRoleSessionName();
        String arn = "acs:ram::" + uid + ":role/" + stsRole;
        log.info("[STS] try get SecurityUserInfo, uid={}, role={}, roleSession={}, arn={}", new Object[]{uid, stsRole, roleSessionName, arn});
        SecurityUserInfo userInfo = new SecurityUserInfo();
        userInfo.setUid(uid);
        try {
            AklessCredentialClient credentialClient = AklessCredProviderFactory.getCredentialClient((String)stsProperties.getAklessRamRoleArn());
            Config config = new Config().setCredential((Client)credentialClient).setEndpoint(stsProperties.getStsEndpoint());
            config.setRegionId(stsProperties.getRegion());
            com.aliyun.sts20150401.Client client = new com.aliyun.sts20150401.Client(config);
            AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().setRoleArn(arn).setDurationSeconds(STS_MAX_DURATION_SECONDS).setRoleSessionName(roleSessionName);
            RuntimeOptions runtime = new RuntimeOptions();
            AssumeRoleResponse response = client.assumeRoleWithOptions(assumeRoleRequest, runtime);
            AssumeRoleResponseBody body = response.getBody();
            AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials credentials = body.getCredentials();
            userInfo.setAccessKeyId(credentials.getAccessKeyId());
            userInfo.setAccessKeySecret(credentials.getAccessKeySecret());
            userInfo.setSessionToken(credentials.getSecurityToken());
            userInfo.setExpireTime(credentials.getExpiration());
            log.info("[STS] AssumedRoleUser {}", (Object)userInfo);
            return userInfo;
        }
        catch (Exception e) {
            String entityNotExist = "EntityNotExist.Role";
            String noPermission = "NoPermission";
            if (e.getLocalizedMessage().contains(entityNotExist) || e.getLocalizedMessage().contains(noPermission)) {
                log.error("[STS] NoPermission", (Throwable)e);
                throw new TeleportException(TeleportStatusCode.STS_NO_PERMISSION, (Throwable)e);
            }
            log.error("[STS] error", (Throwable)e);
            throw new TeleportException(TeleportStatusCode.STS_ERROR, (Throwable)e);
        }
    }

    @Override
    public SecurityUserInfo getSLRUserInfo4DataWorks(StsProperties stsProperties) {
        String uid = stsProperties.getUid();
        String stsRole = stsProperties.getStsRole();
        String roleSessionName = stsProperties.getRoleSessionName();
        String region = stsProperties.getRegion();
        String stsEndpoint = stsProperties.getStsEndpoint();
        String roleArn = "acs:ram::" + uid + ":role/" + stsRole;
        log.info("[STS] try get SecurityUserInfo, uid={}, endpoint={}, role={}, roleSession={}, arn={}", new Object[]{uid, stsEndpoint, stsRole, roleSessionName, roleArn});
        SecurityUserInfo userInfo = new SecurityUserInfo();
        userInfo.setUid(uid);
        try {
            DefaultProfile.addEndpoint((String)"", (String)region, (String)"Sts", (String)stsEndpoint);
            DefaultAcsClient client = null;
            if (StringUtils.isNotBlank((CharSequence)stsProperties.getAklessRamRoleArn())) {
                profile = DefaultProfile.getProfile((String)region);
                AklessCredentialsProvider credentialsProvider = AklessCredProviderFactory.getCredentialsProvider((String)stsProperties.getAklessRamRoleArn());
                client = new DefaultAcsClient((IClientProfile)profile, (AlibabaCloudCredentialsProvider)credentialsProvider);
            } else {
                profile = DefaultProfile.getProfile((String)region, (String)stsProperties.getAccessKeyId(), (String)stsProperties.getAccessKeySecret());
                client = new DefaultAcsClient((IClientProfile)profile);
            }
            AssumeRoleWithServiceIdentityRequest request = new AssumeRoleWithServiceIdentityRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setAssumeRoleFor(uid);
            AssumeRoleWithServiceIdentityResponse response = (AssumeRoleWithServiceIdentityResponse)client.getAcsResponse((AcsRequest)request);
            AssumeRoleWithServiceIdentityResponse.Credentials credentials = response.getCredentials();
            userInfo.setAccessKeyId(credentials.getAccessKeyId());
            userInfo.setAccessKeySecret(credentials.getAccessKeySecret());
            userInfo.setSessionToken(credentials.getSecurityToken());
            userInfo.setExpireTime(credentials.getExpiration());
            return userInfo;
        }
        catch (Exception e) {
            String entityNotExist = "EntityNotExist.Role";
            String noPermission = "NoPermission";
            if (e.getLocalizedMessage().contains(entityNotExist) || e.getLocalizedMessage().contains(noPermission)) {
                log.error("[STS] NoPermission", (Throwable)e);
                throw new TeleportException(TeleportStatusCode.STS_NO_PERMISSION, (Throwable)e);
            }
            log.error("[STS] error", (Throwable)e);
            throw new TeleportException(TeleportStatusCode.STS_ERROR, (Throwable)e);
        }
    }
}

