/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.dataworks;

import java.util.Map;

public class DataWorksEndpoint {
    private String region;
    private String vpcEndpoint;
    private String publicEndpoint;
    private static final DataWorksEndpoint CN_HANGZHOU = new DataWorksEndpoint("cn-hangzhou", "dataworks-vpc.cn-hangzhou.aliyuncs.com", "dataworks.cn-hangzhou.aliyuncs.com");
    private static final DataWorksEndpoint AP_SOUTHEAST_1 = new DataWorksEndpoint("cn-hangzhou", "dataworks-vpc.ap-southeast-1.aliyuncs.com", "dataworks.ap-southeast-1.aliyuncs.com");
    private static final Map<String, DataWorksEndpoint> endpoints = Map.of("ap-southeast-1", AP_SOUTHEAST_1, "cn-hangzhou", CN_HANGZHOU);

    private DataWorksEndpoint(String region, String vpcEndpoint, String publicEndpoint) {
        this.region = region;
        this.vpcEndpoint = vpcEndpoint;
        this.publicEndpoint = publicEndpoint;
    }

    public static DataWorksEndpoint of(String region) {
        DataWorksEndpoint endpoint = endpoints.get(region);
        if (endpoint == null) {
            return DataWorksEndpoint.buildDefaultEndpoint(region);
        }
        return endpoint;
    }

    private static DataWorksEndpoint buildDefaultEndpoint(String region) {
        return new DataWorksEndpoint(region, String.format("dataworks-vpc.%s.aliyuncs.com", region), String.format("dataworks.%s.aliyuncs.com", region));
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setVpcEndpoint(String vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
    }

    public String getVpcEndpoint() {
        return this.vpcEndpoint;
    }

    public void setPublicEndpoint(String publicEndpoint) {
        this.publicEndpoint = publicEndpoint;
    }

    public String getPublicEndpoint() {
        return this.publicEndpoint;
    }
}

