/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.utils.PlaceholderUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.utils.TimePlaceholderUtils;
import com.aliyun.migrationx.common.utils.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ParameterUtils {
    private static final String DATE_PARSE_PATTERN = "\\$\\[([^\\$\\]]+)]";
    private static final String DATE_START_PATTERN = "^[0-9]";

    private ParameterUtils() {
        throw new UnsupportedOperationException("Construct ParameterUtils");
    }

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        Date cronTime;
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (parameterMap != null && null != parameterMap.get("system.datetime")) {
            String cronTimeStr = parameterMap.get("system.datetime");
            cronTime = DateUtils.parse((String)cronTimeStr, (String)"yyyyMMddHHmmss");
        } else {
            cronTime = new Date();
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    private static String dateTemplateParse(String templateStr, Date date) {
        if (templateStr == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(DATE_PARSE_PATTERN);
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = pattern.matcher(templateStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (Pattern.matches(DATE_START_PATTERN, key)) continue;
            String value = TimePlaceholderUtils.getPlaceHolderTime(key, date);
            assert (value != null);
            matcher.appendReplacement(newValue, value);
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }
}

