/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.PaginateResponse;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryDataSourceListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryProcessDefinitionByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryUdfFuncListByPaginateRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerApiV2Service
implements DolphinSchedulerApi {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerApiV2Service.class);
    private static final String HEADER_TOKEN = "token";
    private final String endpoint;
    private final String token;

    public DolphinSchedulerApiV2Service(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    private HttpGet newHttpGet(String url) throws URISyntaxException {
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String finalUrl = MessageFormat.format("{0}/dolphinscheduler/{1}", this.endpoint, url);
        httpGet.setURI(new URI(finalUrl));
        return httpGet;
    }

    private HttpPost newHttpPost(String url) throws URISyntaxException {
        HttpPost httpPost = new HttpPost();
        httpPost.setHeader(HEADER_TOKEN, this.token);
        String finalUrl = MessageFormat.format("{0}/dolphinscheduler/{1}", this.endpoint, url);
        httpPost.setURI(new URI(finalUrl));
        return httpPost;
    }

    public String getSuggestedFileName(Header contentDispositionHeader) {
        String value = contentDispositionHeader.getValue();
        return Arrays.stream(StringUtils.split((String)value, (String)";")).map(StringUtils::trim).filter(token -> StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"filename=")).findFirst().map(fileNamePart -> StringUtils.replace((String)fileNamePart, (String)"filename=", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"^\"", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"\"$", (String)"")).orElse(null);
    }

    @Override
    public Response<List<JsonObject>> queryAllProjectList(DolphinSchedulerRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String url = MessageFormat.format("{0}/dolphinscheduler/projects/list", this.endpoint);
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    @Override
    public PaginateResponse<JsonObject> queryUdfFuncListByPaging(QueryUdfFuncListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String url = String.format("%s/dolphinscheduler/resources/udf-func?pageNo=%s&pageSize=%s", this.endpoint, request.getPageNo(), request.getPageSize());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public PaginateResponse<JsonObject> queryDataSourceListByPaging(QueryDataSourceListByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String url = String.format("%s/dolphinscheduler/datasources?pageNo=%s&pageSize=%s", this.endpoint, request.getPageNo(), request.getPageSize());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    public PaginateResponse<JsonObject> queryProcessDefinitionByPaging(QueryProcessDefinitionByPaginateRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader(HEADER_TOKEN, this.token);
        String url = String.format("%s/dolphinscheduler/projects/%s/process-definition?pageNo=%s&pageSize=%s", this.endpoint, request.getProjectCode(), request.getPageNo(), request.getPageSize());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (PaginateResponse)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<PaginateResponse<JsonObject>>(){}.getType());
    }

    @Override
    public String batchExportProcessDefinitionByIds(BatchExportProcessDefinitionByIdsRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("projects/%s/process-definition/batch-export?codes=%s", request.getProjectCode(), Joiner.on((String)",").join((Iterable)ListUtils.emptyIfNull(request.getIds()).stream().distinct().collect(Collectors.toList())));
        return client.executeAndGet((HttpRequestBase)this.newHttpPost(url));
    }

    @Override
    public Response<List<JsonObject>> queryResourceList(QueryResourceListRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("resources/list?type=%s", request.getType());
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new com.google.common.reflect.TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    @Override
    public List<JsonElement> queryResourceListByPage(QueryResourceListRequest request, int pageNum, int pageSize) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("resources/list?type=%s", request.getType());
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        Response response = (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new com.google.common.reflect.TypeToken<Response<JsonArray>>(){}.getType());
        if (response.getCode() > 0) {
            log.error("response error {}", (Object)responseStr);
            return null;
        }
        return ((JsonArray)response.getData()).asList();
    }

    @Override
    public File downloadResource(DownloadResourceRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        String url = String.format("resources/%s/download", request.getId());
        HttpGet httpGet = this.newHttpGet(url);
        HttpResponse resp = client.executeAndGetHttpResponse((HttpRequestBase)httpGet);
        InputStream inputStream = resp.getEntity().getContent();
        String fileName = Stream.of(resp.getAllHeaders()).filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Content-Disposition")).findFirst().map(this::getSuggestedFileName).orElse(null);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String content = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8);
            Response response = (Response)GsonUtils.fromJsonString((String)content, (Type)new com.google.common.reflect.TypeToken<Response<Object>>(){}.getType());
            log.warn("download resource id: {} failed: {}", (Object)request.getId(), (Object)Optional.ofNullable(response).map(Response::getMsg).orElse(content));
            return null;
        }
        log.info("downloading file {}", (Object)fileName);
        File tmpFile = new File(request.getDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        log.info("finished downloading file {}", (Object)fileName);
        return tmpFile;
    }
}

