/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums;

public enum TaskType {
    SHELL(0, "shell"),
    SQL(1, "sql"),
    SUB_PROCESS(2, "sub_process"),
    PROCEDURE(3, "procedure"),
    MR(4, "mr"),
    SPARK(5, "spark"),
    PYTHON(6, "python"),
    DEPENDENT(7, "dependent"),
    FLINK(8, "flink"),
    HTTP(9, "http"),
    DATAX(10, "datax"),
    CONDITIONS(11, "conditions"),
    SQOOP(12, "sqoop");

    private final int code;
    private final String descp;

    private TaskType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static boolean typeIsNormalTask(String typeName) {
        TaskType taskType = TaskType.of(typeName);
        return taskType != SUB_PROCESS && taskType != DEPENDENT;
    }

    public static TaskType of(String typeName) {
        for (TaskType type : TaskType.values()) {
            if (!type.name().equalsIgnoreCase(typeName)) continue;
            return type;
        }
        throw new RuntimeException(String.format("no taskType with name %s", typeName));
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }
}

