/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.BaseDataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;

public class HiveDataSource
extends BaseDataSource {
    @Override
    public String driverClassSelector() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    @Override
    public DbType dbTypeSelector() {
        return DbType.HIVE;
    }

    @Override
    protected String filterOther(String otherParams) {
        String[] otherArray;
        if (StringUtils.isBlank((CharSequence)otherParams)) {
            return "";
        }
        StringBuilder hiveConfListSb = new StringBuilder();
        hiveConfListSb.append("?");
        StringBuilder sessionVarListSb = new StringBuilder();
        for (String conf : otherArray = otherParams.split(";", -1)) {
            hiveConfListSb.append(conf).append(";");
            sessionVarListSb.append(conf).append(";");
        }
        if (sessionVarListSb.length() > 0) {
            sessionVarListSb.deleteCharAt(sessionVarListSb.length() - 1);
        }
        if (hiveConfListSb.length() > 0) {
            hiveConfListSb.deleteCharAt(hiveConfListSb.length() - 1);
        }
        return sessionVarListSb.toString() + hiveConfListSb.toString();
    }

    @Override
    public Connection getConnection() throws Exception {
        return super.getConnection();
    }
}

