/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SparkArgsUtils {
    private static final String SPARK_CLUSTER = "cluster";
    private static final String SPARK_LOCAL = "local";
    private static final String SPARK_ON_YARN = "yarn";
    public static final String MASTER = "--master";
    public static final String DEPLOY_MODE = "--deploy-mode";
    public static final String MAIN_CLASS = "--class";
    public static final String DRIVER_CORES = "--driver-cores";
    public static final String DRIVER_MEMORY = "--driver-memory";
    public static final String NUM_EXECUTORS = "--num-executors";
    public static final String EXECUTOR_CORES = "--executor-cores";
    public static final String EXECUTOR_MEMORY = "--executor-memory";
    private static final String DEFAULT_QUALITY_CLASS = "org.apache.dolphinscheduler.data.quality.DataQualityApplication";
    public static final String SPARK_NAME = "--name";
    public static final String SPARK_QUEUE = "--queue";

    private SparkArgsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> buildArgs(SparkParameters param) {
        String mainArgs;
        ResourceInfo mainJar;
        String queue;
        String appName;
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        args.add(MASTER);
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)param.getDeployMode()) ? param.getDeployMode() : SPARK_CLUSTER;
        if (!SPARK_LOCAL.equals(deployMode)) {
            args.add(SPARK_ON_YARN);
            args.add(DEPLOY_MODE);
        }
        args.add(deployMode);
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(MAIN_CLASS);
            args.add(mainClass);
        }
        if ((driverCores = param.getDriverCores()) > 0) {
            args.add(DRIVER_CORES);
            args.add(String.format("%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = param.getDriverMemory()))) {
            args.add(DRIVER_MEMORY);
            args.add(driverMemory);
        }
        if ((numExecutors = param.getNumExecutors()) > 0) {
            args.add(NUM_EXECUTORS);
            args.add(String.format("%d", numExecutors));
        }
        if ((executorCores = param.getExecutorCores()) > 0) {
            args.add(EXECUTOR_CORES);
            args.add(String.format("%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = param.getExecutorMemory()))) {
            args.add(EXECUTOR_MEMORY);
            args.add(executorMemory);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(SPARK_NAME);
            args.add(ArgsUtils.escape(appName));
        }
        String others = param.getOthers();
        if (!SPARK_LOCAL.equals(deployMode) && (StringUtils.isEmpty((CharSequence)others) || !others.contains(SPARK_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(queue = param.getQueue()))) {
            args.add(SPARK_QUEUE);
            args.add(queue);
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if ((mainJar = param.getMainJar()) != null) {
            args.add(StringUtils.defaultString((String)mainJar.getRes(), (String)mainJar.getResourceName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    public static List<String> buildArgs(com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters param) {
        String mainArgs;
        com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo mainJar;
        String queue;
        String appName;
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        args.add(MASTER);
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)param.getDeployMode()) ? param.getDeployMode() : SPARK_CLUSTER;
        if (!SPARK_LOCAL.equals(deployMode)) {
            args.add(SPARK_ON_YARN);
            args.add(DEPLOY_MODE);
        }
        args.add(deployMode);
        com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType.PYTHON) {
            args.add(MAIN_CLASS);
            args.add(StringUtils.isNotEmpty((CharSequence)mainClass) ? mainClass : DEFAULT_QUALITY_CLASS);
        }
        if ((driverCores = param.getDriverCores()) > 0) {
            args.add(DRIVER_CORES);
            args.add(String.format("%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = param.getDriverMemory()))) {
            args.add(DRIVER_MEMORY);
            args.add(driverMemory);
        }
        if ((numExecutors = param.getNumExecutors()) > 0) {
            args.add(NUM_EXECUTORS);
            args.add(String.format("%d", numExecutors));
        }
        if ((executorCores = param.getExecutorCores()) > 0) {
            args.add(EXECUTOR_CORES);
            args.add(String.format("%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = param.getExecutorMemory()))) {
            args.add(EXECUTOR_MEMORY);
            args.add(executorMemory);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(SPARK_NAME);
            args.add(ArgsUtils.escape(appName));
        }
        String others = param.getOthers();
        if (!SPARK_LOCAL.equals(deployMode) && (StringUtils.isEmpty((CharSequence)others) || !others.contains(SPARK_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(queue = param.getYarnQueue()))) {
            args.add(SPARK_QUEUE);
            args.add(queue);
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if ((mainJar = param.getMainJar()) != null) {
            args.add(mainJar.getResourceName());
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }
}

