/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.PackageInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerPackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV3PackageLoader
extends DolphinSchedulerPackageLoader<Project, DagData, DataSource, ResourceComponent, UdfFunc> {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV3PackageLoader.class);
    private final DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage = new DolphinSchedulerPackage();

    public DolphinSchedulerV3PackageLoader(File packageRoot) {
        super(packageRoot);
    }

    @Override
    public DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> getDolphinSchedulerPackage() {
        return this.dolphinSchedulerPackage;
    }

    @Override
    public boolean support(DolphinSchedulerVersion version) {
        return DolphinSchedulerVersion.V2.equals((Object)version);
    }

    @Override
    public void loadPackage() throws IOException {
        this.dolphinSchedulerPackage.setPackageRoot(this.packageRoot);
        PackageInfo packageInfo = DolphinSchedulerV3PackageLoader.readPackageInfo(this.packageRoot);
        this.dolphinSchedulerPackage.setPackageInfo(packageInfo);
        List projects = this.readProjects(this.packageRoot, new TypeToken<List<Project>>(){}.getType());
        this.dolphinSchedulerPackage.setProjects(projects);
        File projectsDir = new File(this.packageRoot, "projects");
        if (projectsDir.exists()) {
            File[] subDirs = Optional.ofNullable(projectsDir.listFiles(File::isDirectory)).orElse(new File[0]);
            this.dolphinSchedulerPackage.setProcessDefinitions(Arrays.stream(subDirs).collect(Collectors.toMap(File::getName, projectDir -> this.readProcessMetaList(new File((File)projectDir, "processDefinition")))));
        }
        this.dolphinSchedulerPackage.setDatasources(this.readJsonFiles(new File(this.packageRoot, "datasource"), new TypeToken<List<DataSource>>(){}));
        this.dolphinSchedulerPackage.setResources(this.readJsonFiles(new File(this.packageRoot, "resource"), new TypeToken<List<ResourceComponent>>(){}));
        this.dolphinSchedulerPackage.setUdfFuncs(this.readJsonFiles(new File(this.packageRoot, "udfFunction"), new TypeToken<List<UdfFunc>>(){}));
        DolphinSchedulerV3Context.initContext(this.dolphinSchedulerPackage.getProjects(), this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList()), this.dolphinSchedulerPackage.getDatasources(), this.dolphinSchedulerPackage.getResources(), this.dolphinSchedulerPackage.getUdfFuncs());
    }

    private List<DagData> readProcessMetaList(File rootDir) {
        if (!rootDir.exists()) {
            log.warn("root directory not exits: {}", (Object)rootDir);
            return Collections.emptyList();
        }
        return Optional.ofNullable(rootDir.listFiles(f -> f.isFile() && f.getName().endsWith(".json"))).map(Arrays::asList).map(files -> files.stream().map(this::readProcessMetaJson).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<DagData> readProcessMetaJson(File jsonFile) {
        try {
            String json = FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
            return (List)JSONUtils.parseObject((String)json, (TypeReference)new TypeReference<List<DagData>>(){});
        }
        catch (IOException e) {
            log.error("read json file: {} error: ", (Object)jsonFile, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

