/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerPackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerV1Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV1PackageLoader
extends DolphinSchedulerPackageLoader<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV1PackageLoader.class);
    private final DolphinSchedulerPackage<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> dolphinSchedulerPackage = new DolphinSchedulerPackage();

    public DolphinSchedulerV1PackageLoader(File packageRoot) {
        super(packageRoot);
    }

    @Override
    public DolphinSchedulerPackage<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> getDolphinSchedulerPackage() {
        return this.dolphinSchedulerPackage;
    }

    @Override
    public boolean support(DolphinSchedulerVersion version) {
        return DolphinSchedulerVersion.V1.equals((Object)version);
    }

    @Override
    public void loadPackage() throws IOException {
        this.dolphinSchedulerPackage.setPackageRoot(this.packageRoot);
        this.dolphinSchedulerPackage.setPackageInfo(DolphinSchedulerV1PackageLoader.readPackageInfo(this.packageRoot));
        this.dolphinSchedulerPackage.setProjects(this.readProjects(this.packageRoot, new TypeToken<List<Project>>(){}.getType()));
        File projectsDir = new File(this.packageRoot, "projects");
        if (projectsDir.exists()) {
            File[] subDirs = Optional.ofNullable(projectsDir.listFiles(File::isDirectory)).orElse(new File[0]);
            this.dolphinSchedulerPackage.setProcessDefinitions(Arrays.stream(subDirs).collect(Collectors.toMap(File::getName, projectDir -> this.readProcessMetaList(new File((File)projectDir, "processDefinition")))));
        }
        this.dolphinSchedulerPackage.setDatasources(this.readJsonFiles(new File(this.packageRoot, "datasource"), new TypeToken<List<DataSource>>(){}));
        this.dolphinSchedulerPackage.setResources(this.readJsonFiles(new File(this.packageRoot, "resource"), new TypeToken<List<ResourceInfo>>(){}));
        this.dolphinSchedulerPackage.setUdfFuncs(this.readJsonFiles(new File(this.packageRoot, "udfFunction"), new TypeToken<List<UdfFunc>>(){}));
        AtomicInteger counter = new AtomicInteger(0);
        this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().forEach(s -> s.forEach(ss -> ss.getProcessDefinitionJson().getTasks().forEach(sss -> counter.incrementAndGet())));
        TransformerContext.getCollector().setTotalTasks(counter.get());
        DolphinSchedulerV1Context.initContext(this.dolphinSchedulerPackage.getProjects(), this.dolphinSchedulerPackage.getProcessDefinitions().values().stream().flatMap(Collection::stream).collect(Collectors.toList()), this.dolphinSchedulerPackage.getDatasources(), this.dolphinSchedulerPackage.getResources(), this.dolphinSchedulerPackage.getUdfFuncs());
    }

    private List<ProcessMeta> readProcessMetaList(File rootDir) {
        if (!rootDir.exists()) {
            log.info("root directory not exits: {}", (Object)rootDir);
            return ListUtils.emptyIfNull(null);
        }
        return Optional.ofNullable(rootDir.listFiles(f -> f.isFile() && f.getName().endsWith(".json"))).map(Arrays::asList).map(files -> files.stream().map(this::readProcessMetaJson).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList())).orElse(ListUtils.emptyIfNull(null));
    }

    private List<ProcessMeta> readProcessMetaJson(File jsonFile) {
        try {
            String json = FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
            return (List)GsonUtils.fromJsonString((String)json, (Type)new TypeToken<List<ProcessMeta>>(){}.getType());
        }
        catch (IOException e) {
            log.error("read json file: {} error: ", (Object)jsonFile, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

