/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerPackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.AbstractPackageFileService;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerPackageFileService
extends AbstractPackageFileService<DolphinSchedulerPackage> {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerPackageFileService.class);
    protected DolphinSchedulerPackage dolphinSchedulerPackage;

    protected boolean isProjectRoot(File file) {
        return file.isFile() && (StringUtils.equals((CharSequence)file.getName(), (CharSequence)"projects.json") || StringUtils.equals((CharSequence)file.getName(), (CharSequence)"package_info.json"));
    }

    public void load(DolphinSchedulerPackage dolphinSchedulerPackage) throws Exception {
        File unzippedDir = dolphinSchedulerPackage.getPackageFile().isFile() ? ZipUtils.decompress((File)dolphinSchedulerPackage.getPackageFile()) : dolphinSchedulerPackage.getPackageFile();
        Config.get().setSource(unzippedDir.getAbsolutePath());
        DolphinSchedulerPackageLoader loader = DolphinSchedulerPackageLoader.create(unzippedDir);
        loader.loadPackage();
        this.dolphinSchedulerPackage = loader.getDolphinSchedulerPackage();
    }

    public DolphinSchedulerPackage getPackage() throws Exception {
        return Optional.ofNullable(this.dolphinSchedulerPackage).orElseThrow(() -> new BizException(ErrorCode.PACKAGE_NOT_LOADED, new Object[0]));
    }

    public void write(DolphinSchedulerPackage pacakgeModelObject, File targetPackageFile) throws Exception {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

