/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.jmx;

import com.alibaba.securitysdk.logging.circuitbreaker.exception.MBeanLaunchException;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.DiskspaceImpl;
import com.alibaba.securitysdk.logging.circuitbreaker.jmx.InitiableDiskspaceMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;

public final class MBeanLauncher {
    private static final AtomicBoolean LAUNCHED = new AtomicBoolean(false);
    private static final InitiableDiskspaceMXBean DISKSPACE_MX_BEAN = new DiskspaceImpl();
    private static final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MBeanLauncher() {
    }

    public static void launch() {
        if (LAUNCHED.compareAndSet(false, true)) {
            try {
                DISKSPACE_MX_BEAN.initiate();
                platformMBeanServer.registerMBean(DISKSPACE_MX_BEAN, DISKSPACE_MX_BEAN.getObjectName());
            }
            catch (Exception ex) {
                throw new MBeanLaunchException("Cannot register MBEans", ex);
            }
        }
    }

    public static void unLaunch() {
        if (LAUNCHED.compareAndSet(true, false)) {
            try {
                platformMBeanServer.unregisterMBean(DISKSPACE_MX_BEAN.getObjectName());
            }
            catch (Exception ex) {
                throw new MBeanLaunchException("Cannot register MBEans", ex);
            }
        }
    }
}

