/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.event;

import com.alibaba.securitysdk.logging.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryThresholdCircuitBreakerEvent
implements ThresholdCircuitBreakerEvent<MemoryMXBean> {
    private MemoryMXBean memoryMXBean;
    private final double heapMemoryThreadHold;
    private final double nonHeapMemoryThreadHold;

    public MemoryThresholdCircuitBreakerEvent(double heapMemoryThreadHold, double nonHeapMemoryThreadHold) {
        this(heapMemoryThreadHold, nonHeapMemoryThreadHold, ManagementFactory.getMemoryMXBean());
    }

    public MemoryThresholdCircuitBreakerEvent(double heapMemoryThreadHold, double nonHeapMemoryThreadHold, MemoryMXBean memoryMXBean) {
        this.heapMemoryThreadHold = heapMemoryThreadHold;
        this.nonHeapMemoryThreadHold = nonHeapMemoryThreadHold;
        this.memoryMXBean = (MemoryMXBean)AssertUtil.notNull((Object)memoryMXBean);
    }

    @Override
    public boolean exceedThreshold() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        double heapMemoryRatio = (double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax();
        double nonHeapMemoryRatio = (double)nonHeapMemoryUsage.getUsed() / (double)nonHeapMemoryUsage.getMax();
        return this.heapMemoryThreadHold <= 0.0 && this.nonHeapMemoryThreadHold <= 0.0 || heapMemoryRatio > this.heapMemoryThreadHold || nonHeapMemoryRatio > this.nonHeapMemoryThreadHold;
    }

    @Override
    public MemoryMXBean getObject() {
        return this.memoryMXBean;
    }
}

