/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.breaker;

import com.alibaba.securitysdk.logging.circuitbreaker.CircuitBreaker;
import com.alibaba.securitysdk.logging.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.circuitbreaker.breaker.EventCountCircuitBreaker;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.util.concurrent.TimeUnit;

public class ThresholdEventCountCircuitBreaker<T extends ThresholdCircuitBreakerEvent>
implements CircuitBreaker<T> {
    private final EventCountCircuitBreaker circuitBreaker;
    private final Class<T> eventType;

    private ThresholdEventCountCircuitBreaker(EventCountCircuitBreaker circuitBreaker, Class<T> eventType) {
        this.circuitBreaker = circuitBreaker;
        this.eventType = eventType;
    }

    @Override
    public boolean isOpen() {
        return this.circuitBreaker.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.circuitBreaker.isClosed();
    }

    @Override
    public boolean checkState() {
        return this.circuitBreaker.checkState();
    }

    @Override
    public void close() {
        this.circuitBreaker.close();
    }

    @Override
    public void open() {
        this.circuitBreaker.open();
    }

    @Override
    public boolean checkState(T monitored) {
        if (this.eventType.isInstance(monitored)) {
            return this.incrementAndCheckState(monitored);
        }
        return this.checkState();
    }

    @Override
    public boolean incrementAndCheckState(T increment) {
        if (this.eventType.isInstance(increment) && increment.exceedThreshold()) {
            this.circuitBreaker.incrementAndCheckState(1);
        }
        return this.checkState();
    }

    @Override
    public Class<T> getValueClass() {
        return this.eventType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int openingEventTimes;
        private int closingEventTimes;
        private long openingInterval;
        private long closingInterval;
        private TimeUnit openingUnit;
        private TimeUnit closingUnit;
        private Class<? extends ThresholdCircuitBreakerEvent> valueType;

        public Builder setOpeningEventTimes(int openingEventTimes) {
            this.openingEventTimes = openingEventTimes;
            return this;
        }

        public Builder setClosingEventTimes(int closingEventTimes) {
            this.closingEventTimes = closingEventTimes;
            return this;
        }

        public Builder setOpeningInterval(long openingInterval) {
            this.openingInterval = openingInterval;
            return this;
        }

        public Builder setClosingInterval(long closingInterval) {
            this.closingInterval = closingInterval;
            return this;
        }

        public Builder setValueType(Class<? extends ThresholdCircuitBreakerEvent> valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder setOpeningUnit(TimeUnit openingUnit) {
            this.openingUnit = openingUnit;
            return this;
        }

        public Builder setClosingUnit(TimeUnit closingUnit) {
            this.closingUnit = closingUnit;
            return this;
        }

        public ThresholdEventCountCircuitBreaker build() {
            AssertUtil.checkArgument((this.openingEventTimes > 0 ? 1 : 0) != 0);
            AssertUtil.checkArgument((this.closingEventTimes > 0 ? 1 : 0) != 0);
            AssertUtil.checkArgument((this.openingInterval > 0L ? 1 : 0) != 0);
            AssertUtil.checkArgument((this.closingInterval > 0L ? 1 : 0) != 0);
            EventCountCircuitBreaker eventCountCircuitBreaker = new EventCountCircuitBreaker(this.openingEventTimes, this.openingInterval, (TimeUnit)((Object)AssertUtil.notNull((Object)((Object)this.openingUnit))), this.closingEventTimes, this.closingInterval, (TimeUnit)((Object)AssertUtil.notNull((Object)((Object)this.closingUnit))));
            return new ThresholdEventCountCircuitBreaker(eventCountCircuitBreaker, this.valueType);
        }
    }
}

