/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.breaker;

import com.alibaba.securitysdk.logging.circuitbreaker.breaker.AbstractCircuitBreaker;
import com.alibaba.securitysdk.logging.circuitbreaker.exception.CircuitBreakingException;
import java.util.concurrent.atomic.AtomicLong;

public class ThresholdCircuitBreaker
extends AbstractCircuitBreaker<Long> {
    private static final long INITIAL_COUNT = 0L;
    private final long threshold;
    private final AtomicLong used = new AtomicLong(0L);

    public ThresholdCircuitBreaker(long threshold) {
        this.threshold = threshold;
    }

    public long getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean checkState() throws CircuitBreakingException {
        return !this.isOpen();
    }

    @Override
    public boolean checkState(Long monitor) {
        if (this.threshold == 0L) {
            this.open();
        }
        this.used.set(monitor);
        if (this.used.get() > this.threshold) {
            return this.incrementAndCheckState(1L);
        }
        return this.checkState();
    }

    @Override
    public void close() {
        super.close();
        this.used.set(0L);
    }

    @Override
    public boolean incrementAndCheckState(Long increment) throws CircuitBreakingException {
        long used;
        if (this.threshold == 0L) {
            this.open();
        }
        if ((used = this.used.addAndGet(increment)) > this.threshold) {
            this.open();
        }
        return this.checkState();
    }

    @Override
    public Class<Long> getValueClass() {
        return Long.class;
    }
}

