/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.dw.dbr.converter;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrSparkPythonConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DbrSparkPythonConvert.class);

    public DbrSparkPythonConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DbrSparkPythonConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            workflowNode.setNodeType(CodeProgramType.ODPS_SPARK.getName());
            WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
            if (Objects.isNull(tgtworkflowNode)) {
                log.error("convert tgt node error, result is null");
                continue;
            }
            tgtworkflowNode.setNodeType(CodeProgramType.ODPS_SPARK.getName());
            String script = tgtworkflowNode.getScript();
            Map customProperties = tgtworkflowNode.getCustomProperties();
            OdpsSparkCode odpsSparkCode = this.populateSparkOdpsCode(script, customProperties);
            tgtworkflowNode.setScript(odpsSparkCode.toString());
            res.add(tgtworkflowNode);
        }
        return res;
    }

    private OdpsSparkCode populateSparkOdpsCode(String script, Map<String, Object> parameters) {
        if (MapUtils.isEmpty(parameters)) {
            log.error("py spark not found param {}", (Object)script);
            OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
            odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
            odpsSparkCode.getSparkJson().setVersion("3.2");
            odpsSparkCode.getSparkJson().setLanguage("python");
            return odpsSparkCode;
        }
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        Collection oriParameters = (Collection)parameters.get("spark_param");
        String filePath = (String)parameters.get("file_path");
        odpsSparkCode.setResourceReferences(List.of(filePath));
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        odpsSparkCode.getSparkJson().setMainJar(filePath);
        odpsSparkCode.getSparkJson().setMainClass(filePath);
        odpsSparkCode.getSparkJson().setVersion("3.2");
        odpsSparkCode.getSparkJson().setLanguage("python");
        List args = oriParameters.stream().toList();
        odpsSparkCode.getSparkJson().setConfigs(args);
        return odpsSparkCode;
    }
}

