/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.dw.dbr.converter;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.databricks.sdk.service.jobs.SparkJarTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrSparkJarConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DbrSparkJarConvert.class);

    public DbrSparkJarConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DbrSparkJarConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            return res;
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
            if (Objects.isNull(tgtworkflowNode)) {
                log.error("convert tgt node error, result is null");
                continue;
            }
            String script = tgtworkflowNode.getScript();
            SparkJarTask sparkJarTask = (SparkJarTask)BwmJsonUtil.parseObject((String)script, SparkJarTask.class);
            if (Objects.isNull(sparkJarTask)) continue;
            tgtworkflowNode.setNodeType(CodeProgramType.ODPS_SPARK.getName());
            OdpsSparkCode odpsSparkCode = this.populateSparkOdpsCode(sparkJarTask);
            tgtworkflowNode.setScript(odpsSparkCode.toString());
            res.add(tgtworkflowNode);
        }
        return res;
    }

    private OdpsSparkCode populateSparkOdpsCode(SparkJarTask sparkJarTask) {
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        String jarUri = sparkJarTask.getJarUri();
        odpsSparkCode.setResourceReferences(List.of(jarUri));
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        String mainJar = jarUri.substring(jarUri.lastIndexOf("/") + 1);
        odpsSparkCode.getSparkJson().setMainJar(mainJar);
        String mainClass = sparkJarTask.getMainClassName();
        odpsSparkCode.getSparkJson().setMainClass(mainClass);
        odpsSparkCode.getSparkJson().setVersion("3.2");
        odpsSparkCode.getSparkJson().setLanguage("java");
        Collection parameters = sparkJarTask.getParameters();
        if (CollectionUtils.isNotEmpty((Collection)parameters)) {
            List args = parameters.stream().toList();
            odpsSparkCode.getSparkJson().setConfigs(args);
        }
        return odpsSparkCode;
    }
}

