/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.dw.dbr.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrForeachConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DbrForeachConvert.class);

    public DbrForeachConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DbrForeachConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            return res;
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
            if (Objects.isNull(tgtworkflowNode)) {
                log.error("convert tgt node error, result is null");
                res.add(workflowNode);
                return res;
            }
            tgtworkflowNode.setNodeType(CodeProgramType.CONTROLLER_TRAVERSE.getName());
            tgtworkflowNode.setScript(this.workflow.getWorkflowId() + "_" + tgtworkflowNode.getNodeId());
            res.add(tgtworkflowNode);
        }
        return res;
    }
}

