/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.resource.impl;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.resource.MapResourceLoader;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import com.alibaba.securitysdk.resource.exception.ResourceSwapException;
import com.alibaba.securitysdk.resource.impl.CopyOnWriteMapWatchableFileResource;
import java.nio.file.Path;
import java.util.Map;

public class SwappableResourceBuilder<K, V> {
    private MapResourceLoader<K, V> resourceLoader;
    private boolean withInitializing;
    private Path path;

    public SwappableResourceBuilder<K, V> withResourceLoader(MapResourceLoader<K, V> resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    public SwappableResourceBuilder<K, V> withInitializing(boolean withInitializing) {
        this.withInitializing = withInitializing;
        return this;
    }

    public SwappableResourceBuilder<K, V> withPath(Path path) {
        this.path = path;
        return this;
    }

    public CopyOnWriteMapWatchableFileResource<K, V> buildCopyOnWriteMapWatchableFileResource() throws ResourceSwapException, ResourceLoadingException {
        AssertUtil.notNull(this.resourceLoader, (String)"Resource loader is required to set.");
        CopyOnWriteMapWatchableFileResource resource = new CopyOnWriteMapWatchableFileResource(this.resourceLoader);
        if (this.withInitializing) {
            resource.initialize((Map)this.resourceLoader.load(this.path));
        } else {
            resource.initialize(null);
        }
        return resource;
    }
}

