/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.resource.impl;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.resource.MapResourceLoader;
import com.alibaba.securitysdk.resource.TypedFileResourceLoader;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import com.alibaba.securitysdk.resource.impl.LockableResourceLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CompositeResourceLoader<R>
extends LockableResourceLoader<Map<String, R>>
implements MapResourceLoader<String, R> {
    private List<TypedFileResourceLoader<R>> resourceLoaders;
    private Path path;

    public CompositeResourceLoader(Path path, List<TypedFileResourceLoader<R>> resourceLoaders, boolean needLock) {
        super(needLock);
        AssertUtil.assertNotNull(resourceLoaders, (String)"ResourceLoaders should not be null");
        AssertUtil.assertNotNull((Object)path, (String)"path should not be null");
        AssertUtil.checkState((boolean)resourceLoaders.isEmpty(), (RuntimeException)new IllegalArgumentException("ResourceLoaders must contains at least one item"));
        this.checkIfDuplecate(resourceLoaders);
        this.resourceLoaders = resourceLoaders;
        this.path = path;
    }

    public CompositeResourceLoader(Path path, List<TypedFileResourceLoader<R>> resourceLoaders) {
        this(path, resourceLoaders, false);
    }

    public CompositeResourceLoader(Path path, boolean needLock, TypedFileResourceLoader<R> ... resourceLoaders) {
        this(path, Arrays.asList(resourceLoaders), needLock);
    }

    public CompositeResourceLoader(Path path, TypedFileResourceLoader<R> ... resourceLoaders) {
        this(path, Arrays.asList(resourceLoaders), false);
    }

    private void checkIfDuplecate(List<TypedFileResourceLoader<R>> resourceLoaders) {
        HashSet<Class<R>> types = new HashSet<Class<R>>();
        for (TypedFileResourceLoader<R> resourceLoader : resourceLoaders) {
            Path locationPath = resourceLoader.getLocation();
            if (this.path == null) {
                this.path = locationPath;
            } else if (!this.path.equals(locationPath)) {
                throw new IllegalArgumentException("Detected unequal path [" + this.path + ", " + locationPath + "]");
            }
            Class<R> type = resourceLoader.getType();
            if (types.contains(type)) {
                throw new IllegalArgumentException("Type [" + type + "] is duplicated.");
            }
            types.add(type);
        }
    }

    @Override
    public Path getLocation() {
        return this.path;
    }

    @Override
    protected Map<String, R> emptyResource() {
        return Collections.emptyMap();
    }

    @Override
    protected Map<String, R> load0(Path path) throws ResourceLoadingException {
        HashMap map = new HashMap();
        for (TypedFileResourceLoader<R> resourceLoader : this.resourceLoaders) {
            Object loadedResource = resourceLoader.load(path);
            map.put(resourceLoader.getType().getName(), loadedResource);
        }
        return map;
    }
}

