/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.event;

import com.aliyun.rapt.commons.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.event.EventFactory;
import com.aliyun.rapt.commons.circuitbreaker.event.MemoryThresholdCircuitBreakerEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryThresholdCircuitBreakerEventFactory
implements EventFactory<MemoryThresholdCircuitBreakerEvent> {
    private final double heapMemoryThreadHold;
    private final double nonHeapMemoryThreadHold;
    private final MemoryMXBean memoryMXBean;

    public MemoryThresholdCircuitBreakerEventFactory(double heapMemoryThreadHold, double nonHeapMemoryThreadHold) {
        this(heapMemoryThreadHold, nonHeapMemoryThreadHold, ManagementFactory.getMemoryMXBean());
    }

    public MemoryThresholdCircuitBreakerEventFactory(double heapMemoryThreadHold, double nonHeapMemoryThreadHold, MemoryMXBean memoryMXBean) {
        this.heapMemoryThreadHold = heapMemoryThreadHold;
        this.nonHeapMemoryThreadHold = nonHeapMemoryThreadHold;
        this.memoryMXBean = memoryMXBean;
    }

    @Override
    public ThresholdCircuitBreakerEvent createEvent() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        double heapMemoryRatio = (double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax();
        double nonHeapMemoryRatio = (double)nonHeapMemoryUsage.getUsed() / (double)nonHeapMemoryUsage.getMax();
        boolean exceedThreshold = this.heapMemoryThreadHold <= 0.0 && this.nonHeapMemoryThreadHold <= 0.0 || heapMemoryRatio > this.heapMemoryThreadHold || nonHeapMemoryRatio > this.nonHeapMemoryThreadHold;
        return new MemoryThresholdCircuitBreakerEvent(this.memoryMXBean, exceedThreshold);
    }
}

