/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.breaker;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakEventListener;
import com.aliyun.rapt.commons.circuitbreaker.CircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.breaker.EventCountCircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.util.AssertUtil;
import java.util.concurrent.TimeUnit;

public class ThresholdEventCountCircuitBreaker<T extends ThresholdCircuitBreakerEvent>
implements CircuitBreaker<T> {
    private CircuitBreakEventListener listener;
    private final EventCountCircuitBreaker circuitBreaker;
    private final Class<T> eventType;

    private ThresholdEventCountCircuitBreaker(EventCountCircuitBreaker circuitBreaker, Class<T> eventType) {
        this.circuitBreaker = circuitBreaker;
        this.eventType = eventType;
    }

    @Override
    public boolean isOpen() {
        return this.circuitBreaker.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.circuitBreaker.isClosed();
    }

    @Override
    public boolean checkState() {
        return this.circuitBreaker.checkState();
    }

    @Override
    public void close() {
        this.circuitBreaker.close();
        if (this.listener != null) {
            this.listener.statusChanged(this.checkState());
        }
    }

    @Override
    public void open() {
        this.circuitBreaker.open();
        if (this.listener != null) {
            this.listener.statusChanged(this.checkState());
        }
    }

    @Override
    public boolean incrementAndCheckState(T increment) {
        if (this.eventType.isInstance(increment)) {
            this.circuitBreaker.incrementAndCheckState(increment.exceedThreshold() ? 1 : 0);
        }
        return this.isClosed();
    }

    @Override
    public Class<T> getValueClass() {
        return this.eventType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setEventListener(CircuitBreakEventListener circuitBreakEventListener) {
        this.circuitBreaker.setEventListener(circuitBreakEventListener);
    }

    @Override
    public void shutdown() {
    }

    public static class Builder {
        private int openingEventTimes;
        private int closingEventTimes;
        private long openingInterval;
        private long closingInterval;
        private TimeUnit openingUnit;
        private TimeUnit closingUnit;
        private Class<? extends ThresholdCircuitBreakerEvent> valueType;

        public Builder setOpeningEventTimes(int openingEventTimes) {
            this.openingEventTimes = openingEventTimes;
            return this;
        }

        public Builder setClosingEventTimes(int closingEventTimes) {
            this.closingEventTimes = closingEventTimes;
            return this;
        }

        public Builder setOpeningInterval(long openingInterval) {
            this.openingInterval = openingInterval;
            return this;
        }

        public Builder setClosingInterval(long closingInterval) {
            this.closingInterval = closingInterval;
            return this;
        }

        public Builder setValueType(Class<? extends ThresholdCircuitBreakerEvent> valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder setOpeningUnit(TimeUnit openingUnit) {
            this.openingUnit = openingUnit;
            return this;
        }

        public Builder setClosingUnit(TimeUnit closingUnit) {
            this.closingUnit = closingUnit;
            return this;
        }

        public ThresholdEventCountCircuitBreaker build() {
            AssertUtil.checkArgument(this.openingEventTimes > 0);
            AssertUtil.checkArgument(this.closingEventTimes > 0);
            AssertUtil.checkArgument(this.openingInterval > 0L);
            AssertUtil.checkArgument(this.closingInterval > 0L);
            EventCountCircuitBreaker eventCountCircuitBreaker = new EventCountCircuitBreaker(this.openingEventTimes, this.openingInterval, AssertUtil.notNull(this.openingUnit), this.closingEventTimes, this.closingInterval, AssertUtil.notNull(this.closingUnit));
            return new ThresholdEventCountCircuitBreaker(eventCountCircuitBreaker, this.valueType);
        }
    }
}

