/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.breaker.CompositeCircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.breaker.ManualCircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.breaker.ThresholdEventCountCircuitBreaker;
import com.aliyun.rapt.commons.circuitbreaker.event.MemoryThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.event.MemoryThresholdCircuitBreakerEventFactory;
import com.aliyun.rapt.commons.circuitbreaker.event.OsThresholdCircuitBreakerEvent;
import com.aliyun.rapt.commons.circuitbreaker.event.OsThresholdCircuitBreakerEventFactory;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class CircuitBreakerMonitor {
    private static final Logger logger = SecurityLogManager.getLogger(CircuitBreakerMonitor.class);
    private static final double DEFAULT_CPU_LOAD_THRESHOLD = 0.7;
    private static final double DEFAULT_OS_MEMORY_RATIO = 0.8;
    private static final double DEFAULT_HEAP_MEMORY_RATIO = 1.0;
    private static final double DEFAULT_NON_HEAP_MEMORY_RATIO = 0.8;
    private static final int DEFAULT_OPENING_TIMES = 9;
    private static final int DEFAULT_CLOSING_TIMES = 3;
    private static final int DEFAULT_INTERVAL_SECONDS = 30;
    private static final long DEFAULT_SCHEDULE_DELAY_MS = 10000L;
    private static final long DEFAULT_SCHEDULE_PERIOD_MS = 3000L;
    private static final AtomicBoolean circuitBreakFlag = new AtomicBoolean(true);
    private static int intervalSeconds = 30;
    private Long scheduleDelayMs;
    private Long schedulePeriodMs;
    private final TimeUnit DEFAULT_INTERVAL_TIME_UNIT = TimeUnit.SECONDS;
    private final CompositeCircuitBreaker COMPOSITE_CIRCUIT_BREAKER;
    private final ConcurrentHashMap<String, CompositeCircuitBreaker> circuitBreakerMap = new ConcurrentHashMap();
    private OsThresholdCircuitBreakerEventFactory osThresholdCircuitBreakerEventFactory;
    private MemoryThresholdCircuitBreakerEventFactory memoryThresholdCircuitBreakerEventFactory;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static CircuitBreakerMonitor instance;
    private Timer scheduleEventTimer;

    CircuitBreakerMonitor() {
        this.COMPOSITE_CIRCUIT_BREAKER = new CompositeCircuitBreaker();
        this.osThresholdCircuitBreakerEventFactory = new OsThresholdCircuitBreakerEventFactory(0.7, 0.8);
        this.memoryThresholdCircuitBreakerEventFactory = new MemoryThresholdCircuitBreakerEventFactory(1.0, 0.8);
        this.registerThresholdEventCountCircuitBreakers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CircuitBreakerMonitor getInstance() {
        if (instance != null) return instance;
        Class<CircuitBreakerMonitor> clazz = CircuitBreakerMonitor.class;
        synchronized (CircuitBreakerMonitor.class) {
            if (instance != null) return instance;
            instance = new CircuitBreakerMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static void setIntervalSeconds(int intervalSeconds) {
        CircuitBreakerMonitor.intervalSeconds = intervalSeconds;
    }

    private void registerThresholdEventCountCircuitBreakers() {
        this.registerThresholdEventCountCircuitBreaker(OsThresholdCircuitBreakerEvent.class);
        this.registerThresholdEventCountCircuitBreaker(MemoryThresholdCircuitBreakerEvent.class);
    }

    private void registerThresholdEventCountCircuitBreaker(Class<? extends ThresholdCircuitBreakerEvent> eventClass) {
        this.COMPOSITE_CIRCUIT_BREAKER.registerCircuitBreaker(this.buildThresholdEventCountCircuitBreaker(eventClass));
    }

    private ThresholdEventCountCircuitBreaker buildThresholdEventCountCircuitBreaker(Class<? extends ThresholdCircuitBreakerEvent> eventClass) {
        return ThresholdEventCountCircuitBreaker.builder().setValueType(eventClass).setOpeningEventTimes(9).setOpeningInterval(intervalSeconds).setOpeningUnit(this.DEFAULT_INTERVAL_TIME_UNIT).setClosingEventTimes(3).setClosingInterval(intervalSeconds).setClosingUnit(this.DEFAULT_INTERVAL_TIME_UNIT).build();
    }

    private void fireEvents(List<CircuitBreakerEvent> events) {
        boolean flag = this.COMPOSITE_CIRCUIT_BREAKER.incrementAndCheckState(events);
        logger.debug("Circuit Breaker check event: {}, {}", (Object)events.size(), (Object)flag);
        if (circuitBreakFlag.compareAndSet(!flag, flag)) {
            logger.info("Circuit Breaker switch status: {}", (Object)(flag ? "true" : "false"));
        }
    }

    private void scheduleEventFiring() {
        this.scheduleEventTimer = new Timer("Circuit-Breaker", true);
        this.scheduleEventTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ArrayList<ThresholdCircuitBreakerEvent> circuitBreakerEvents = new ArrayList<ThresholdCircuitBreakerEvent>();
                ThresholdCircuitBreakerEvent osThresholdCircuitBreakerEvent = CircuitBreakerMonitor.this.osThresholdCircuitBreakerEventFactory.createEvent();
                ThresholdCircuitBreakerEvent memoryThresholdCircuitBreakerEvent = CircuitBreakerMonitor.this.memoryThresholdCircuitBreakerEventFactory.createEvent();
                circuitBreakerEvents.add(osThresholdCircuitBreakerEvent);
                circuitBreakerEvents.add(memoryThresholdCircuitBreakerEvent);
                CircuitBreakerMonitor.this.fireEvents(circuitBreakerEvents);
            }
        }, this.scheduleDelayMs, (long)this.schedulePeriodMs);
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.scheduleDelayMs = this.scheduleDelayMs == null ? 10000L : this.scheduleDelayMs;
            this.schedulePeriodMs = this.schedulePeriodMs == null ? 3000L : this.schedulePeriodMs;
            this.scheduleEventFiring();
        }
    }

    public void tryStart() throws TimeoutException {
        this.tryStart(10000L);
    }

    @Deprecated
    public void tryStart(long waitMs) throws TimeoutException {
        long endTime = waitMs + System.currentTimeMillis();
        do {
            if (endTime > System.currentTimeMillis()) {
                throw new TimeoutException();
            }
            this.start();
        } while (!this.COMPOSITE_CIRCUIT_BREAKER.isOpen());
    }

    public void shutdown() {
        if (this.scheduleEventTimer != null) {
            this.scheduleEventTimer.cancel();
        }
        for (CompositeCircuitBreaker cb : this.circuitBreakerMap.values()) {
            cb.shutdown();
        }
    }

    public CompositeCircuitBreaker getCircuitBreaker() {
        return this.COMPOSITE_CIRCUIT_BREAKER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeCircuitBreaker getCircuitBreaker(String indicatorFileName) {
        if (indicatorFileName == null || indicatorFileName.isEmpty()) {
            return this.COMPOSITE_CIRCUIT_BREAKER;
        }
        if (this.circuitBreakerMap.containsKey(indicatorFileName)) {
            return this.circuitBreakerMap.get(indicatorFileName);
        }
        Class<CircuitBreakerMonitor> clazz = CircuitBreakerMonitor.class;
        synchronized (CircuitBreakerMonitor.class) {
            ManualCircuitBreaker manualCircuitBreaker;
            try {
                manualCircuitBreaker = new ManualCircuitBreaker(indicatorFileName);
            }
            catch (IOException e) {
                logger.warn("can not create manual circuit breaker for indicator file: {}", (Object)indicatorFileName);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.COMPOSITE_CIRCUIT_BREAKER;
            }
            CompositeCircuitBreaker compositeCircuitBreaker = this.COMPOSITE_CIRCUIT_BREAKER.clone();
            compositeCircuitBreaker.registerCircuitBreaker(manualCircuitBreaker);
            this.circuitBreakerMap.put(indicatorFileName, compositeCircuitBreaker);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return compositeCircuitBreaker;
        }
    }

    public long getScheduleDelayMs() {
        return this.scheduleDelayMs;
    }

    public void setScheduleDelayMs(long scheduleDelayMs) {
        this.scheduleDelayMs = scheduleDelayMs;
    }

    public long getSchedulePeriodMs() {
        return this.schedulePeriodMs;
    }

    public void setSchedulePeriodMs(long schedulePeriodMs) {
        this.schedulePeriodMs = schedulePeriodMs;
    }

    public static class CircuitBreakingException
    extends RuntimeException {
        private static final long serialVersionUID = 1408176654686913340L;

        public CircuitBreakingException() {
        }

        public CircuitBreakingException(String message, Throwable cause) {
            super(message, cause);
        }

        public CircuitBreakingException(String message) {
            super(message);
        }

        public CircuitBreakingException(Throwable cause) {
            super(cause);
        }
    }
}

