/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.emr.convert.node;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SqlNodeConvert.class);
    private static String defaultType = CodeProgramType.MYSQL.name();

    public SqlNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        String codeProgramType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(codeProgramType);
        String dbType = CodeProgramType.of((String)codeProgramType).getCalcEngineType().name();
        tgtworkflowNode.setDbType(dbType);
        this.chooseDataSource(workflowNode, tgtworkflowNode, codeProgramType);
        if (!dbType.equals(CalcEngineType.ODPS.name()) && dbType.equals(CalcEngineType.EMR.name())) {
            tgtworkflowNode.setScript(SqlNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void chooseDataSource(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode, String codeProgramType) {
        try {
            String sqlParamStr = workflowNode.getCustomProperties().getOrDefault("SQL_PARAM", "").toString();
            if (StringUtils.isNotBlank((String)sqlParamStr)) {
                SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)sqlParamStr, (Type)TypeToken.get(SqlParameters.class).getType());
                if (tgtworkflowNode.getCustomProperties() == null) {
                    tgtworkflowNode.setCustomProperties(new HashMap());
                }
                tgtworkflowNode.getCustomProperties().put("datasource", this.getConnectionName(parameter, codeProgramType, tgtworkflowNode));
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private String getConnectionName(SqlParameters parameter, String codeProgramType, WorkflowNode workflowNode) {
        JSONObject sqlParam;
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        JSONObject nodeConnectionConf = nodeConfMap.getOrDefault("workflow.converter.connection.mapping", new JSONObject());
        if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("SQL_PARAM") && (sqlParam = JSONObject.parseObject((String)((String)workflowNode.getCustomProperties().get("SQL_PARAM")))) != null && sqlParam.containsKey("datasource")) {
            WorkflowDatasource datasource;
            Integer datasourceId = sqlParam.getInteger("datasource");
            if (this.taskContext.getWorkflowProjectPackage().getDatasources() != null && !this.taskContext.getWorkflowProjectPackage().getDatasources().isEmpty() && (datasource = this.taskContext.getWorkflowProjectPackage().getDatasources().stream().filter(s -> String.valueOf(s.getId()).equals(String.valueOf(datasourceId))).findFirst().orElseGet(null)) != null) {
                if (nodeConnectionConf.containsKey(datasource.getName())) {
                    return nodeConnectionConf.getString(datasource.getName());
                }
                return datasource.getName();
            }
        }
        return null;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        JSONObject jsonObject;
        String targetNodeType;
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.sql.submitAs", defaultType);
        if (orDefault instanceof JSONObject && StringUtils.isNotBlank((String)(targetNodeType = (jsonObject = (JSONObject)orDefault).getString(workflowNode.getDbType())))) {
            if (Arrays.stream(CodeProgramType.values()).collect(Collectors.toMap(Enum::name, CodeProgramType::getCalcEngineType)).containsKey(targetNodeType)) {
                return targetNodeType;
            }
            log.warn("sql\u8282\u70b9\u8c03\u5ea6\u8f6c\u6362\u914d\u7f6e\u9519\u8bef\uff0c\u4f7f\u7528\u4e86\u4e0d\u5b58\u5728\u7684\u8282\u70b9\u7c7b\u578b{}\uff0c\u9ed8\u8ba4\u4f7f\u7528{}\u4e3a\u8282\u70b9{}\u8f6c\u6362", new Object[]{targetNodeType, defaultType, workflowNode.getNodeName()});
        }
        return defaultType;
    }
}

